/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs;

import com.google.common.base.Supplier;
import java.net.InetSocketAddress;
import java.security.Permission;
import java.util.concurrent.TimeoutException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdfs.DFSClient;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.client.BlockReportOptions;
import org.apache.hadoop.hdfs.protocol.DatanodeID;
import org.apache.hadoop.hdfs.protocol.DatanodeInfo;
import org.apache.hadoop.hdfs.protocol.ExtendedBlock;
import org.apache.hadoop.hdfs.protocol.HdfsConstants;
import org.apache.hadoop.hdfs.server.blockmanagement.DatanodeDescriptor;
import org.apache.hadoop.hdfs.server.blockmanagement.DatanodeManager;
import org.apache.hadoop.hdfs.server.blockmanagement.DatanodeStorageInfo;
import org.apache.hadoop.hdfs.server.common.IncorrectVersionException;
import org.apache.hadoop.hdfs.server.common.StorageInfo;
import org.apache.hadoop.hdfs.server.datanode.DataNode;
import org.apache.hadoop.hdfs.server.datanode.DataNodeTestUtils;
import org.apache.hadoop.hdfs.server.namenode.FSNamesystem;
import org.apache.hadoop.hdfs.server.namenode.NameNodeAdapter;
import org.apache.hadoop.hdfs.server.protocol.DatanodeRegistration;
import org.apache.hadoop.hdfs.server.protocol.NamenodeProtocols;
import org.apache.hadoop.test.GenericTestUtils;
import org.apache.hadoop.util.VersionInfo;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;

public class TestDatanodeRegistration {
    public static final Log LOG = LogFactory.getLog(TestDatanodeRegistration.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDNSLookups() throws Exception {
        MonitorDNS sm = new MonitorDNS();
        System.setSecurityManager(sm);
        MiniDFSCluster cluster = null;
        try {
            HdfsConfiguration conf = new HdfsConfiguration();
            cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(8).build();
            cluster.waitActive();
            int initialLookups = sm.lookups;
            Assert.assertTrue((String)"dns security manager is active", (initialLookups != 0 ? 1 : 0) != 0);
            DatanodeManager dm = cluster.getNamesystem().getBlockManager().getDatanodeManager();
            dm.refreshNodes((Configuration)conf);
            Assert.assertEquals((long)initialLookups, (long)sm.lookups);
            dm.refreshNodes((Configuration)conf);
            Assert.assertEquals((long)initialLookups, (long)sm.lookups);
            dm.getDatanodeListForReport(HdfsConstants.DatanodeReportType.ALL);
            Assert.assertEquals((long)initialLookups, (long)sm.lookups);
            dm.getDatanodeListForReport(HdfsConstants.DatanodeReportType.LIVE);
            Assert.assertEquals((long)initialLookups, (long)sm.lookups);
            dm.getDatanodeListForReport(HdfsConstants.DatanodeReportType.DEAD);
            Assert.assertEquals((long)initialLookups, (long)sm.lookups);
        }
        finally {
            if (cluster != null) {
                cluster.shutdown();
            }
            System.setSecurityManager(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testChangeIpcPort() throws Exception {
        HdfsConfiguration conf = new HdfsConfiguration();
        MiniDFSCluster cluster = null;
        try {
            cluster = new MiniDFSCluster.Builder((Configuration)conf).build();
            InetSocketAddress addr = new InetSocketAddress("localhost", cluster.getNameNodePort());
            DFSClient client = new DFSClient(addr, (Configuration)conf);
            cluster.restartDataNodes();
            DatanodeInfo[] report = client.datanodeReport(HdfsConstants.DatanodeReportType.ALL);
            long firstUpdateAfterRestart = report[0].getLastUpdate();
            boolean gotHeartbeat = false;
            for (int i = 0; i < 10 && !gotHeartbeat; ++i) {
                try {
                    Thread.sleep(i * 1000);
                }
                catch (InterruptedException ie) {
                    // empty catch block
                }
                report = client.datanodeReport(HdfsConstants.DatanodeReportType.ALL);
                gotHeartbeat = report[0].getLastUpdate() > firstUpdateAfterRestart;
            }
            if (!gotHeartbeat) {
                Assert.fail((String)"Never got a heartbeat from restarted datanode.");
            }
            int realIpcPort = cluster.getDataNodes().get(0).getIpcPort();
            Assert.assertEquals((long)realIpcPort, (long)report[0].getIpcPort());
        }
        finally {
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testChangeStorageID() throws Exception {
        String DN_IP_ADDR = "127.0.0.1";
        String DN_HOSTNAME = "localhost";
        int DN_XFER_PORT = 12345;
        int DN_INFO_PORT = 12346;
        int DN_INFO_SECURE_PORT = 12347;
        int DN_IPC_PORT = 12348;
        HdfsConfiguration conf = new HdfsConfiguration();
        MiniDFSCluster cluster = null;
        try {
            cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(0).build();
            InetSocketAddress addr = new InetSocketAddress("localhost", cluster.getNameNodePort());
            DFSClient client = new DFSClient(addr, (Configuration)conf);
            NamenodeProtocols rpcServer = cluster.getNameNodeRpc();
            DatanodeID dnId = new DatanodeID("127.0.0.1", "localhost", "fake-datanode-id", 12345, 12346, 12347, 12348);
            long nnCTime = cluster.getNamesystem().getFSImage().getStorage().getCTime();
            StorageInfo mockStorageInfo = (StorageInfo)Mockito.mock(StorageInfo.class);
            ((StorageInfo)Mockito.doReturn((Object)nnCTime).when((Object)mockStorageInfo)).getCTime();
            ((StorageInfo)Mockito.doReturn((Object)HdfsConstants.DATANODE_LAYOUT_VERSION).when((Object)mockStorageInfo)).getLayoutVersion();
            DatanodeRegistration dnReg = new DatanodeRegistration(dnId, mockStorageInfo, null, VersionInfo.getVersion());
            rpcServer.registerDatanode(dnReg);
            DatanodeInfo[] report = client.datanodeReport(HdfsConstants.DatanodeReportType.ALL);
            Assert.assertEquals((String)"Expected a registered datanode", (long)1L, (long)report.length);
            dnId = new DatanodeID("127.0.0.1", "localhost", "changed-fake-datanode-id", 12345, 12346, 12347, 12348);
            dnReg = new DatanodeRegistration(dnId, mockStorageInfo, null, VersionInfo.getVersion());
            rpcServer.registerDatanode(dnReg);
            report = client.datanodeReport(HdfsConstants.DatanodeReportType.ALL);
            Assert.assertEquals((String)"Datanode with changed storage ID not recognized", (long)1L, (long)report.length);
        }
        finally {
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRegistrationWithDifferentSoftwareVersions() throws Exception {
        HdfsConfiguration conf = new HdfsConfiguration();
        conf.set("dfs.datanode.min.supported.namenode.version", "3.0.0");
        conf.set("dfs.namenode.min.supported.datanode.version", "3.0.0");
        MiniDFSCluster cluster = null;
        try {
            cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(0).build();
            NamenodeProtocols rpcServer = cluster.getNameNodeRpc();
            long nnCTime = cluster.getNamesystem().getFSImage().getStorage().getCTime();
            StorageInfo mockStorageInfo = (StorageInfo)Mockito.mock(StorageInfo.class);
            ((StorageInfo)Mockito.doReturn((Object)nnCTime).when((Object)mockStorageInfo)).getCTime();
            DatanodeRegistration mockDnReg = (DatanodeRegistration)Mockito.mock(DatanodeRegistration.class);
            ((DatanodeRegistration)Mockito.doReturn((Object)HdfsConstants.DATANODE_LAYOUT_VERSION).when((Object)mockDnReg)).getVersion();
            ((DatanodeRegistration)Mockito.doReturn((Object)"127.0.0.1").when((Object)mockDnReg)).getIpAddr();
            ((DatanodeRegistration)Mockito.doReturn((Object)123).when((Object)mockDnReg)).getXferPort();
            ((DatanodeRegistration)Mockito.doReturn((Object)"fake-storage-id").when((Object)mockDnReg)).getDatanodeUuid();
            ((DatanodeRegistration)Mockito.doReturn((Object)mockStorageInfo).when((Object)mockDnReg)).getStorageInfo();
            ((DatanodeRegistration)Mockito.doReturn((Object)"3.0.0").when((Object)mockDnReg)).getSoftwareVersion();
            rpcServer.registerDatanode(mockDnReg);
            ((DatanodeRegistration)Mockito.doReturn((Object)"4.0.0").when((Object)mockDnReg)).getSoftwareVersion();
            rpcServer.registerDatanode(mockDnReg);
            ((DatanodeRegistration)Mockito.doReturn((Object)"2.0.0").when((Object)mockDnReg)).getSoftwareVersion();
            try {
                rpcServer.registerDatanode(mockDnReg);
                Assert.fail((String)"Should not have been able to register DN with too-low version.");
            }
            catch (IncorrectVersionException ive) {
                GenericTestUtils.assertExceptionContains((String)"The reported DataNode version is too low", (Throwable)ive);
                LOG.info((Object)"Got expected exception", (Throwable)ive);
            }
        }
        finally {
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRegistrationWithDifferentSoftwareVersionsDuringUpgrade() throws Exception {
        HdfsConfiguration conf = new HdfsConfiguration();
        conf.set("dfs.datanode.min.supported.namenode.version", "1.0.0");
        MiniDFSCluster cluster = null;
        try {
            cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(0).build();
            NamenodeProtocols rpcServer = cluster.getNameNodeRpc();
            long nnCTime = cluster.getNamesystem().getFSImage().getStorage().getCTime();
            StorageInfo mockStorageInfo = (StorageInfo)Mockito.mock(StorageInfo.class);
            ((StorageInfo)Mockito.doReturn((Object)nnCTime).when((Object)mockStorageInfo)).getCTime();
            DatanodeRegistration mockDnReg = (DatanodeRegistration)Mockito.mock(DatanodeRegistration.class);
            ((DatanodeRegistration)Mockito.doReturn((Object)HdfsConstants.DATANODE_LAYOUT_VERSION).when((Object)mockDnReg)).getVersion();
            ((DatanodeRegistration)Mockito.doReturn((Object)"fake-storage-id").when((Object)mockDnReg)).getDatanodeUuid();
            ((DatanodeRegistration)Mockito.doReturn((Object)mockStorageInfo).when((Object)mockDnReg)).getStorageInfo();
            ((DatanodeRegistration)Mockito.doReturn((Object)VersionInfo.getVersion()).when((Object)mockDnReg)).getSoftwareVersion();
            ((DatanodeRegistration)Mockito.doReturn((Object)"127.0.0.1").when((Object)mockDnReg)).getIpAddr();
            ((DatanodeRegistration)Mockito.doReturn((Object)123).when((Object)mockDnReg)).getXferPort();
            rpcServer.registerDatanode(mockDnReg);
            ((StorageInfo)Mockito.doReturn((Object)(nnCTime + 1L)).when((Object)mockStorageInfo)).getCTime();
            rpcServer.registerDatanode(mockDnReg);
            ((DatanodeRegistration)Mockito.doReturn((Object)(VersionInfo.getVersion() + ".1")).when((Object)mockDnReg)).getSoftwareVersion();
            try {
                rpcServer.registerDatanode(mockDnReg);
                Assert.fail((String)"Should not have been able to register DN with different software versions and CTimes");
            }
            catch (IncorrectVersionException ive) {
                GenericTestUtils.assertExceptionContains((String)"does not match CTime of NN", (Throwable)ive);
                LOG.info((Object)"Got expected exception", (Throwable)ive);
            }
        }
        finally {
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }

    @Test
    public void testForcedRegistration() throws Exception {
        HdfsConfiguration conf = new HdfsConfiguration();
        conf.setInt("dfs.namenode.handler.count", 4);
        conf.setLong("dfs.blockreport.intervalMsec", Integer.MAX_VALUE);
        MiniDFSCluster cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(1).build();
        cluster.waitActive();
        cluster.getHttpUri(0);
        FSNamesystem fsn = cluster.getNamesystem();
        String bpId = fsn.getBlockPoolId();
        DataNode dn = cluster.getDataNodes().get(0);
        DatanodeDescriptor dnd = NameNodeAdapter.getDatanode(fsn, dn.getDatanodeId());
        DataNodeTestUtils.setHeartbeatsDisabledForTests(dn, true);
        DatanodeStorageInfo storage = dnd.getStorageInfos()[0];
        Assert.assertTrue((boolean)dnd.isRegistered());
        DatanodeRegistration lastReg = dn.getDNRegistrationForBP(bpId);
        this.waitForHeartbeat(dn, dnd);
        Assert.assertSame((Object)lastReg, (Object)dn.getDNRegistrationForBP(bpId));
        dnd.setForceRegistration(true);
        Assert.assertFalse((boolean)dnd.isRegistered());
        this.waitForHeartbeat(dn, dnd);
        Assert.assertTrue((boolean)dnd.isRegistered());
        DatanodeRegistration newReg = dn.getDNRegistrationForBP(bpId);
        Assert.assertNotSame((Object)lastReg, (Object)newReg);
        lastReg = newReg;
        this.waitForHeartbeat(dn, dnd);
        Assert.assertTrue((boolean)dnd.isRegistered());
        Assert.assertSame((Object)lastReg, (Object)dn.getDNRegistrationForBP(bpId));
        Assert.assertTrue((boolean)this.waitForBlockReport(dn, dnd));
        Assert.assertTrue((boolean)dnd.isRegistered());
        Assert.assertSame((Object)lastReg, (Object)dn.getDNRegistrationForBP(bpId));
        dnd.setForceRegistration(true);
        Assert.assertFalse((boolean)this.waitForBlockReport(dn, dnd));
        Assert.assertFalse((boolean)dnd.isRegistered());
        Assert.assertSame((Object)lastReg, (Object)dn.getDNRegistrationForBP(bpId));
        this.waitForHeartbeat(dn, dnd);
        Assert.assertTrue((boolean)dnd.isRegistered());
        newReg = dn.getDNRegistrationForBP(bpId);
        Assert.assertNotSame((Object)lastReg, (Object)newReg);
        lastReg = newReg;
        Assert.assertTrue((boolean)this.waitForBlockReport(dn, dnd));
        Assert.assertTrue((boolean)dnd.isRegistered());
        Assert.assertSame((Object)lastReg, (Object)dn.getDNRegistrationForBP(bpId));
        ExtendedBlock eb = new ExtendedBlock(bpId, 1234L);
        dn.notifyNamenodeDeletedBlock(eb, storage.getStorageID());
        DataNodeTestUtils.triggerDeletionReport(dn);
        Assert.assertTrue((boolean)dnd.isRegistered());
        Assert.assertSame((Object)lastReg, (Object)dn.getDNRegistrationForBP(bpId));
        boolean failed = false;
        try {
            fsn.processIncrementalBlockReport((DatanodeID)lastReg, null);
        }
        catch (NullPointerException npe) {
            failed = true;
        }
        Assert.assertTrue((String)"didn't fail", (boolean)failed);
        Assert.assertFalse((boolean)dnd.isRegistered());
        dn.notifyNamenodeDeletedBlock(eb, storage.getStorageID());
        DataNodeTestUtils.triggerDeletionReport(dn);
        Assert.assertFalse((boolean)dnd.isRegistered());
        Assert.assertSame((Object)lastReg, (Object)dn.getDNRegistrationForBP(bpId));
        this.waitForHeartbeat(dn, dnd);
        Assert.assertTrue((boolean)dnd.isRegistered());
        Assert.assertNotSame((Object)lastReg, (Object)dn.getDNRegistrationForBP(bpId));
    }

    private void waitForHeartbeat(DataNode dn, final DatanodeDescriptor dnd) throws Exception {
        final long lastUpdate = dnd.getLastUpdateMonotonic();
        Thread.sleep(1L);
        DataNodeTestUtils.setHeartbeatsDisabledForTests(dn, false);
        DataNodeTestUtils.triggerHeartbeat(dn);
        GenericTestUtils.waitFor((Supplier)new Supplier<Boolean>(){

            public Boolean get() {
                return lastUpdate != dnd.getLastUpdateMonotonic();
            }
        }, (int)10, (int)100000);
        DataNodeTestUtils.setHeartbeatsDisabledForTests(dn, true);
    }

    private boolean waitForBlockReport(DataNode dn, DatanodeDescriptor dnd) throws Exception {
        final DatanodeStorageInfo storage = dnd.getStorageInfos()[0];
        final long lastCount = storage.getBlockReportCount();
        dn.triggerBlockReport(new BlockReportOptions.Factory().setIncremental(false).build());
        try {
            GenericTestUtils.waitFor((Supplier)new Supplier<Boolean>(){

                public Boolean get() {
                    return lastCount != (long)storage.getBlockReportCount();
                }
            }, (int)10, (int)2000);
        }
        catch (TimeoutException te) {
            return false;
        }
        return true;
    }

    private static class MonitorDNS
    extends SecurityManager {
        int lookups = 0;

        private MonitorDNS() {
        }

        @Override
        public void checkPermission(Permission perm) {
        }

        @Override
        public void checkConnect(String host, int port) {
            if (port == -1) {
                ++this.lookups;
            }
        }
    }
}

