/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs;

import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.AppendTestUtil;
import org.apache.hadoop.hdfs.DFSClient;
import org.apache.hadoop.hdfs.DFSTestUtil;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.protocol.ClientProtocol;
import org.apache.hadoop.hdfs.protocol.DatanodeInfo;
import org.apache.hadoop.hdfs.protocol.ExtendedBlock;
import org.apache.hadoop.hdfs.protocol.LocatedBlocks;
import org.apache.hadoop.hdfs.server.datanode.DataNode;
import org.apache.hadoop.hdfs.server.namenode.FSDirectory;
import org.apache.hadoop.hdfs.server.namenode.INode;
import org.apache.hadoop.hdfs.server.namenode.INodeFile;
import org.apache.hadoop.hdfs.server.protocol.NamenodeProtocols;
import org.apache.hadoop.test.GenericTestUtils;
import org.apache.log4j.Level;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.stubbing.Answer;

public class TestFileAppend4 {
    static final Log LOG = LogFactory.getLog(TestFileAppend4.class);
    static final long BLOCK_SIZE = 1024L;
    static final long BBW_SIZE = 500L;
    static final Object[] NO_ARGS = new Object[0];
    Configuration conf;
    MiniDFSCluster cluster;
    Path file1;
    FSDataOutputStream stm;
    final boolean simulatedStorage = false;

    public TestFileAppend4() {
        DFSTestUtil.setNameNodeLogLevel(Level.ALL);
        GenericTestUtils.setLogLevel((Log)DataNode.LOG, (Level)Level.ALL);
        GenericTestUtils.setLogLevel((Log)DFSClient.LOG, (Level)Level.ALL);
    }

    @Before
    public void setUp() throws Exception {
        this.conf = new Configuration();
        this.conf.setInt("dfs.namenode.heartbeat.recheck-interval", 1000);
        this.conf.setInt("dfs.heartbeat.interval", 1);
        this.conf.setInt("dfs.client.socket-timeout", 5000);
        this.conf.setInt("dfs.namenode.replication.pending.timeout-sec", 5);
        this.conf.setInt("dfs.namenode.replication.interval", 1);
        this.conf.setInt("ipc.client.connect.max.retries", 1);
    }

    private void recoverFile(FileSystem fs) throws Exception {
        LOG.info((Object)"Recovering File Lease");
        this.cluster.setLeasePeriod(1000L, 3600000L);
        int tries = 60;
        boolean recovered = false;
        FSDataOutputStream out = null;
        while (!recovered && tries-- > 0) {
            try {
                out = fs.append(this.file1);
                LOG.info((Object)"Successfully opened for append");
                recovered = true;
            }
            catch (IOException e) {
                LOG.info((Object)"Failed open for append, waiting on lease recovery");
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException ex) {}
            }
        }
        if (out != null) {
            out.close();
        }
        if (!recovered) {
            Assert.fail((String)"Recovery should take < 1 min");
        }
        LOG.info((Object)"Past out lease recovery");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=60000L)
    public void testRecoverFinalizedBlock() throws Throwable {
        this.cluster = new MiniDFSCluster.Builder(this.conf).numDataNodes(5).build();
        try {
            this.cluster.waitActive();
            NamenodeProtocols preSpyNN = this.cluster.getNameNodeRpc();
            NamenodeProtocols spyNN = (NamenodeProtocols)Mockito.spy((Object)preSpyNN);
            GenericTestUtils.DelayAnswer delayer = new GenericTestUtils.DelayAnswer(LOG);
            ((NamenodeProtocols)Mockito.doAnswer((Answer)delayer).when((Object)spyNN)).complete(Matchers.anyString(), Matchers.anyString(), (ExtendedBlock)Matchers.anyObject(), Matchers.anyLong());
            DFSClient client = new DFSClient(null, (ClientProtocol)spyNN, this.conf, null);
            this.file1 = new Path("/testRecoverFinalized");
            final OutputStream stm = client.create("/testRecoverFinalized", true);
            AppendTestUtil.write(stm, 0, 4096);
            final AtomicReference err = new AtomicReference();
            Thread t = new Thread(){

                @Override
                public void run() {
                    try {
                        stm.close();
                    }
                    catch (Throwable t) {
                        err.set(t);
                    }
                }
            };
            t.start();
            LOG.info((Object)"Waiting for close to get to latch...");
            delayer.waitForCall();
            LOG.info((Object)"Killing lease checker");
            client.getLeaseRenewer().interruptAndJoin();
            DistributedFileSystem fs1 = this.cluster.getFileSystem();
            FileSystem fs2 = AppendTestUtil.createHdfsWithDifferentUsername(fs1.getConf());
            LOG.info((Object)"Recovering file");
            this.recoverFile(fs2);
            LOG.info((Object)"Telling close to proceed.");
            delayer.proceed();
            LOG.info((Object)"Waiting for close to finish.");
            t.join();
            LOG.info((Object)"Close finished.");
            Throwable thrownByClose = (Throwable)err.get();
            Assert.assertNotNull((Object)thrownByClose);
            Assert.assertTrue((boolean)(thrownByClose instanceof IOException));
            if (!thrownByClose.getMessage().contains("No lease on /testRecoverFinalized")) {
                throw thrownByClose;
            }
        }
        finally {
            this.cluster.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=60000L)
    public void testCompleteOtherLeaseHoldersFile() throws Throwable {
        this.cluster = new MiniDFSCluster.Builder(this.conf).numDataNodes(5).build();
        try {
            this.cluster.waitActive();
            NamenodeProtocols preSpyNN = this.cluster.getNameNodeRpc();
            NamenodeProtocols spyNN = (NamenodeProtocols)Mockito.spy((Object)preSpyNN);
            GenericTestUtils.DelayAnswer delayer = new GenericTestUtils.DelayAnswer(LOG);
            ((NamenodeProtocols)Mockito.doAnswer((Answer)delayer).when((Object)spyNN)).complete(Matchers.anyString(), Matchers.anyString(), (ExtendedBlock)Matchers.anyObject(), Matchers.anyLong());
            DFSClient client = new DFSClient(null, (ClientProtocol)spyNN, this.conf, null);
            this.file1 = new Path("/testCompleteOtherLease");
            final OutputStream stm = client.create("/testCompleteOtherLease", true);
            AppendTestUtil.write(stm, 0, 4096);
            final AtomicReference err = new AtomicReference();
            Thread t = new Thread(){

                @Override
                public void run() {
                    try {
                        stm.close();
                    }
                    catch (Throwable t) {
                        err.set(t);
                    }
                }
            };
            t.start();
            LOG.info((Object)"Waiting for close to get to latch...");
            delayer.waitForCall();
            LOG.info((Object)"Killing lease checker");
            client.getLeaseRenewer().interruptAndJoin();
            DistributedFileSystem fs1 = this.cluster.getFileSystem();
            FileSystem fs2 = AppendTestUtil.createHdfsWithDifferentUsername(fs1.getConf());
            LOG.info((Object)"Recovering file");
            this.recoverFile(fs2);
            LOG.info((Object)"Opening file for append from new fs");
            FSDataOutputStream appenderStream = fs2.append(this.file1);
            LOG.info((Object)"Writing some data from new appender");
            AppendTestUtil.write((OutputStream)appenderStream, 0, 4096);
            LOG.info((Object)"Telling old close to proceed.");
            delayer.proceed();
            LOG.info((Object)"Waiting for close to finish.");
            t.join();
            LOG.info((Object)"Close finished.");
            Throwable thrownByClose = (Throwable)err.get();
            Assert.assertNotNull((Object)thrownByClose);
            Assert.assertTrue((boolean)(thrownByClose instanceof IOException));
            if (!thrownByClose.getMessage().contains("Lease mismatch")) {
                throw thrownByClose;
            }
            appenderStream.close();
        }
        finally {
            this.cluster.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=60000L)
    public void testUpdateNeededReplicationsForAppendedFile() throws Exception {
        Configuration conf = new Configuration();
        MiniDFSCluster cluster = new MiniDFSCluster.Builder(conf).numDataNodes(1).build();
        DistributedFileSystem fileSystem = null;
        try {
            fileSystem = cluster.getFileSystem();
            Path f = new Path("/testAppend");
            FSDataOutputStream create = fileSystem.create(f, (short)2);
            create.write("/testAppend".getBytes());
            create.close();
            FSDataOutputStream append = fileSystem.append(f);
            append.write("/testAppend".getBytes());
            append.close();
            cluster.startDataNodes(conf, 1, true, null, null);
            DFSTestUtil.waitReplication((FileSystem)fileSystem, f, (short)2);
        }
        finally {
            if (null != fileSystem) {
                fileSystem.close();
            }
            cluster.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=60000L)
    public void testAppendInsufficientLocations() throws Exception {
        Configuration conf = new Configuration();
        conf.setInt("dfs.namenode.heartbeat.recheck-interval", 1000);
        conf.setInt("dfs.heartbeat.interval", 1);
        conf.setInt("dfs.client.socket-timeout", 3000);
        this.cluster = new MiniDFSCluster.Builder(conf).numDataNodes(4).build();
        DistributedFileSystem fileSystem = null;
        try {
            fileSystem = this.cluster.getFileSystem();
            Path f = new Path("/testAppend");
            FSDataOutputStream create = fileSystem.create(f, (short)2);
            create.write("/testAppend".getBytes());
            create.close();
            DFSTestUtil.waitReplication((FileSystem)fileSystem, f, (short)2);
            LocatedBlocks lbs = fileSystem.dfs.getNamenode().getBlockLocations("/testAppend", 0L, Long.MAX_VALUE);
            ArrayList<DataNode> dnsOfCluster = this.cluster.getDataNodes();
            DatanodeInfo[] dnsWithLocations = lbs.getLastLocatedBlock().getLocations();
            for (DataNode dn : dnsOfCluster) {
                for (DatanodeInfo loc : dnsWithLocations) {
                    if (!dn.getDatanodeId().equals((Object)loc)) continue;
                    dn.shutdown();
                    DFSTestUtil.waitForDatanodeDeath(dn);
                }
            }
            DFSTestUtil.waitReplication((FileSystem)fileSystem, f, (short)0);
            try {
                fileSystem.append(f);
                Assert.fail((String)"Append should fail because insufficient locations");
            }
            catch (IOException e) {
                LOG.info((Object)"Expected exception: ", (Throwable)e);
            }
            FSDirectory dir = this.cluster.getNamesystem().getFSDirectory();
            INodeFile inode = INodeFile.valueOf((INode)dir.getINode("/testAppend"), (String)"/testAppend");
            Assert.assertTrue((String)"File should remain closed", (!inode.isUnderConstruction() ? 1 : 0) != 0);
        }
        finally {
            if (null != fileSystem) {
                fileSystem.close();
            }
            this.cluster.shutdown();
        }
    }
}

