/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.BlockLocation;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FsShell;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.TestDFSShell;
import org.apache.hadoop.hdfs.server.datanode.SimulatedFSDataset;
import org.junit.Assert;
import org.junit.Test;

public class TestSetrepIncreasing {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void setrep(int fromREP, int toREP, boolean simulatedStorage) throws IOException {
        HdfsConfiguration conf = new HdfsConfiguration();
        if (simulatedStorage) {
            SimulatedFSDataset.setFactory((Configuration)conf);
        }
        conf.set("dfs.replication", "" + fromREP);
        conf.setLong("dfs.blockreport.intervalMsec", 1000L);
        conf.set("dfs.namenode.replication.pending.timeout-sec", Integer.toString(2));
        MiniDFSCluster cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(10).build();
        DistributedFileSystem fs = cluster.getFileSystem();
        Assert.assertTrue((String)("Not a HDFS: " + fs.getUri()), (boolean)(fs instanceof DistributedFileSystem));
        try {
            Path root = TestDFSShell.mkdir((FileSystem)fs, new Path("/test/setrep" + fromREP + "-" + toREP));
            Path f = TestDFSShell.writeFile((FileSystem)fs, new Path(root, "foo"));
            String[] args = new String[]{"-setrep", "-w", "" + toREP, "" + f};
            FsShell shell = new FsShell();
            shell.setConf((Configuration)conf);
            try {
                Assert.assertEquals((long)0L, (long)shell.run(args));
            }
            catch (Exception e) {
                Assert.assertTrue((String)("-setrep " + e), (boolean)false);
            }
            fs = cluster.getFileSystem();
            FileStatus file = fs.getFileStatus(f);
            long len = file.getLen();
            for (BlockLocation locations : fs.getFileBlockLocations(file, 0L, len)) {
                Assert.assertTrue((locations.getHosts().length == toREP ? 1 : 0) != 0);
            }
            TestDFSShell.show("done setrep waiting: " + root);
        }
        finally {
            try {
                fs.close();
            }
            catch (Exception e) {}
            cluster.shutdown();
        }
    }

    @Test(timeout=120000L)
    public void testSetrepIncreasing() throws IOException {
        TestSetrepIncreasing.setrep(3, 7, false);
    }

    @Test(timeout=120000L)
    public void testSetrepIncreasingSimulatedStorage() throws IOException {
        TestSetrepIncreasing.setrep(3, 7, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSetRepWithStoragePolicyOnEmptyFile() throws Exception {
        HdfsConfiguration conf = new HdfsConfiguration();
        MiniDFSCluster cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(1).build();
        DistributedFileSystem dfs = cluster.getFileSystem();
        try {
            Path d = new Path("/tmp");
            dfs.mkdirs(d);
            dfs.setStoragePolicy(d, "HOT");
            Path f = new Path(d, "foo");
            dfs.createNewFile(f);
            dfs.setReplication(f, (short)4);
        }
        finally {
            dfs.close();
            cluster.shutdown();
        }
    }
}

