/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode;

import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.server.namenode.FSDirectory;
import org.apache.hadoop.hdfs.server.namenode.FSNamesystem;
import org.apache.hadoop.hdfs.server.namenode.LeaseManager;
import org.apache.hadoop.hdfs.server.namenode.NameNodeAdapter;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;

public class TestLeaseManager {
    final Configuration conf = new HdfsConfiguration();

    @Test
    public void testRemoveLeaseWithPrefixPath() throws Exception {
        MiniDFSCluster cluster = new MiniDFSCluster.Builder(this.conf).numDataNodes(2).build();
        cluster.waitActive();
        LeaseManager lm = NameNodeAdapter.getLeaseManager(cluster.getNamesystem());
        lm.addLease("holder1", "/a/b");
        lm.addLease("holder2", "/a/c");
        Assert.assertNotNull((Object)lm.getLeaseByPath("/a/b"));
        Assert.assertNotNull((Object)lm.getLeaseByPath("/a/c"));
        lm.removeLeaseWithPrefixPath("/a");
        Assert.assertNull((Object)lm.getLeaseByPath("/a/b"));
        Assert.assertNull((Object)lm.getLeaseByPath("/a/c"));
        lm.addLease("holder1", "/a/b");
        lm.addLease("holder2", "/a/c");
        lm.removeLeaseWithPrefixPath("/a/");
        Assert.assertNull((Object)lm.getLeaseByPath("/a/b"));
        Assert.assertNull((Object)lm.getLeaseByPath("/a/c"));
    }

    @Test(timeout=1000L)
    public void testCheckLeaseNotInfiniteLoop() {
        FSDirectory dir = (FSDirectory)Mockito.mock(FSDirectory.class);
        FSNamesystem fsn = (FSNamesystem)Mockito.mock(FSNamesystem.class);
        Mockito.when((Object)fsn.isRunning()).thenReturn((Object)true);
        Mockito.when((Object)fsn.hasWriteLock()).thenReturn((Object)true);
        Mockito.when((Object)fsn.getFSDirectory()).thenReturn((Object)dir);
        LeaseManager lm = new LeaseManager(fsn);
        lm.setLeasePeriod(0L, 0L);
        lm.addLease("holder1", "src1");
        lm.addLease("holder2", "src2");
        lm.addLease("holder3", "src3");
        Assert.assertEquals((long)lm.getNumSortedLeases(), (long)3L);
        lm.checkLeases();
    }
}

