/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.web;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.InetSocketAddress;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.net.URISyntaxException;
import java.net.URL;
import java.security.PrivilegedExceptionAction;
import java.util.Random;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.logging.impl.Log4JLogger;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsAction;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.hdfs.DFSTestUtil;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.TestDFSClientRetries;
import org.apache.hadoop.hdfs.server.namenode.NameNode;
import org.apache.hadoop.hdfs.server.namenode.snapshot.SnapshotTestHelper;
import org.apache.hadoop.hdfs.server.namenode.web.resources.NamenodeWebHdfsMethods;
import org.apache.hadoop.hdfs.server.protocol.NamenodeProtocols;
import org.apache.hadoop.hdfs.web.WebHdfsFileSystem;
import org.apache.hadoop.hdfs.web.WebHdfsTestUtil;
import org.apache.hadoop.hdfs.web.resources.LengthParam;
import org.apache.hadoop.hdfs.web.resources.OffsetParam;
import org.apache.hadoop.hdfs.web.resources.Param;
import org.apache.hadoop.io.retry.RetryPolicy;
import org.apache.hadoop.ipc.RetriableException;
import org.apache.hadoop.security.AccessControlException;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.token.SecretManager;
import org.apache.hadoop.test.GenericTestUtils;
import org.apache.log4j.Level;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.internal.util.reflection.Whitebox;
import org.mockito.verification.VerificationMode;

public class TestWebHDFS {
    static final Log LOG = LogFactory.getLog(TestWebHDFS.class);
    static final Random RANDOM = new Random();
    static final long systemStartTime = System.nanoTime();
    public boolean attemptedRetry;

    @Test(timeout=300000L)
    public void testLargeFile() throws Exception {
        TestWebHDFS.largeFileTest(0xC800000L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void largeFileTest(long fileLength) throws Exception {
        Configuration conf = WebHdfsTestUtil.createConf();
        MiniDFSCluster cluster = new MiniDFSCluster.Builder(conf).numDataNodes(3).build();
        try {
            cluster.waitActive();
            WebHdfsFileSystem fs = WebHdfsTestUtil.getWebHdfsFileSystem(conf, "webhdfs");
            Path dir = new Path("/test/largeFile");
            Assert.assertTrue((boolean)fs.mkdirs(dir));
            byte[] data = new byte[0x100000];
            RANDOM.nextBytes(data);
            byte[] expected = new byte[2 * data.length];
            System.arraycopy(data, 0, expected, 0, data.length);
            System.arraycopy(data, 0, expected, data.length, data.length);
            Path p = new Path(dir, "file");
            Ticker t = new Ticker("WRITE", "fileLength=" + fileLength, new Object[0]);
            try (FSDataOutputStream out = fs.create(p);){
                int n;
                for (long remaining = fileLength; remaining > 0L; remaining -= (long)n) {
                    t.tick(fileLength - remaining, "remaining=%d", remaining);
                    n = (int)Math.min(remaining, (long)data.length);
                    out.write(data, 0, n);
                }
            }
            t.end(fileLength);
            Assert.assertEquals((long)fileLength, (long)fs.getFileStatus(p).getLen());
            long smallOffset = RANDOM.nextInt(0x100000) + 0x100000;
            long largeOffset = fileLength - smallOffset;
            byte[] buf = new byte[data.length];
            TestWebHDFS.verifySeek((FileSystem)fs, p, largeOffset, fileLength, buf, expected);
            TestWebHDFS.verifySeek((FileSystem)fs, p, smallOffset, fileLength, buf, expected);
            TestWebHDFS.verifyPread((FileSystem)fs, p, largeOffset, fileLength, buf, expected);
        }
        finally {
            cluster.shutdown();
        }
    }

    static void checkData(long offset, long remaining, int n, byte[] actual, byte[] expected) {
        if (RANDOM.nextInt(100) == 0) {
            int j = (int)(offset % (long)actual.length);
            for (int i = 0; i < n; ++i) {
                if (expected[j] != actual[i]) {
                    Assert.fail((String)("expected[" + j + "]=" + expected[j] + " != actual[" + i + "]=" + actual[i] + ", offset=" + offset + ", remaining=" + remaining + ", n=" + n));
                }
                ++j;
            }
        }
    }

    static void verifySeek(FileSystem fs, Path p, long offset, long length, byte[] buf, byte[] expected) throws IOException {
        long remaining = length - offset;
        long checked = 0L;
        LOG.info((Object)("XXX SEEK: offset=" + offset + ", remaining=" + remaining));
        Ticker t = new Ticker("SEEK", "offset=%d, remaining=%d", offset, remaining);
        FSDataInputStream in = fs.open(p, 65536);
        in.seek(offset);
        while (remaining > 0L) {
            t.tick(checked, "offset=%d, remaining=%d", offset, remaining);
            int n = (int)Math.min(remaining, (long)buf.length);
            in.readFully(buf, 0, n);
            TestWebHDFS.checkData(offset, remaining, n, buf, expected);
            offset += (long)n;
            remaining -= (long)n;
            checked += (long)n;
        }
        in.close();
        t.end(checked);
    }

    static void verifyPread(FileSystem fs, Path p, long offset, long length, byte[] buf, byte[] expected) throws IOException {
        long remaining = length - offset;
        long checked = 0L;
        LOG.info((Object)("XXX PREAD: offset=" + offset + ", remaining=" + remaining));
        Ticker t = new Ticker("PREAD", "offset=%d, remaining=%d", offset, remaining);
        FSDataInputStream in = fs.open(p, 65536);
        while (remaining > 0L) {
            t.tick(checked, "offset=%d, remaining=%d", offset, remaining);
            int n = (int)Math.min(remaining, (long)buf.length);
            in.readFully(offset, buf, 0, n);
            TestWebHDFS.checkData(offset, remaining, n, buf, expected);
            offset += (long)n;
            remaining -= (long)n;
            checked += (long)n;
        }
        in.close();
        t.end(checked);
    }

    @Test(timeout=300000L)
    public void testNamenodeRestart() throws Exception {
        ((Log4JLogger)NamenodeWebHdfsMethods.LOG).getLogger().setLevel(Level.ALL);
        Configuration conf = WebHdfsTestUtil.createConf();
        TestDFSClientRetries.namenodeRestartTest(conf, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=300000L)
    public void testLargeDirectory() throws Exception {
        final Configuration conf = WebHdfsTestUtil.createConf();
        int listLimit = 2;
        conf.setInt("dfs.ls.limit", 2);
        FsPermission.setUMask((Configuration)conf, (FsPermission)new FsPermission(63));
        MiniDFSCluster cluster = new MiniDFSCluster.Builder(conf).numDataNodes(3).build();
        try {
            cluster.waitActive();
            WebHdfsTestUtil.getWebHdfsFileSystem(conf, "webhdfs").setPermission(new Path("/"), new FsPermission(FsAction.ALL, FsAction.ALL, FsAction.ALL));
            UserGroupInformation.setLoginUser((UserGroupInformation)UserGroupInformation.createUserForTesting((String)"not-superuser", (String[])new String[]{"not-supergroup"}));
            UserGroupInformation.createUserForTesting((String)"me", (String[])new String[]{"my-group"}).doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Void>(){

                @Override
                public Void run() throws IOException, URISyntaxException {
                    WebHdfsFileSystem fs = WebHdfsTestUtil.getWebHdfsFileSystem(conf, "webhdfs");
                    Path d = new Path("/my-dir");
                    Assert.assertTrue((boolean)fs.mkdirs(d));
                    for (int i = 0; i < 6; ++i) {
                        Path p = new Path(d, "file-" + i);
                        Assert.assertTrue((boolean)fs.createNewFile(p));
                    }
                    Assert.assertEquals((long)6L, (long)fs.listStatus(d).length);
                    return null;
                }
            });
        }
        finally {
            cluster.shutdown();
        }
    }

    @Test(timeout=300000L)
    public void testNumericalUserName() throws Exception {
        final Configuration conf = WebHdfsTestUtil.createConf();
        conf.set("dfs.webhdfs.user.provider.user.pattern", "^[A-Za-z0-9_][A-Za-z0-9._-]*[$]?$");
        MiniDFSCluster cluster = new MiniDFSCluster.Builder(conf).numDataNodes(1).build();
        try {
            cluster.waitActive();
            WebHdfsTestUtil.getWebHdfsFileSystem(conf, "webhdfs").setPermission(new Path("/"), new FsPermission(FsAction.ALL, FsAction.ALL, FsAction.ALL));
            UserGroupInformation.createUserForTesting((String)"123", (String[])new String[]{"my-group"}).doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Void>(){

                @Override
                public Void run() throws IOException, URISyntaxException {
                    WebHdfsFileSystem fs = WebHdfsTestUtil.getWebHdfsFileSystem(conf, "webhdfs");
                    Path d = new Path("/my-dir");
                    Assert.assertTrue((boolean)fs.mkdirs(d));
                    return null;
                }
            });
        }
        finally {
            cluster.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=300000L)
    public void testCreateWithNoDN() throws Exception {
        MiniDFSCluster cluster = null;
        Configuration conf = WebHdfsTestUtil.createConf();
        try {
            cluster = new MiniDFSCluster.Builder(conf).numDataNodes(0).build();
            conf.setInt("dfs.replication", 1);
            cluster.waitActive();
            WebHdfsFileSystem fs = WebHdfsTestUtil.getWebHdfsFileSystem(conf, "webhdfs");
            fs.create(new Path("/testnodatanode"));
            Assert.fail((String)"No exception was thrown");
        }
        catch (IOException ex) {
            GenericTestUtils.assertExceptionContains((String)"Failed to find datanode", (Throwable)ex);
        }
        finally {
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }

    @Test
    public void testWebHdfsEnabledByDefault() throws Exception {
        HdfsConfiguration conf = new HdfsConfiguration();
        Assert.assertTrue((boolean)conf.getBoolean("dfs.webhdfs.enabled", false));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testWebHdfsCreateSnapshot() throws Exception {
        MiniDFSCluster cluster = null;
        Configuration conf = WebHdfsTestUtil.createConf();
        try {
            cluster = new MiniDFSCluster.Builder(conf).numDataNodes(0).build();
            cluster.waitActive();
            DistributedFileSystem dfs = cluster.getFileSystem();
            WebHdfsFileSystem webHdfs = WebHdfsTestUtil.getWebHdfsFileSystem(conf, "webhdfs");
            Path foo = new Path("/foo");
            dfs.mkdirs(foo);
            try {
                webHdfs.createSnapshot(foo);
                Assert.fail((String)"Cannot create snapshot on a non-snapshottable directory");
            }
            catch (Exception e) {
                GenericTestUtils.assertExceptionContains((String)"Directory is not a snapshottable directory", (Throwable)e);
            }
            dfs.allowSnapshot(foo);
            webHdfs.createSnapshot(foo, "s1");
            Path spath = webHdfs.createSnapshot(foo, null);
            Assert.assertTrue((boolean)webHdfs.exists(spath));
            Path s1path = SnapshotTestHelper.getSnapshotRoot(foo, "s1");
            Assert.assertTrue((boolean)webHdfs.exists(s1path));
        }
        finally {
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testWebHdfsDeleteSnapshot() throws Exception {
        MiniDFSCluster cluster = null;
        Configuration conf = WebHdfsTestUtil.createConf();
        try {
            cluster = new MiniDFSCluster.Builder(conf).numDataNodes(0).build();
            cluster.waitActive();
            DistributedFileSystem dfs = cluster.getFileSystem();
            WebHdfsFileSystem webHdfs = WebHdfsTestUtil.getWebHdfsFileSystem(conf, "webhdfs");
            Path foo = new Path("/foo");
            dfs.mkdirs(foo);
            dfs.allowSnapshot(foo);
            webHdfs.createSnapshot(foo, "s1");
            Path spath = webHdfs.createSnapshot(foo, null);
            Assert.assertTrue((boolean)webHdfs.exists(spath));
            Path s1path = SnapshotTestHelper.getSnapshotRoot(foo, "s1");
            Assert.assertTrue((boolean)webHdfs.exists(s1path));
            webHdfs.deleteSnapshot(foo, "s1");
            Assert.assertFalse((boolean)webHdfs.exists(s1path));
            webHdfs.deleteSnapshot(foo, spath.getName());
            Assert.assertFalse((boolean)webHdfs.exists(spath));
        }
        finally {
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testWebHdfsRenameSnapshot() throws Exception {
        MiniDFSCluster cluster = null;
        Configuration conf = WebHdfsTestUtil.createConf();
        try {
            cluster = new MiniDFSCluster.Builder(conf).numDataNodes(0).build();
            cluster.waitActive();
            DistributedFileSystem dfs = cluster.getFileSystem();
            WebHdfsFileSystem webHdfs = WebHdfsTestUtil.getWebHdfsFileSystem(conf, "webhdfs");
            Path foo = new Path("/foo");
            dfs.mkdirs(foo);
            dfs.allowSnapshot(foo);
            webHdfs.createSnapshot(foo, "s1");
            Path s1path = SnapshotTestHelper.getSnapshotRoot(foo, "s1");
            Assert.assertTrue((boolean)webHdfs.exists(s1path));
            webHdfs.renameSnapshot(foo, "s1", "s2");
            Assert.assertFalse((boolean)webHdfs.exists(s1path));
            Path s2path = SnapshotTestHelper.getSnapshotRoot(foo, "s2");
            Assert.assertTrue((boolean)webHdfs.exists(s2path));
            webHdfs.deleteSnapshot(foo, "s2");
            Assert.assertFalse((boolean)webHdfs.exists(s2path));
        }
        finally {
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRaceWhileNNStartup() throws Exception {
        MiniDFSCluster cluster = null;
        Configuration conf = WebHdfsTestUtil.createConf();
        try {
            cluster = new MiniDFSCluster.Builder(conf).numDataNodes(0).build();
            cluster.waitActive();
            NameNode namenode = cluster.getNameNode();
            NamenodeProtocols rpcServer = namenode.getRpcServer();
            Whitebox.setInternalState((Object)namenode, (String)"rpcServer", null);
            Path foo = new Path("/foo");
            WebHdfsFileSystem webHdfs = WebHdfsTestUtil.getWebHdfsFileSystem(conf, "webhdfs");
            try {
                webHdfs.mkdirs(foo);
                Assert.fail((String)"Expected RetriableException");
            }
            catch (RetriableException e) {
                GenericTestUtils.assertExceptionContains((String)"Namenode is in startup mode", (Throwable)e);
            }
            Whitebox.setInternalState((Object)namenode, (String)"rpcServer", (Object)rpcServer);
        }
        finally {
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDTInInsecureClusterWithFallback() throws IOException, URISyntaxException {
        MiniDFSCluster cluster = null;
        Configuration conf = WebHdfsTestUtil.createConf();
        conf.setBoolean("ipc.client.fallback-to-simple-auth-allowed", true);
        try {
            cluster = new MiniDFSCluster.Builder(conf).numDataNodes(0).build();
            WebHdfsFileSystem webHdfs = WebHdfsTestUtil.getWebHdfsFileSystem(conf, "webhdfs");
            Assert.assertNull((Object)webHdfs.getDelegationToken(null));
        }
        finally {
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDTInInsecureCluster() throws Exception {
        MiniDFSCluster cluster = null;
        Configuration conf = WebHdfsTestUtil.createConf();
        try {
            cluster = new MiniDFSCluster.Builder(conf).numDataNodes(0).build();
            WebHdfsFileSystem webHdfs = WebHdfsTestUtil.getWebHdfsFileSystem(conf, "webhdfs");
            webHdfs.getDelegationToken(null);
            Assert.fail((String)"No exception is thrown.");
        }
        catch (AccessControlException ace) {
            Assert.assertTrue((boolean)ace.getMessage().startsWith("The client is configured to only allow connecting to secure cluster"));
        }
        finally {
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testWebHdfsOffsetAndLength() throws Exception {
        MiniDFSCluster cluster = null;
        Configuration conf = WebHdfsTestUtil.createConf();
        int OFFSET = 42;
        int LENGTH = 512;
        String PATH = "/foo";
        byte[] CONTENTS = new byte[1024];
        RANDOM.nextBytes(CONTENTS);
        try {
            cluster = new MiniDFSCluster.Builder(conf).numDataNodes(1).build();
            WebHdfsFileSystem fs = WebHdfsTestUtil.getWebHdfsFileSystem(conf, "webhdfs");
            try (FSDataOutputStream os = fs.create(new Path("/foo"));){
                os.write(CONTENTS);
            }
            InetSocketAddress addr = cluster.getNameNode().getHttpAddress();
            URL url = new URL("http", addr.getHostString(), addr.getPort(), "/webhdfs/v1/foo?op=OPEN" + Param.toSortedString((String)"&", (Param[])new Param[]{new OffsetParam(Long.valueOf(42L)), new LengthParam(Long.valueOf(512L))}));
            HttpURLConnection conn = (HttpURLConnection)url.openConnection();
            conn.setInstanceFollowRedirects(true);
            Assert.assertEquals((long)512L, (long)conn.getContentLength());
            byte[] subContents = new byte[512];
            byte[] realContents = new byte[512];
            System.arraycopy(CONTENTS, 42, subContents, 0, 512);
            IOUtils.readFully((InputStream)conn.getInputStream(), (byte[])realContents);
            Assert.assertArrayEquals((byte[])subContents, (byte[])realContents);
        }
        finally {
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=90000L)
    public void testWebHdfsReadRetries() throws Exception {
        Configuration conf = WebHdfsTestUtil.createConf();
        Path dir = new Path("/testWebHdfsReadRetries");
        conf.setBoolean("dfs.client.retry.policy.enabled", true);
        conf.setInt("dfs.namenode.safemode.min.datanodes", 1);
        conf.setInt("dfs.blocksize", 524288);
        conf.setInt("dfs.replication", 1);
        boolean numDatanodes = true;
        MiniDFSCluster cluster = new MiniDFSCluster.Builder(conf).numDataNodes(1).build();
        try {
            cluster.waitActive();
            WebHdfsFileSystem fs = WebHdfsTestUtil.getWebHdfsFileSystem(conf, "webhdfs");
            long length = 0x100000L;
            Path file1 = new Path(dir, "testFile");
            DFSTestUtil.createFile((FileSystem)fs, file1, 0x100000L, (short)1, 20120406L);
            FileStatus s1 = fs.getFileStatus(file1);
            Assert.assertEquals((String)("Write failed for file " + file1), (long)0x100000L, (long)s1.getLen());
            FSDataInputStream in = fs.open(file1);
            Assert.assertTrue((String)"Input stream is not an instance of class WebHdfsInputStream", (boolean)(in.getWrappedStream() instanceof WebHdfsFileSystem.WebHdfsInputStream));
            int count = 0;
            while (in.read() != -1) {
                ++count;
            }
            Assert.assertEquals((String)("Read failed for file " + file1), (long)s1.getLen(), (long)count);
            Assert.assertEquals((String)"Sghould not be able to read beyond end of file", (long)in.read(), (long)-1L);
            in.close();
            try {
                in.read();
                Assert.fail((String)"Read after close should have failed");
            }
            catch (IOException ioe) {
                // empty catch block
            }
            WebHdfsFileSystem wfs = fs;
            String msg = "ReadRetries: Test Access Control Exception";
            this.testReadRetryExceptionHelper(wfs, file1, (IOException)((Object)new AccessControlException(msg)), msg, false, 1);
            msg = "ReadRetries: Test SocketTimeoutException";
            this.testReadRetryExceptionHelper(wfs, file1, new SocketTimeoutException(msg), msg, true, 5);
            msg = "ReadRetries: Test SocketException";
            this.testReadRetryExceptionHelper(wfs, file1, new SocketException(msg), msg, true, 5);
            msg = "ReadRetries: Test EOFException";
            this.testReadRetryExceptionHelper(wfs, file1, new EOFException(msg), msg, true, 5);
            msg = "ReadRetries: Test Generic IO Exception";
            this.testReadRetryExceptionHelper(wfs, file1, new IOException(msg), msg, true, 5);
            WebHdfsFileSystem spyfs = (WebHdfsFileSystem)Mockito.spy((Object)wfs);
            Mockito.when((Object)spyfs.replaceExpiredDelegationToken()).thenReturn((Object)true, (Object[])new Boolean[]{true, false});
            msg = "ReadRetries: Test Invalid Token Exception";
            this.testReadRetryExceptionHelper(spyfs, file1, (IOException)((Object)new SecretManager.InvalidToken(msg)), msg, false, 3);
        }
        finally {
            cluster.shutdown();
        }
    }

    private void testReadRetryExceptionHelper(WebHdfsFileSystem fs, Path fn, IOException ex, String msg, boolean shouldAttemptRetry, int numTimesTried) throws Exception {
        FSDataInputStream in = fs.open(fn);
        in.read();
        WebHdfsFileSystem.WebHdfsInputStream webIn = (WebHdfsFileSystem.WebHdfsInputStream)in.getWrappedStream();
        InputStream spyInputStream = (InputStream)Mockito.spy((Object)webIn.getReadRunner().getInputStream());
        ((InputStream)Mockito.doThrow((Throwable)ex).when((Object)spyInputStream)).read((byte[])Matchers.any(), Matchers.anyInt(), Matchers.anyInt());
        WebHdfsFileSystem.ReadRunner rr = (WebHdfsFileSystem.ReadRunner)Mockito.spy((Object)webIn.getReadRunner());
        ((WebHdfsFileSystem.ReadRunner)Mockito.doReturn((Object)spyInputStream).when((Object)rr)).initializeInputStream((HttpURLConnection)Matchers.any());
        rr.setInputStream(spyInputStream);
        webIn.setReadRunner(rr);
        final RetryPolicy.RetryAction retryAction = new RetryPolicy.RetryAction(RetryPolicy.RetryAction.RetryDecision.RETRY);
        final RetryPolicy.RetryAction failAction = new RetryPolicy.RetryAction(RetryPolicy.RetryAction.RetryDecision.FAIL);
        RetryPolicy rp = new RetryPolicy(){

            public RetryPolicy.RetryAction shouldRetry(Exception e, int retries, int failovers, boolean isIdempotentOrAtMostOnce) throws Exception {
                TestWebHDFS.this.attemptedRetry = true;
                if (retries > 3) {
                    return failAction;
                }
                return retryAction;
            }
        };
        fs.setRetryPolicy(rp);
        this.attemptedRetry = false;
        try {
            webIn.read();
            Assert.fail((String)(msg + ": Read should have thrown exception."));
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)e.getMessage().contains(msg));
        }
        Assert.assertEquals((String)(msg + ": Read should " + (shouldAttemptRetry ? "" : "not ") + "have called shouldRetry. "), (Object)this.attemptedRetry, (Object)shouldAttemptRetry);
        ((WebHdfsFileSystem.ReadRunner)Mockito.verify((Object)rr, (VerificationMode)Mockito.times((int)numTimesTried))).getResponse((HttpURLConnection)Matchers.any());
        webIn.close();
        in.close();
    }

    static class Ticker {
        final String name;
        final long startTime;
        private long previousTick;

        Ticker(String name, String format, Object ... args) {
            this.previousTick = this.startTime = System.nanoTime();
            this.name = name;
            LOG.info((Object)String.format("\n\n%s START: %s\n", name, String.format(format, args)));
        }

        void tick(long nBytes, String format, Object ... args) {
            long now = System.nanoTime();
            if (now - this.previousTick > 10000000000L) {
                this.previousTick = now;
                double mintues = (double)(now - systemStartTime) / 6.0E10;
                LOG.info((Object)String.format("\n\n%s %.2f min) %s %s\n", this.name, mintues, String.format(format, args), this.toMpsString(nBytes, now)));
            }
        }

        void end(long nBytes) {
            long now = System.nanoTime();
            double seconds = (double)(now - this.startTime) / 1.0E9;
            LOG.info((Object)String.format("\n\n%s END: duration=%.2fs %s\n", this.name, seconds, this.toMpsString(nBytes, now)));
        }

        String toMpsString(long nBytes, long now) {
            double mb = (double)nBytes / 1048576.0;
            double mps = mb * 1.0E9 / (double)(now - this.startTime);
            return String.format("[nBytes=%.2fMB, speed=%.2fMB/s]", mb, mps);
        }
    }
}

