/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn;

import java.io.IOException;
import java.net.InetSocketAddress;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.ipc.Server;
import org.apache.hadoop.net.NetUtils;
import org.apache.hadoop.yarn.api.ApplicationMasterProtocol;
import org.apache.hadoop.yarn.api.protocolrecords.AllocateRequest;
import org.apache.hadoop.yarn.api.protocolrecords.AllocateResponse;
import org.apache.hadoop.yarn.api.protocolrecords.FinishApplicationMasterRequest;
import org.apache.hadoop.yarn.api.protocolrecords.FinishApplicationMasterResponse;
import org.apache.hadoop.yarn.api.protocolrecords.RegisterApplicationMasterRequest;
import org.apache.hadoop.yarn.api.protocolrecords.RegisterApplicationMasterResponse;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.hadoop.yarn.exceptions.YarnRuntimeException;
import org.apache.hadoop.yarn.factories.impl.pb.RpcClientFactoryPBImpl;
import org.apache.hadoop.yarn.factories.impl.pb.RpcServerFactoryPBImpl;
import org.junit.Assert;
import org.junit.Test;

public class TestRPCFactories {
    @Test
    public void test() {
        this.testPbServerFactory();
        this.testPbClientFactory();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testPbServerFactory() {
        InetSocketAddress addr = new InetSocketAddress(0);
        Configuration conf = new Configuration();
        AMRMProtocolTestImpl instance = new AMRMProtocolTestImpl();
        Server server = null;
        try {
            server = RpcServerFactoryPBImpl.get().getServer(ApplicationMasterProtocol.class, (Object)instance, addr, conf, null, 1);
            server.start();
        }
        catch (YarnRuntimeException e) {
            e.printStackTrace();
            Assert.fail((String)"Failed to create server");
        }
        finally {
            if (server != null) {
                server.stop();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testPbClientFactory() {
        InetSocketAddress addr = new InetSocketAddress(0);
        System.err.println(addr.getHostName() + addr.getPort());
        Configuration conf = new Configuration();
        AMRMProtocolTestImpl instance = new AMRMProtocolTestImpl();
        Server server = null;
        try {
            server = RpcServerFactoryPBImpl.get().getServer(ApplicationMasterProtocol.class, (Object)instance, addr, conf, null, 1);
            server.start();
            System.err.println(server.getListenerAddress());
            System.err.println(NetUtils.getConnectAddress((Server)server));
            ApplicationMasterProtocol amrmClient = null;
            try {
                amrmClient = (ApplicationMasterProtocol)RpcClientFactoryPBImpl.get().getClient(ApplicationMasterProtocol.class, 1L, NetUtils.getConnectAddress((Server)server), conf);
            }
            catch (YarnRuntimeException e) {
                e.printStackTrace();
                Assert.fail((String)"Failed to create client");
            }
        }
        catch (YarnRuntimeException e) {
            e.printStackTrace();
            Assert.fail((String)"Failed to create server");
        }
        finally {
            if (server != null) {
                server.stop();
            }
        }
    }

    public class AMRMProtocolTestImpl
    implements ApplicationMasterProtocol {
        public RegisterApplicationMasterResponse registerApplicationMaster(RegisterApplicationMasterRequest request) throws YarnException, IOException {
            return null;
        }

        public FinishApplicationMasterResponse finishApplicationMaster(FinishApplicationMasterRequest request) throws YarnException, IOException {
            return null;
        }

        public AllocateResponse allocate(AllocateRequest request) throws YarnException, IOException {
            return null;
        }
    }
}

