/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.util;

import java.net.UnknownHostException;
import java.util.HashMap;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.net.NetUtils;
import org.apache.hadoop.yarn.webapp.util.WebAppUtils;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class TestWebAppUtils {
    private static final String RM1_NODE_ID = "rm1";
    private static final String RM2_NODE_ID = "rm2";
    private static String[] dummyHostNames = new String[]{"host1", "host2", "host3"};
    private static final String anyIpAddress = "1.2.3.4";
    private static Map<String, String> savedStaticResolution = new HashMap<String, String>();

    @BeforeClass
    public static void initializeDummyHostnameResolution() throws Exception {
        for (String hostName : dummyHostNames) {
            String previousIpAddress = NetUtils.getStaticResolution((String)hostName);
            if (null != previousIpAddress) {
                savedStaticResolution.put(hostName, previousIpAddress);
            }
            NetUtils.addStaticResolution((String)hostName, (String)anyIpAddress);
        }
    }

    @AfterClass
    public static void restoreDummyHostnameResolution() throws Exception {
        for (Map.Entry<String, String> hostnameToIpEntry : savedStaticResolution.entrySet()) {
            NetUtils.addStaticResolution((String)hostnameToIpEntry.getKey(), (String)hostnameToIpEntry.getValue());
        }
    }

    @Test
    public void TestRMWebAppURLRemoteAndLocal() throws UnknownHostException {
        Configuration configuration = new Configuration();
        String rmAddress = "host1:8088";
        configuration.set("yarn.resourcemanager.webapp.address", "host1:8088");
        String rm1Address = "host2:8088";
        String rm2Address = "host3:8088";
        configuration.set("yarn.resourcemanager.webapp.address.rm1", "host2:8088");
        configuration.set("yarn.resourcemanager.webapp.address.rm2", "host3:8088");
        configuration.setBoolean("yarn.resourcemanager.ha.enabled", true);
        configuration.set("yarn.resourcemanager.ha.rm-ids", "rm1,rm2");
        String rmRemoteUrl = WebAppUtils.getResolvedRemoteRMWebAppURLWithoutScheme((Configuration)configuration);
        Assert.assertEquals((String)"ResolvedRemoteRMWebAppUrl should resolve to the first HA RM address", (Object)"host2:8088", (Object)rmRemoteUrl);
        String rmLocalUrl = WebAppUtils.getResolvedRMWebAppURLWithoutScheme((Configuration)configuration);
        Assert.assertEquals((String)"ResolvedRMWebAppUrl should resolve to the default RM webapp address", (Object)"host1:8088", (Object)rmLocalUrl);
    }
}

