/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.util.resource;

import java.util.Arrays;
import java.util.Collection;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.util.resource.DefaultResourceCalculator;
import org.apache.hadoop.yarn.util.resource.DominantResourceCalculator;
import org.apache.hadoop.yarn.util.resource.ResourceCalculator;
import org.apache.hadoop.yarn.util.resource.Resources;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class TestResourceCalculator {
    private ResourceCalculator resourceCalculator;

    @Parameterized.Parameters
    public static Collection<ResourceCalculator[]> getParameters() {
        return Arrays.asList({new DefaultResourceCalculator()}, {new DominantResourceCalculator()});
    }

    public TestResourceCalculator(ResourceCalculator rs) {
        this.resourceCalculator = rs;
    }

    @Test(timeout=10000L)
    public void testResourceCalculatorCompareMethod() {
        Resource clusterResource = Resource.newInstance((int)0, (int)0);
        Resource lhs = Resource.newInstance((int)0, (int)0);
        Resource rhs = Resource.newInstance((int)0, (int)0);
        this.assertResourcesOperations(clusterResource, lhs, rhs, false, true, false, true, lhs, lhs);
        lhs = Resource.newInstance((int)1, (int)1);
        rhs = Resource.newInstance((int)0, (int)0);
        this.assertResourcesOperations(clusterResource, lhs, rhs, false, false, true, true, lhs, rhs);
        lhs = Resource.newInstance((int)0, (int)0);
        rhs = Resource.newInstance((int)1, (int)1);
        this.assertResourcesOperations(clusterResource, lhs, rhs, true, true, false, false, rhs, lhs);
        if (!(this.resourceCalculator instanceof DominantResourceCalculator)) {
            return;
        }
        lhs = Resource.newInstance((int)1, (int)0);
        rhs = Resource.newInstance((int)0, (int)1);
        this.assertResourcesOperations(clusterResource, lhs, rhs, false, true, false, true, lhs, lhs);
        lhs = Resource.newInstance((int)0, (int)1);
        rhs = Resource.newInstance((int)1, (int)0);
        this.assertResourcesOperations(clusterResource, lhs, rhs, false, true, false, true, lhs, lhs);
        lhs = Resource.newInstance((int)1, (int)1);
        rhs = Resource.newInstance((int)1, (int)0);
        this.assertResourcesOperations(clusterResource, lhs, rhs, false, false, true, true, lhs, rhs);
        lhs = Resource.newInstance((int)0, (int)1);
        rhs = Resource.newInstance((int)1, (int)1);
        this.assertResourcesOperations(clusterResource, lhs, rhs, true, true, false, false, rhs, lhs);
    }

    private void assertResourcesOperations(Resource clusterResource, Resource lhs, Resource rhs, boolean lessThan, boolean lessThanOrEqual, boolean greaterThan, boolean greaterThanOrEqual, Resource max, Resource min) {
        Assert.assertEquals((String)"Less Than operation is wrongly calculated.", (Object)lessThan, (Object)Resources.lessThan((ResourceCalculator)this.resourceCalculator, (Resource)clusterResource, (Resource)lhs, (Resource)rhs));
        Assert.assertEquals((String)"Less Than Or Equal To operation is wrongly calculated.", (Object)lessThanOrEqual, (Object)Resources.lessThanOrEqual((ResourceCalculator)this.resourceCalculator, (Resource)clusterResource, (Resource)lhs, (Resource)rhs));
        Assert.assertEquals((String)"Greater Than operation is wrongly calculated.", (Object)greaterThan, (Object)Resources.greaterThan((ResourceCalculator)this.resourceCalculator, (Resource)clusterResource, (Resource)lhs, (Resource)rhs));
        Assert.assertEquals((String)"Greater Than Or Equal To operation is wrongly calculated.", (Object)greaterThanOrEqual, (Object)Resources.greaterThanOrEqual((ResourceCalculator)this.resourceCalculator, (Resource)clusterResource, (Resource)lhs, (Resource)rhs));
        Assert.assertEquals((String)"Max(value) Operation wrongly calculated.", (Object)max, (Object)Resources.max((ResourceCalculator)this.resourceCalculator, (Resource)clusterResource, (Resource)lhs, (Resource)rhs));
        Assert.assertEquals((String)"Min(value) operation is wrongly calculated.", (Object)min, (Object)Resources.min((ResourceCalculator)this.resourceCalculator, (Resource)clusterResource, (Resource)lhs, (Resource)rhs));
    }
}

