/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.context.annotation;

import br.com.jorchestra.configuration.JOrchestraConfigurationProperties;
import br.com.jorchestra.dto.JOrchestraSystemEvent;
import com.hazelcast.core.Hazelcast;
import com.hazelcast.core.HazelcastInstance;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.DependsOn;
import org.springframework.context.event.ApplicationEventMulticaster;
import org.springframework.context.event.ContextClosedEvent;
import org.springframework.context.event.SimpleApplicationEventMulticaster;
import org.springframework.core.task.SimpleAsyncTaskExecutor;

@Configuration
@DependsOn(value={"jOrchestraAutoConfiguration"})
public class JOrchestaEventConguration {
    private static final Logger LOGGER = LoggerFactory.getLogger(JOrchestaEventConguration.class);
    @Autowired
    private ApplicationContext applicationContext;
    @Autowired
    private JOrchestraConfigurationProperties jorchestraConfigurationProperties;

    @Bean
    public HazelcastInstance hazelcastInstance() {
        return Hazelcast.getHazelcastInstanceByName((String)this.jorchestraConfigurationProperties.getClusterName());
    }

    @Bean(value={"jOrchestraEventMaps"})
    public Map<Class<?>, List<Consumer<JOrchestraSystemEvent>>> jOrchestraEventMaps() {
        return Collections.synchronizedMap(this.hashMap());
    }

    @Bean
    public ApplicationEventMulticaster simpleApplicationEventMulticaster() {
        SimpleApplicationEventMulticaster eventMulticaster = new SimpleApplicationEventMulticaster();
        eventMulticaster.setTaskExecutor((Executor)new SimpleAsyncTaskExecutor());
        return eventMulticaster;
    }

    private Map<Class<?>, List<Consumer<JOrchestraSystemEvent>>> hashMap() {
        HashMap map = new HashMap();
        ArrayList<Consumer<JOrchestraSystemEvent>> list = new ArrayList<Consumer<JOrchestraSystemEvent>>();
        list.add(event -> {
            LOGGER.info("m=accpet, JOrchestraName=" + this.jorchestraConfigurationProperties.getName() + ", msg=\"JOrchestra bye!");
            this.hazelcastInstance().shutdown();
        });
        map.put(ContextClosedEvent.class, list);
        Map eventClassList = this.jorchestraConfigurationProperties.getEventsClassMap();
        eventClassList.entrySet().parallelStream().forEach(entry -> ((List)entry.getValue()).parallelStream().forEach(action -> {
            List eventListenerList = (List)this.applicationContext.getBean(action, SaledClass.EVENT_LISTENER_SAFE_HANDLE);
            try {
                map.put(Class.forName((String)entry.getKey()), eventListenerList);
            }
            catch (ClassNotFoundException e) {
                LOGGER.warn("m=jOrchestraEventMaps, msg=\"create eventMap not put" + (String)entry.getKey() + ", verify correct class name in of your application.properties file!", (Throwable)e);
            }
        }));
        return map;
    }

    private static class SaledClass {
        private static Class<List<Consumer<JOrchestraSystemEvent>>> EVENT_LISTENER_SAFE_HANDLE = SaledClass.createClassTemplateEventLister().getClass();

        private SaledClass() {
        }

        private static List<Consumer<JOrchestraSystemEvent>> createClassTemplateEventLister() {
            return new ArrayList<Consumer<JOrchestraSystemEvent>>();
        }
    }
}

