/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.context.annotation;

import br.com.jorchestra.canonical.JOrchestraHandle;
import br.com.jorchestra.canonical.JOrchestraSignal;
import br.com.jorchestra.configuration.JOrchestraConfigurationProperties;
import br.com.jorchestra.controller.JOrchestraAdminWebSocket;
import br.com.jorchestra.controller.JOrchestraConversationWebSocketController;
import br.com.jorchestra.controller.JOrchestraMonitorWebSocket;
import br.com.jorchestra.service.JOrchestraBeans;
import br.com.jorchestra.util.JOrchestraContextUtils;
import com.hazelcast.config.Config;
import com.hazelcast.config.TopicConfig;
import com.hazelcast.core.Hazelcast;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.ITopic;
import com.hazelcast.core.MessageListener;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.servlet.config.annotation.DefaultServletHandlerConfigurer;
import org.springframework.web.servlet.config.annotation.EnableWebMvc;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurerAdapter;
import org.springframework.web.socket.WebSocketHandler;
import org.springframework.web.socket.config.annotation.EnableWebSocket;
import org.springframework.web.socket.config.annotation.WebSocketConfigurer;
import org.springframework.web.socket.config.annotation.WebSocketHandlerRegistry;

@Configuration(value="jOrchestraAutoConfiguration")
@EnableWebMvc
@EnableWebSocket
@EnableConfigurationProperties(value={JOrchestraConfigurationProperties.class})
public class JOrchestraAutoConfiguration
extends WebMvcConfigurerAdapter
implements WebSocketConfigurer {
    private static final Logger LOGGER = LoggerFactory.getLogger(JOrchestraAutoConfiguration.class);
    @Autowired
    private ApplicationContext applicationContext;
    @Autowired
    private JOrchestraConfigurationProperties jOrchestraConfigurationProperties;

    @Bean
    public JOrchestraBeans JOrchestraBeans() {
        return new JOrchestraBeans();
    }

    public void registerWebSocketHandlers(WebSocketHandlerRegistry webSocketHandlerRegistry) {
        LOGGER.info("m=registerWebSocketHandlers");
        JOrchestraContextUtils.setApplicationContext((ApplicationContext)this.applicationContext);
        JOrchestraMonitorWebSocket jOrchestraMonitorWebSocket = new JOrchestraMonitorWebSocket();
        JOrchestraAdminWebSocket jOrchestraAdminWebSocket = new JOrchestraAdminWebSocket(this.jOrchestraConfigurationProperties, JOrchestraContextUtils.getExecutorServiceMap());
        Config config = JOrchestraAutoConfiguration.hazelCastConfig(this.jOrchestraConfigurationProperties.getClusterName());
        List list = JOrchestraContextUtils.jorchestraHandleConsumer(jOrchestraHandle -> {
            JOrchestraSignal jOrchestraSignal = jOrchestraHandle.getjOrchestraSignal();
            this.registerJOrchestraPath((JOrchestraHandle)jOrchestraHandle, config, jOrchestraSignal);
        });
        HazelcastInstance hazelcastInstance = JOrchestraAutoConfiguration.hazelcastInstance(config);
        ITopic jOrchestraStateCallTopic = hazelcastInstance.getReliableTopic("jOrchestraStateCallTopic");
        jOrchestraStateCallTopic.addMessageListener((MessageListener)jOrchestraMonitorWebSocket);
        config.addTopicConfig(this.createConversationTopic());
        ITopic conversationTopic = hazelcastInstance.getTopic("jOrchestra-conversation");
        JOrchestraConversationWebSocketController joOrchestraConversationWebSocketController = new JOrchestraConversationWebSocketController(null, jOrchestraStateCallTopic, this.jOrchestraConfigurationProperties, conversationTopic);
        conversationTopic.addMessageListener((MessageListener)joOrchestraConversationWebSocketController);
        list.forEach(jOrchestraHandle -> {
            String jorchestraPath = jOrchestraHandle.getJOrchestraPath();
            JOrchestraSignal jOrchestraSignal = jOrchestraHandle.getjOrchestraSignal();
            Boolean reliable = jOrchestraHandle.isReliable();
            Class messageType = jOrchestraSignal.getMessageType();
            Class classType = jOrchestraSignal.getClassType();
            Object iService = jOrchestraSignal.createService(jorchestraPath, reliable, hazelcastInstance, messageType, classType);
            jOrchestraSignal.register(jOrchestraStateCallTopic, jorchestraPath, jOrchestraHandle, webSocketHandlerRegistry, this.jOrchestraConfigurationProperties, iService);
        });
        webSocketHandlerRegistry.addHandler((WebSocketHandler)jOrchestraMonitorWebSocket, new String[]{"jOrchestra-monitor"}).setAllowedOrigins(new String[]{this.jOrchestraConfigurationProperties.getAllowedOrigins()});
        webSocketHandlerRegistry.addHandler((WebSocketHandler)jOrchestraAdminWebSocket, new String[]{"jOrchestra-admin"}).setAllowedOrigins(new String[]{this.jOrchestraConfigurationProperties.getAllowedOrigins()});
        webSocketHandlerRegistry.addHandler((WebSocketHandler)joOrchestraConversationWebSocketController, new String[]{"jOrchestra-conversation"}).setAllowedOrigins(new String[]{this.jOrchestraConfigurationProperties.getAllowedOrigins()});
    }

    private TopicConfig createConversationTopic() {
        TopicConfig topicConfig = new TopicConfig("jOrchestra-conversation");
        topicConfig.setGlobalOrderingEnabled(true);
        return topicConfig;
    }

    public void configureDefaultServletHandling(DefaultServletHandlerConfigurer configurer) {
        LOGGER.info("m=configureDefaultServletHandling");
        configurer.enable();
    }

    private void registerJOrchestraPath(JOrchestraHandle jOrchestraHandle, Config config, JOrchestraSignal jOrchestraSignal) {
        String jorchestraPath = jOrchestraHandle.getJOrchestraPath();
        LOGGER.info("m=registerJOrchestraPath, jorchestraPath=" + jorchestraPath);
        jOrchestraSignal.addConfig(jorchestraPath, config);
    }

    private static Config hazelCastConfig(String memberName) {
        Config config = new Config(memberName);
        config.addTopicConfig(new TopicConfig("jOrchestraStateCallTopic"));
        return config;
    }

    private static HazelcastInstance hazelcastInstance(Config config) {
        return Hazelcast.getOrCreateHazelcastInstance((Config)config);
    }
}

