/*
 * Decompiled with CFR 0.152.
 */
package com.github.jinahya.bit.io;

import com.github.jinahya.bit.io.BitInput;
import com.github.jinahya.bit.io.BitIoConstraints;
import java.io.IOException;

public abstract class AbstractBitInput
implements BitInput {
    private int octet;
    private int available = 0;
    private long count;

    protected AbstractBitInput() {
    }

    protected abstract int read() throws IOException;

    private int unsigned8(int size) throws IOException {
        int required;
        BitIoConstraints.requireValidSizeUnsigned8(size);
        if (this.available == 0) {
            this.octet = this.read();
            assert (this.octet >= 0 && this.octet < 256);
            ++this.count;
            this.available = 8;
        }
        if ((required = size - this.available) > 0) {
            return this.unsigned8(this.available) << required | this.unsigned8(required);
        }
        this.available -= size;
        return this.octet >> this.available & (1 << size) - 1;
    }

    @Override
    public boolean readBoolean() throws IOException {
        return this.readInt(true, 1) == 1;
    }

    @Override
    public byte readByte(boolean unsigned, int size) throws IOException {
        return (byte)this.readInt(unsigned, BitIoConstraints.requireValidSizeByte(unsigned, size));
    }

    @Override
    public byte readByte8() throws IOException {
        return this.readByte(false, 8);
    }

    @Override
    public short readShort(boolean unsigned, int size) throws IOException {
        return (short)this.readInt(unsigned, BitIoConstraints.requireValidSizeShort(unsigned, size));
    }

    @Override
    public short readShort16() throws IOException {
        return this.readShort(false, 16);
    }

    @Override
    public short readShort16Le() throws IOException {
        return (short)(this.readByte8() & 0xFF | this.readByte8() << 8);
    }

    @Override
    public int readInt(boolean unsigned, int size) throws IOException {
        BitIoConstraints.requireValidSizeInt(unsigned, size);
        int value = 0;
        if (!unsigned) {
            value -= this.readInt(true, 1);
            if (--size > 0) {
                value <<= size;
                value |= this.readInt(true, size);
            }
            return value;
        }
        while (size >= 8) {
            value <<= 8;
            value |= this.unsigned8(8);
            size -= 8;
        }
        if (size > 0) {
            value <<= size;
            value |= this.unsigned8(size);
        }
        return value;
    }

    @Override
    public int readInt32() throws IOException {
        return this.readInt(false, 32);
    }

    @Override
    public int readInt32Le() throws IOException {
        return this.readShort16Le() & 0xFFFF | this.readShort16Le() << 16;
    }

    @Override
    public long readLong(boolean unsigned, int size) throws IOException {
        BitIoConstraints.requireValidSizeLong(unsigned, size);
        long value = 0L;
        if (!unsigned) {
            value -= this.readLong(true, 1);
            if (--size > 0) {
                value <<= size;
                value |= this.readLong(true, size);
            }
            return value;
        }
        if (size >= 32) {
            value = (long)this.readInt(false, 32) & 0xFFFFFFFFL;
            size -= 32;
        }
        if (size > 0) {
            value <<= size;
            value |= (long)this.readInt(true, size);
        }
        return value;
    }

    @Override
    public long readLong64() throws IOException {
        return this.readLong(false, 64);
    }

    @Override
    public long readLong64Le() throws IOException {
        return (long)this.readInt32Le() & 0xFFFFFFFFL | (long)this.readInt32Le() << 32;
    }

    @Override
    public char readChar(int size) throws IOException {
        return (char)this.readInt(true, BitIoConstraints.requireValidSizeChar(size));
    }

    @Override
    public char readChar16() throws IOException {
        return this.readChar(16);
    }

    @Override
    public void skip(int bits) throws IOException {
        if (bits <= 0) {
            throw new IllegalArgumentException("bits(" + bits + ") <= 0");
        }
        while (bits >= 32) {
            this.readInt(false, 32);
            bits -= 32;
        }
        if (bits > 0) {
            this.readInt(true, bits);
        }
    }

    @Override
    public long align(int bytes) throws IOException {
        if (bytes <= 0) {
            throw new IllegalArgumentException("bytes(" + bytes + ") <= 0");
        }
        long bits = 0L;
        if (this.available > 0) {
            bits += (long)this.available;
            this.readInt(true, this.available);
        }
        if (bytes == 1) {
            return bits;
        }
        bytes -= (int)(this.count % (long)bytes);
        while ((long)bytes > 0L) {
            this.readInt(true, 8);
            bits += 8L;
            --bytes;
        }
        return bits;
    }
}

