/*
 * Decompiled with CFR 0.152.
 */
package com.github.jinahya.bit.io;

import com.github.jinahya.bit.io.BitIoConstraints;
import com.github.jinahya.bit.io.BitOutput;
import java.io.IOException;

public abstract class AbstractBitOutput
implements BitOutput {
    private int octet;
    private int available = 8;
    private long count;

    protected AbstractBitOutput() {
    }

    protected abstract void write(int var1) throws IOException;

    private void unsigned8(int size, int value) throws IOException {
        BitIoConstraints.requireValidSizeUnsigned8(size);
        int required = size - this.available;
        if (required > 0) {
            this.unsigned8(this.available, value >> required);
            this.unsigned8(required, value);
            return;
        }
        this.octet <<= size;
        this.octet |= value & (1 << size) - 1;
        this.available -= size;
        if (this.available == 0) {
            assert (this.octet >= 0 && this.octet < 256);
            this.write(this.octet);
            ++this.count;
            this.octet = 0;
            this.available = 8;
        }
    }

    @Override
    public void writeBoolean(boolean value) throws IOException {
        this.writeInt(true, 1, value ? 1 : 0);
    }

    @Override
    public void writeByte(boolean unsigned, int size, byte value) throws IOException {
        this.writeInt(unsigned, BitIoConstraints.requireValidSizeByte(unsigned, size), value);
    }

    @Override
    public void writeByte8(byte value) throws IOException {
        this.writeByte(false, 8, value);
    }

    @Override
    public void writeShort(boolean unsigned, int size, short value) throws IOException {
        this.writeInt(unsigned, BitIoConstraints.requireValidSizeShort(unsigned, size), value);
    }

    @Override
    public void writeShort16(short value) throws IOException {
        this.writeShort(false, 16, value);
    }

    @Override
    public void writeShort16Le(short value) throws IOException {
        this.writeByte8((byte)value);
        this.writeByte8((byte)(value >> 8));
    }

    @Override
    public void writeInt(boolean unsigned, int size, int value) throws IOException {
        BitIoConstraints.requireValidSizeInt(unsigned, size);
        if (!unsigned) {
            this.writeInt(true, 1, value < 0 ? 1 : 0);
            if (--size > 0) {
                this.writeInt(true, size, value);
            }
            return;
        }
        int quotient = size >> 3;
        int remainder = size & 7;
        if (remainder > 0) {
            this.unsigned8(remainder, value >> (quotient << 3));
        }
        for (int i = 8 * (quotient - 1); i >= 0; i -= 8) {
            this.unsigned8(8, value >> i);
        }
    }

    @Override
    public void writeInt32(int value) throws IOException {
        this.writeInt(false, 32, value);
    }

    @Override
    public void writeInt32Le(int value) throws IOException {
        this.writeShort16Le((short)value);
        this.writeShort16Le((short)(value >> 16));
    }

    @Override
    public void writeLong(boolean unsigned, int size, long value) throws IOException {
        BitIoConstraints.requireValidSizeLong(unsigned, size);
        if (!unsigned) {
            this.writeInt(true, 1, value < 0L ? 1 : 0);
            if (--size > 0) {
                this.writeLong(true, size, value);
            }
            return;
        }
        if (size >= 32) {
            this.writeInt(false, 32, (int)(value >> size - 32));
            size -= 32;
        }
        if (size > 0) {
            this.writeInt(true, size, (int)value);
        }
    }

    @Override
    public void writeLong64(long value) throws IOException {
        this.writeLong(false, 64, value);
    }

    @Override
    public void writeLong64Le(long value) throws IOException {
        this.writeInt32Le((int)value);
        this.writeInt32Le((int)(value >> 32));
    }

    @Override
    public void writeChar(int size, char value) throws IOException {
        this.writeInt(true, BitIoConstraints.requireValidSizeChar(size), value);
    }

    @Override
    public void writeChar16(char value) throws IOException {
        this.writeChar(16, value);
    }

    @Override
    public void skip(int bits) throws IOException {
        if (bits <= 0) {
            throw new IllegalArgumentException("bits(" + bits + ") <= 0");
        }
        while (bits >= 32) {
            this.writeInt(false, 32, 0);
            bits -= 32;
        }
        if (bits > 0) {
            this.writeInt(true, bits, 0);
        }
    }

    @Override
    public long align(int bytes) throws IOException {
        if (bytes <= 0) {
            throw new IllegalArgumentException("bytes(" + bytes + ") <= 0");
        }
        long bits = 0L;
        if (this.available < 8) {
            bits += (long)this.available;
            this.writeInt(true, this.available, 0);
        }
        if (bytes == 1) {
            return bits;
        }
        bytes -= (int)(this.count % (long)bytes);
        while (bytes > 0) {
            this.writeInt(true, 8, 0);
            bits += 8L;
            --bytes;
        }
        return bits;
    }

    public long getCount() {
        return this.count;
    }
}

