/*
 * Decompiled with CFR 0.152.
 */
package com.github.jinahya.bit.io;

import com.github.jinahya.bit.io.AbstractByteInput;
import java.io.IOException;

public class ArrayByteInput
extends AbstractByteInput<byte[]> {
    private int index;

    public ArrayByteInput(byte[] source) {
        super(source);
        this.index = source == null || source.length == 0 ? -1 : 0;
    }

    @Override
    public String toString() {
        return super.toString() + "{index=" + this.index + "}";
    }

    @Override
    public int read() throws IOException {
        return this.getSource()[this.getIndexAndIncrement()] & 0xFF;
    }

    @Override
    protected byte[] getSource() {
        return (byte[])super.getSource();
    }

    @Override
    protected void setSource(byte[] source) {
        super.setSource(source);
    }

    protected int getIndex() {
        return this.index;
    }

    int getIndexAndIncrement() {
        int result = this.getIndex();
        this.setIndex(result + 1);
        return result;
    }

    protected void setIndex(int index) {
        this.index = index;
    }
}

