/*
 * Decompiled with CFR 0.152.
 */
package com.github.jinahya.bit.io;

import com.github.jinahya.bit.io.AbstractByteOutput;
import java.io.IOException;

public class ArrayByteOutput
extends AbstractByteOutput<byte[]> {
    private int index;

    public ArrayByteOutput(byte[] target) {
        super(target);
        this.index = target == null || target.length == 0 ? -1 : 0;
    }

    @Override
    public String toString() {
        return super.toString() + "{index=" + this.index + "}";
    }

    @Override
    public void write(int value) throws IOException {
        this.getTarget()[this.getIndexAndIncrement()] = (byte)value;
    }

    @Override
    protected byte[] getTarget() {
        return (byte[])super.getTarget();
    }

    @Override
    protected void setTarget(byte[] target) {
        super.setTarget(target);
    }

    protected int getIndex() {
        return this.index;
    }

    int getIndexAndIncrement() {
        int result = this.getIndex();
        this.setIndex(result + 1);
        return result;
    }

    protected void setIndex(int index) {
        this.index = index;
    }
}

