/*
 * Decompiled with CFR 0.152.
 */
package com.github.jinahya.bit.io;

import com.github.jinahya.bit.io.AbstractByteInput;
import java.io.EOFException;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;

class ChannelByteInput2
extends AbstractByteInput<ReadableByteChannel> {
    private ByteBuffer buffer;

    public static ChannelByteInput2 of(ReadableByteChannel channel) {
        if (channel == null) {
            throw new NullPointerException("channel is null");
        }
        return new ChannelByteInput2(channel, null){

            @Override
            public int read() throws IOException {
                if (this.getBuffer() == null) {
                    this.setBuffer((ByteBuffer)ByteBuffer.allocate(1).position(1));
                }
                return super.read();
            }
        };
    }

    public ChannelByteInput2(ReadableByteChannel source, ByteBuffer buffer) {
        super(source);
        this.buffer = buffer;
    }

    @Override
    public String toString() {
        return super.toString() + "{buffer=" + this.buffer + "}";
    }

    @Override
    public int read() throws IOException {
        ByteBuffer buffer = this.getBuffer();
        while (!buffer.hasRemaining()) {
            buffer.clear();
            if (this.getSource().read(buffer) == -1) {
                throw new EOFException("reached to an end");
            }
            buffer.flip();
        }
        return buffer.get() & 0xFF;
    }

    @Override
    protected ReadableByteChannel getSource() {
        return (ReadableByteChannel)super.getSource();
    }

    @Override
    protected void setSource(ReadableByteChannel source) {
        super.setSource(source);
    }

    protected ByteBuffer getBuffer() {
        return this.buffer;
    }

    protected void setBuffer(ByteBuffer buffer) {
        this.buffer = buffer;
    }
}

