/*
 * Decompiled with CFR 0.152.
 */
package com.github.jinahya.bit.io;

import com.github.jinahya.bit.io.AbstractByteOutput;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.WritableByteChannel;

class ChannelByteOutput2
extends AbstractByteOutput<WritableByteChannel> {
    private ByteBuffer buffer;

    public static ChannelByteOutput2 of(WritableByteChannel channel) {
        if (channel == null) {
            throw new NullPointerException("channel is null");
        }
        return new ChannelByteOutput2(channel, null){

            @Override
            public void write(int value) throws IOException {
                if (this.getBuffer() == null) {
                    this.setBuffer(ByteBuffer.allocate(1));
                }
                super.write(value);
            }
        };
    }

    public ChannelByteOutput2(WritableByteChannel target, ByteBuffer buffer) {
        super(target);
        this.buffer = buffer;
    }

    @Override
    public String toString() {
        return super.toString() + "{buffer=" + this.buffer + "}";
    }

    @Override
    public void write(int value) throws IOException {
        ByteBuffer buffer = this.getBuffer();
        while (!buffer.hasRemaining()) {
            buffer.flip();
            int written = this.getTarget().write(buffer);
            buffer.compact();
        }
        buffer.put((byte)value);
    }

    @Override
    protected WritableByteChannel getTarget() {
        return (WritableByteChannel)super.getTarget();
    }

    @Override
    protected void setTarget(WritableByteChannel target) {
        super.setTarget(target);
    }

    protected ByteBuffer getBuffer() {
        return this.buffer;
    }

    protected void setBuffer(ByteBuffer buffer) {
        this.buffer = buffer;
    }
}

