/*
 * Decompiled with CFR 0.152.
 */
package cubrid.jdbc.driver;

import cubrid.jdbc.driver.CUBRIDBufferedInputStream;
import cubrid.jdbc.driver.CUBRIDBufferedOutputStream;
import cubrid.jdbc.driver.CUBRIDBufferedReader;
import cubrid.jdbc.driver.CUBRIDBufferedWriter;
import cubrid.jdbc.driver.CUBRIDClobInputStream;
import cubrid.jdbc.driver.CUBRIDClobOutputStream;
import cubrid.jdbc.driver.CUBRIDClobReader;
import cubrid.jdbc.driver.CUBRIDClobWriter;
import cubrid.jdbc.driver.CUBRIDConnection;
import cubrid.jdbc.driver.CUBRIDException;
import cubrid.jdbc.driver.CUBRIDJDBCErrorCode;
import cubrid.jdbc.driver.CUBRIDLobHandle;
import java.io.Flushable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.sql.Clob;
import java.sql.SQLException;
import java.util.ArrayList;

public class CUBRIDClob
implements Clob {
    private static final int CLOB_MAX_IO_LENGTH = 131072;
    private static final int CLOB_MAX_IO_CHARS = 65536;
    private CUBRIDConnection conn;
    private boolean isWritable;
    private CUBRIDLobHandle lobHandle;
    private String charsetName;
    private StringBuffer clobCharBuffer = new StringBuffer("");
    private long clobCharPos;
    private long clobCharLength;
    private byte[] clobByteBuffer = new byte[131072];
    private long clobBytePos;
    private long clobNextReadBytePos;
    private ArrayList<Flushable> streamList = new ArrayList();

    public CUBRIDClob(CUBRIDConnection conn, String charsetName) throws SQLException {
        if (conn == null) {
            throw new CUBRIDException(CUBRIDJDBCErrorCode.invalid_value);
        }
        byte[] packedLobHandle = conn.lobNew(24);
        this.conn = conn;
        this.isWritable = true;
        this.lobHandle = new CUBRIDLobHandle(24, packedLobHandle);
        this.charsetName = charsetName;
        this.clobCharPos = 0L;
        this.clobCharLength = 0L;
        this.clobBytePos = 0L;
        this.clobNextReadBytePos = 0L;
    }

    public CUBRIDClob(CUBRIDConnection conn, byte[] packedLobHandle, String charsetName) throws SQLException {
        if (conn == null || packedLobHandle == null) {
            throw new CUBRIDException(CUBRIDJDBCErrorCode.invalid_value);
        }
        this.conn = conn;
        this.isWritable = false;
        this.lobHandle = new CUBRIDLobHandle(24, packedLobHandle);
        this.charsetName = charsetName;
        this.clobCharPos = 0L;
        this.clobCharLength = -1L;
        this.clobBytePos = 0L;
        this.clobNextReadBytePos = 0L;
    }

    public synchronized long length() throws SQLException {
        if (this.lobHandle == null) {
            throw this.conn.createCUBRIDException(CUBRIDJDBCErrorCode.invalid_value, null);
        }
        if (this.clobCharLength < 0L) {
            this.readClobPartially(Long.MAX_VALUE, 1);
        }
        return this.clobCharLength;
    }

    public synchronized String getSubString(long pos, int length) throws SQLException {
        if (this.lobHandle == null) {
            throw this.conn.createCUBRIDException(CUBRIDJDBCErrorCode.invalid_value, null);
        }
        if (pos < 1L || length < 0) {
            throw this.conn.createCUBRIDException(CUBRIDJDBCErrorCode.invalid_value, null);
        }
        if (length == 0) {
            return "";
        }
        int read_len = this.readClobPartially(pos, length);
        if (read_len <= 0) {
            return "";
        }
        return this.clobCharBuffer.substring(0, read_len);
    }

    public Reader getCharacterStream() throws SQLException {
        return this.getCharacterStream(1L, Long.MAX_VALUE);
    }

    public Reader getCharacterStream(long pos, long length) throws SQLException {
        if (this.lobHandle == null) {
            throw this.conn.createCUBRIDException(CUBRIDJDBCErrorCode.invalid_value, null);
        }
        if (pos < 1L || length < 0L) {
            throw this.conn.createCUBRIDException(CUBRIDJDBCErrorCode.invalid_value, null);
        }
        return new CUBRIDBufferedReader(new CUBRIDClobReader(this, pos, length), 65536);
    }

    public InputStream getAsciiStream() throws SQLException {
        if (this.lobHandle == null) {
            throw this.conn.createCUBRIDException(CUBRIDJDBCErrorCode.invalid_value, null);
        }
        return new CUBRIDBufferedInputStream(new CUBRIDClobInputStream(this), 131072);
    }

    public long position(String searchstr, long start) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public long position(Clob searchClob, long start) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public synchronized int setString(long pos, String str) throws SQLException {
        if (this.lobHandle == null) {
            throw this.conn.createCUBRIDException(CUBRIDJDBCErrorCode.invalid_value, null);
        }
        if (pos < 1L) {
            throw this.conn.createCUBRIDException(CUBRIDJDBCErrorCode.invalid_value, null);
        }
        if (!this.isWritable) {
            throw this.conn.createCUBRIDException(CUBRIDJDBCErrorCode.lob_is_not_writable, null);
        }
        if (str == null || str.length() <= 0) {
            return 0;
        }
        if (this.readClobPartially(pos, 1) != 0) {
            throw this.conn.createCUBRIDException(CUBRIDJDBCErrorCode.lob_pos_invalid, null);
        }
        byte[] bytes = this.string2bytes(str);
        int bytes_len = bytes.length;
        int bytes_offset = 0;
        while (bytes_len > 0) {
            int bytesWritten = this.conn.lobWrite(this.lobHandle.getPackedLobHandle(), this.clobBytePos + (long)bytes_offset, bytes, bytes_offset, Math.min(bytes_len, 131072));
            bytes_len -= bytesWritten;
            bytes_offset += bytesWritten;
        }
        this.lobHandle.setLobSize(this.clobBytePos + (long)bytes_offset);
        this.clobCharLength = this.length() + (long)str.length();
        return str.length();
    }

    public int setString(long pos, String str, int offset, int len) throws SQLException {
        if (this.lobHandle == null) {
            throw this.conn.createCUBRIDException(CUBRIDJDBCErrorCode.invalid_value, null);
        }
        if (pos < 1L || offset < 0 || len < 0) {
            throw this.conn.createCUBRIDException(CUBRIDJDBCErrorCode.invalid_value, null);
        }
        if (offset + len > str.length()) {
            throw new IndexOutOfBoundsException();
        }
        if (!this.isWritable) {
            throw this.conn.createCUBRIDException(CUBRIDJDBCErrorCode.lob_is_not_writable, null);
        }
        if (str == null || len == 0) {
            return 0;
        }
        return this.setString(pos, str.substring(offset, offset + len));
    }

    public synchronized OutputStream setAsciiStream(long pos) throws SQLException {
        if (this.lobHandle == null) {
            throw this.conn.createCUBRIDException(CUBRIDJDBCErrorCode.invalid_value, null);
        }
        if (pos < 1L) {
            throw this.conn.createCUBRIDException(CUBRIDJDBCErrorCode.invalid_value, null);
        }
        if (!this.isWritable) {
            throw this.conn.createCUBRIDException(CUBRIDJDBCErrorCode.lob_is_not_writable, null);
        }
        if (this.readClobPartially(pos, 1) != 0) {
            throw this.conn.createCUBRIDException(CUBRIDJDBCErrorCode.lob_pos_invalid, null);
        }
        CUBRIDBufferedOutputStream out = new CUBRIDBufferedOutputStream(new CUBRIDClobOutputStream(this, this.clobBytePos + 1L), 131072);
        this.addFlushableStream(out);
        return out;
    }

    public Writer setCharacterStream(long pos) throws SQLException {
        if (this.lobHandle == null) {
            throw this.conn.createCUBRIDException(CUBRIDJDBCErrorCode.invalid_value, null);
        }
        if (pos < 1L) {
            throw this.conn.createCUBRIDException(CUBRIDJDBCErrorCode.invalid_value, null);
        }
        if (!this.isWritable) {
            throw this.conn.createCUBRIDException(CUBRIDJDBCErrorCode.lob_is_not_writable, null);
        }
        if (this.readClobPartially(pos, 1) != 0) {
            throw this.conn.createCUBRIDException(CUBRIDJDBCErrorCode.lob_pos_invalid, null);
        }
        CUBRIDBufferedWriter out = new CUBRIDBufferedWriter(new CUBRIDClobWriter(this, pos), 65536);
        this.addFlushableStream(out);
        return out;
    }

    public void truncate(long len) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public void free() throws SQLException {
        this.conn = null;
        this.lobHandle = null;
        this.streamList = null;
        this.clobCharBuffer = null;
        this.clobByteBuffer = null;
        this.isWritable = false;
    }

    private int readClobPartially(long pos, int length) throws SQLException {
        if (this.clobCharLength != -1L && pos > this.clobCharLength) {
            this.clobBytePos = this.clobNextReadBytePos = this.lobHandle.getLobSize();
            this.clobCharPos = this.clobCharLength;
            this.clobCharBuffer.setLength(0);
            if (pos == this.clobCharLength + 1L) {
                return 0;
            }
            return -1;
        }
        if (--pos < this.clobCharPos) {
            this.clobNextReadBytePos = 0L;
            this.clobBytePos = 0L;
            this.clobCharPos = 0L;
            this.clobCharBuffer.setLength(0);
            this.readClob();
        }
        while (pos >= this.clobCharPos + (long)this.clobCharBuffer.length()) {
            this.clobBytePos = this.clobNextReadBytePos;
            this.clobCharPos += (long)this.clobCharBuffer.length();
            this.clobCharBuffer.setLength(0);
            if (this.clobNextReadBytePos >= this.lobHandle.getLobSize()) {
                return 0;
            }
            this.readClob();
        }
        int delete_len = (int)(pos - this.clobCharPos);
        if (delete_len > 0) {
            this.clobCharPos = pos;
            this.clobBytePos += (long)this.string2bytes(this.clobCharBuffer.substring(0, delete_len)).length;
            this.clobCharBuffer.delete(0, delete_len);
        }
        while (length > this.clobCharBuffer.length()) {
            if (this.clobNextReadBytePos >= this.lobHandle.getLobSize()) {
                return this.clobCharBuffer.length();
            }
            this.readClob();
        }
        return length;
    }

    private void readClob() throws SQLException {
        if (this.conn == null || this.lobHandle == null) {
            throw new NullPointerException();
        }
        int read_len = this.conn.lobRead(this.lobHandle.getPackedLobHandle(), this.clobNextReadBytePos, this.clobByteBuffer, 0, 131072);
        StringBuffer sb = new StringBuffer(this.bytes2string(this.clobByteBuffer, 0, read_len));
        if (this.clobNextReadBytePos + (long)read_len >= this.lobHandle.getLobSize()) {
            this.clobNextReadBytePos += (long)read_len;
            this.clobCharLength = this.clobCharPos + (long)this.clobCharBuffer.length() + (long)sb.length();
        } else {
            this.clobNextReadBytePos += (long)this.string2bytes(sb.substring(0, sb.length() - 1)).length;
            sb.setLength(sb.length() - 1);
        }
        this.clobCharBuffer.append(sb);
    }

    private byte[] string2bytes(String s) throws SQLException {
        try {
            return s.getBytes(this.charsetName);
        }
        catch (UnsupportedEncodingException e) {
            throw this.conn.createCUBRIDException(CUBRIDJDBCErrorCode.unknown, e.getMessage(), e);
        }
    }

    private String bytes2string(byte[] b, int start, int len) throws SQLException {
        try {
            return new String(b, start, len, this.charsetName);
        }
        catch (UnsupportedEncodingException e) {
            throw this.conn.createCUBRIDException(CUBRIDJDBCErrorCode.unknown, e.getMessage(), e);
        }
    }

    public CUBRIDLobHandle getLobHandle() {
        return this.lobHandle;
    }

    private void addFlushableStream(Flushable out) {
        this.streamList.add(out);
    }

    public void removeFlushableStream(Flushable out) {
        this.streamList.remove(out);
    }

    public void flushFlushableStreams() {
        if (!this.streamList.isEmpty()) {
            for (Flushable out : this.streamList) {
                try {
                    out.flush();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public String toString() {
        return this.lobHandle.toString();
    }

    public boolean equals(Object obj) {
        if (obj instanceof CUBRIDClob) {
            CUBRIDClob that = (CUBRIDClob)obj;
            return this.lobHandle.equals(that.lobHandle);
        }
        return false;
    }

    public byte[] getBytes(long pos, int length) throws SQLException {
        if (this.conn == null || this.lobHandle == null) {
            throw new NullPointerException();
        }
        if (pos < 1L || length < 0) {
            throw this.conn.createCUBRIDException(CUBRIDJDBCErrorCode.invalid_value, null);
        }
        if (length == 0) {
            return new byte[0];
        }
        int total_read_len = 0;
        if (--pos + (long)length > this.lobHandle.getLobSize()) {
            length = (int)(this.lobHandle.getLobSize() - pos);
        }
        byte[] buf = new byte[length];
        while (length > 0) {
            int read_len = Math.min(length, 131072);
            int real_read_len = this.conn.lobRead(this.lobHandle.getPackedLobHandle(), pos, buf, total_read_len, read_len);
            pos += (long)real_read_len;
            length -= real_read_len;
            total_read_len += real_read_len;
            if (real_read_len != 0) continue;
        }
        if (total_read_len < buf.length) {
            throw this.conn.createCUBRIDException(CUBRIDJDBCErrorCode.unknown, null);
        }
        return buf;
    }

    public int setBytes(long pos, byte[] bytes, int offset, int len) throws SQLException {
        if (this.conn == null || this.lobHandle == null) {
            throw new NullPointerException();
        }
        if (pos < 1L || offset < 0 || len < 0) {
            throw this.conn.createCUBRIDException(CUBRIDJDBCErrorCode.invalid_value, null);
        }
        if (offset + len > bytes.length) {
            throw new IndexOutOfBoundsException();
        }
        if (this.isWritable) {
            if (this.lobHandle.getLobSize() + 1L != pos) {
                throw this.conn.createCUBRIDException(CUBRIDJDBCErrorCode.lob_pos_invalid, null);
            }
            --pos;
            int total_write_len = 0;
            while (len > 0) {
                int write_len = Math.min(len, 131072);
                int real_write_len = this.conn.lobWrite(this.lobHandle.getPackedLobHandle(), pos, bytes, offset, write_len);
                pos += (long)real_write_len;
                len -= real_write_len;
                offset += real_write_len;
                total_write_len += real_write_len;
            }
            if (pos > this.lobHandle.getLobSize()) {
                this.lobHandle.setLobSize(pos);
                this.clobCharLength = -1L;
            }
            return total_write_len;
        }
        throw this.conn.createCUBRIDException(CUBRIDJDBCErrorCode.lob_is_not_writable, null);
    }
}

