/*
 * Decompiled with CFR 0.152.
 */
package cubrid.jdbc.driver;

import cubrid.jdbc.driver.CUBRIDClob;
import java.io.IOException;
import java.io.Reader;
import java.sql.SQLException;

class CUBRIDClobReader
extends Reader {
    private CUBRIDClob clob;
    private long char_pos;
    private long char_length;

    CUBRIDClobReader(CUBRIDClob clob, long pos, long length) {
        this.clob = clob;
        this.char_pos = pos;
        this.char_length = pos - 1L + length;
        if (this.char_length < 0L) {
            this.char_length = Long.MAX_VALUE;
        }
    }

    public synchronized int read() throws IOException {
        char[] c = new char[1];
        if (this.read(c, 0, 1) == 1) {
            return 0xFFFF & c[0];
        }
        return -1;
    }

    public synchronized int read(char[] cbuf) throws IOException {
        return this.read(cbuf, 0, cbuf.length);
    }

    public synchronized int read(char[] cbuf, int off, int len) throws IOException {
        int read_chars;
        if (this.clob == null) {
            return -1;
        }
        if (cbuf == null) {
            throw new NullPointerException();
        }
        if (off < 0 || len < 0 || off + len > cbuf.length) {
            throw new IndexOutOfBoundsException();
        }
        try {
            if (this.char_pos - 1L + (long)len > this.char_length && (len = (int)(this.char_length - this.char_pos + 1L)) < 0) {
                len = 0;
            }
            String str = this.clob.getSubString(this.char_pos, len);
            str.getChars(0, str.length(), cbuf, off);
            read_chars = str.length();
        }
        catch (SQLException e) {
            throw new IOException(e.getMessage());
        }
        this.char_pos += (long)read_chars;
        if (read_chars < len || this.char_pos > this.char_length) {
            this.clob = null;
        }
        return read_chars;
    }

    public synchronized void close() throws IOException {
        this.clob = null;
    }
}

