/*
 * Decompiled with CFR 0.152.
 */
package cubrid.jdbc.driver;

import cubrid.jdbc.driver.CUBRIDConnection;
import cubrid.jdbc.driver.CUBRIDDriver;
import cubrid.jdbc.driver.CUBRIDPoolDataSourceBase;
import cubrid.jdbc.driver.CUBRIDPooledConnection;
import cubrid.jdbc.jci.UConnection;
import cubrid.jdbc.jci.UJCIManager;
import java.io.Serializable;
import java.sql.SQLException;
import java.util.Properties;
import java.util.logging.Logger;
import javax.naming.NamingException;
import javax.naming.Reference;
import javax.naming.Referenceable;
import javax.sql.ConnectionPoolDataSource;
import javax.sql.PooledConnection;

public class CUBRIDConnectionPoolDataSource
extends CUBRIDPoolDataSourceBase
implements ConnectionPoolDataSource,
Referenceable,
Serializable {
    private static final long serialVersionUID = 3418532804994248021L;

    public CUBRIDConnectionPoolDataSource() {
    }

    protected CUBRIDConnectionPoolDataSource(Reference ref) {
        this.setProperties(ref);
    }

    public synchronized PooledConnection getPooledConnection() throws SQLException {
        return this.getPooledConnection(null, null);
    }

    public synchronized PooledConnection getPooledConnection(String username, String passwd) throws SQLException {
        CUBRIDPooledConnection poolCon;
        if (this.getUrl() != null) {
            CUBRIDDriver driver = new CUBRIDDriver();
            Properties props = new Properties();
            if (username != null) {
                props.setProperty("user", username);
            }
            if (passwd != null) {
                props.setProperty("password", passwd);
            }
            CUBRIDConnection c_con = (CUBRIDConnection)driver.connect(this.getUrl(), props);
            poolCon = new CUBRIDPooledConnection(c_con);
        } else {
            if (username == null) {
                username = this.getUser();
            }
            if (passwd == null) {
                passwd = this.getPassword();
            }
            UConnection u_con = UJCIManager.connect(this.getServerName(), this.getPortNumber(), this.getDatabaseName(), username, passwd, this.getDataSourceID(username));
            poolCon = new CUBRIDPooledConnection(u_con);
        }
        return poolCon;
    }

    public synchronized Reference getReference() throws NamingException {
        Reference ref = new Reference(this.getClass().getName(), "cubrid.jdbc.driver.CUBRIDDataSourceObjectFactory", null);
        ref = this.getProperties(ref);
        return ref;
    }

    public Logger getParentLogger() {
        throw new UnsupportedOperationException();
    }
}

