/*
 * Decompiled with CFR 0.152.
 */
package cubrid.jdbc.driver;

import cubrid.jdbc.driver.CUBRIDConnection;
import cubrid.jdbc.driver.CUBRIDException;
import cubrid.jdbc.driver.CUBRIDJDBCErrorCode;
import cubrid.jdbc.driver.CUBRIDXAConnection;
import cubrid.jdbc.jci.UConnection;
import java.sql.SQLException;
import java.sql.Savepoint;

public class CUBRIDConnectionWrapperXA
extends CUBRIDConnection {
    private CUBRIDXAConnection xacon;
    private boolean xa_started;

    protected CUBRIDConnectionWrapperXA(UConnection u, String r, String s, CUBRIDXAConnection c, boolean xa_start) {
        super(u, r, s);
        this.xacon = c;
        this.xa_started = xa_start;
        if (xa_start) {
            this.auto_commit = false;
        }
    }

    public synchronized void close() throws SQLException {
        if (this.is_closed) {
            return;
        }
        this.closeConnection();
        this.xacon.notifyConnectionClosed();
    }

    public synchronized void setAutoCommit(boolean autoCommit) throws SQLException {
        if (this.xa_started) {
            if (autoCommit) {
                throw new CUBRIDException(CUBRIDJDBCErrorCode.xa_illegal_operation);
            }
        } else {
            super.setAutoCommit(autoCommit);
        }
    }

    public synchronized void commit() throws SQLException {
        if (this.xa_started) {
            throw new CUBRIDException(CUBRIDJDBCErrorCode.xa_illegal_operation);
        }
        super.commit();
    }

    public synchronized void rollback() throws SQLException {
        if (this.xa_started) {
            throw new CUBRIDException(CUBRIDJDBCErrorCode.xa_illegal_operation);
        }
        super.rollback();
    }

    public synchronized void rollback(Savepoint savepoint) throws SQLException {
        if (this.xa_started) {
            throw new CUBRIDException(CUBRIDJDBCErrorCode.xa_illegal_operation);
        }
        super.rollback(savepoint);
    }

    public synchronized void releaseSavepoint(Savepoint savepoint) throws SQLException {
        if (!this.xa_started) {
            super.releaseSavepoint(savepoint);
        }
    }

    public synchronized Savepoint setSavepoint() throws SQLException {
        if (this.xa_started) {
            throw new CUBRIDException(CUBRIDJDBCErrorCode.xa_illegal_operation);
        }
        return super.setSavepoint();
    }

    public synchronized Savepoint setSavepoint(String name) throws SQLException {
        if (this.xa_started) {
            throw new CUBRIDException(CUBRIDJDBCErrorCode.xa_illegal_operation);
        }
        return super.setSavepoint(name);
    }

    void autoCommit() throws SQLException {
        if (!this.xa_started) {
            super.autoCommit();
        }
    }

    void xa_start(UConnection u) {
        if (this.xa_started) {
            return;
        }
        this.auto_commit = false;
        this.xa_started = true;
        if (u != null) {
            this.u_con = u;
        }
    }

    void xa_end(UConnection u) {
        if (!this.xa_started) {
            return;
        }
        this.xa_started = false;
        if (u != null) {
            this.u_con = u;
        }
        this.auto_commit = true;
    }
}

