/*
 * Decompiled with CFR 0.152.
 */
package cubrid.jdbc.driver;

import cubrid.jdbc.driver.CUBRIDConnection;
import cubrid.jdbc.driver.CUBRIDException;
import cubrid.jdbc.driver.CUBRIDJDBCErrorCode;
import cubrid.jdbc.driver.ConnectionProperties;
import cubrid.jdbc.jci.BrokerHealthCheck;
import cubrid.jdbc.jci.UConnection;
import cubrid.jdbc.jci.UJCIManager;
import cubrid.jdbc.jci.UJCIUtil;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.PrintStream;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.DriverPropertyInfo;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class CUBRIDDriver
implements Driver {
    public static final String version_string = "9.3.9.0002";
    public static final int major_version;
    public static final int minor_version;
    public static final int patch_version;
    public static final String default_hostname = "localhost";
    public static final int default_port = 30000;
    public static final String default_user = "public";
    public static final String default_password = "";
    public static List<String> unreachableHosts;
    private static final String URL_PATTERN = "jdbc:cubrid(-oracle|-mysql)?:([a-zA-Z_0-9\\.-]*):([0-9]*):([^:]+):([^:]*):([^:]*):(\\?[a-zA-Z_0-9]+=[^&=?]+(&[a-zA-Z_0-9]+=[^&=?]+)*)?";
    private static final String CUBRID_JDBC_URL_HEADER = "jdbc:cubrid";
    private static final String JDBC_DEFAULT_CONNECTION = "jdbc:default:connection";
    private static PrintStream debugOutput;

    public static boolean isUnreachableHost(String host) {
        return unreachableHosts.contains(host);
    }

    public static void printDebug(String msg) {
        Timestamp timestamp = new Timestamp(System.currentTimeMillis());
        SimpleDateFormat fmt = new SimpleDateFormat("MM-dd hh:mm:ss.SSS");
        String line = String.format("%s %s", fmt.format(timestamp), msg);
        debugOutput.println(line);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addToUnreachableHosts(String host) {
        List<String> list = unreachableHosts;
        synchronized (list) {
            if (!unreachableHosts.contains(host)) {
                unreachableHosts.add(host);
            }
        }
    }

    public Connection connect(String url, Properties info) throws SQLException {
        UConnection u_con;
        if (!this.acceptsURL(url)) {
            return null;
        }
        if (url.toLowerCase().startsWith(JDBC_DEFAULT_CONNECTION)) {
            return this.defaultConnection();
        }
        Pattern pattern = Pattern.compile(URL_PATTERN, 2);
        Matcher matcher = pattern.matcher(url);
        if (!matcher.find()) {
            throw new CUBRIDException(CUBRIDJDBCErrorCode.invalid_url, url, null);
        }
        String match = matcher.group();
        if (!match.equals(url)) {
            throw new CUBRIDException(CUBRIDJDBCErrorCode.invalid_url, url, null);
        }
        String host = matcher.group(2);
        String portString = matcher.group(3);
        String db = matcher.group(4);
        String user = matcher.group(5);
        String pass = matcher.group(6);
        String prop = matcher.group(7);
        int port = 30000;
        if (host == null || host.length() == 0) {
            host = default_hostname;
        }
        port = portString == null || portString.length() == 0 ? 30000 : Integer.parseInt(portString);
        ConnectionProperties connProperties = new ConnectionProperties();
        connProperties.setProperties(prop);
        String dummy = info.getProperty("user");
        if (dummy != null && dummy.length() != 0) {
            user = dummy;
        }
        if ((dummy = info.getProperty("password")) != null && dummy.length() != 0) {
            pass = dummy;
        }
        if (user == null) {
            user = default_user;
        }
        if (pass == null) {
            pass = default_password;
        }
        String resolvedUrl = "jdbc:cubrid:" + host + ":" + port + ":" + db + ":" + user + ":********:";
        if (prop != null) {
            resolvedUrl = resolvedUrl + prop;
        }
        connProperties.setProperties(info);
        dummy = connProperties.getAltHosts();
        if (dummy != null) {
            ArrayList<String> altHostList = new ArrayList<String>();
            altHostList.add(host + ":" + port);
            StringTokenizer st = new StringTokenizer(dummy, ",", false);
            while (st.hasMoreTokens()) {
                altHostList.add(st.nextToken());
            }
            if (connProperties.getConnLoadBal()) {
                Collections.shuffle(altHostList);
            }
            u_con = UJCIManager.connect(altHostList, db, user, pass, resolvedUrl);
        }
        u_con = UJCIManager.connect(host, port, db, user, pass, resolvedUrl);
        u_con.setCharset(connProperties.getCharSet());
        u_con.setZeroDateTimeBehavior(connProperties.getZeroDateTimeBehavior());
        u_con.setConnectionProperties(connProperties);
        u_con.tryConnect();
        return new CUBRIDConnection(u_con, url, user);
    }

    public Connection defaultConnection() throws SQLException {
        if (UJCIUtil.isServerSide()) {
            Thread t = Thread.currentThread();
            Connection c = (Connection)UJCIUtil.invoke("com.cubrid.jsp.ExecuteThread", "getJdbcConnection", null, t, null);
            if (c != null) {
                return c;
            }
            UConnection u_con = UJCIManager.connectDefault();
            CUBRIDConnection con = new CUBRIDConnection(u_con, "jdbc:default:connection:", "default", true);
            UJCIUtil.invoke("com.cubrid.jsp.ExecuteThread", "setJdbcConnection", new Class[]{Connection.class}, t, new Object[]{con});
            return con;
        }
        return null;
    }

    public boolean acceptsURL(String url) throws SQLException {
        if (url == null) {
            return false;
        }
        String urlHeader = CUBRID_JDBC_URL_HEADER;
        String className = CUBRIDDriver.class.getName();
        urlHeader = className.matches(".*mysql.*") ? urlHeader + "-mysql:" : (className.matches(".*oracle.*") ? urlHeader + "-oracle:" : urlHeader + ":");
        if (url.toLowerCase().startsWith(urlHeader)) {
            return true;
        }
        return url.toLowerCase().startsWith(JDBC_DEFAULT_CONNECTION);
    }

    public DriverPropertyInfo[] getPropertyInfo(String url, Properties info) throws SQLException {
        return new DriverPropertyInfo[0];
    }

    public int getMajorVersion() {
        return major_version;
    }

    public int getMinorVersion() {
        return minor_version;
    }

    public boolean jdbcCompliant() {
        return true;
    }

    public Logger getParentLogger() {
        throw new UnsupportedOperationException();
    }

    static {
        StringTokenizer st22 = new StringTokenizer(version_string, ".");
        if (st22.countTokens() != 4) {
            throw new RuntimeException("Could not parse version_string: 9.3.9.0002");
        }
        major_version = Integer.parseInt(st22.nextToken());
        minor_version = Integer.parseInt(st22.nextToken());
        patch_version = Integer.parseInt(st22.nextToken());
        try {
            DriverManager.registerDriver(new CUBRIDDriver());
        }
        catch (SQLException st22) {
            // empty catch block
        }
        if (UJCIUtil.isConsoleDebug()) {
            try {
                debugOutput = new PrintStream(new File("cubrid.log"));
            }
            catch (FileNotFoundException e) {
                debugOutput = System.out;
            }
        }
        unreachableHosts = new CopyOnWriteArrayList<String>();
        Thread brokerHealthCheck = new Thread(new BrokerHealthCheck());
        brokerHealthCheck.setDaemon(true);
        brokerHealthCheck.setContextClassLoader(null);
        brokerHealthCheck.start();
    }
}

