/*
 * Decompiled with CFR 0.152.
 */
package cubrid.jdbc.driver;

import java.io.IOException;
import java.io.InputStream;

class CUBRIDInputStream
extends InputStream {
    private int position;
    private byte[] valueBuffer;

    CUBRIDInputStream(byte[] v) {
        this.valueBuffer = v;
        this.position = 0;
    }

    public synchronized int available() throws IOException {
        if (this.valueBuffer == null) {
            return 0;
        }
        return this.valueBuffer.length - this.position;
    }

    public synchronized int read() throws IOException {
        byte[] b = new byte[1];
        if (this.read(b, 0, 1) == -1) {
            return -1;
        }
        return b[0];
    }

    public synchronized int read(byte[] b, int off, int len) throws IOException {
        int i;
        if (b == null) {
            throw new NullPointerException();
        }
        if (off < 0 || off > b.length || len < 0 || off + len > b.length || off + len < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (len == 0) {
            return 0;
        }
        if (this.valueBuffer == null) {
            return -1;
        }
        for (i = this.position; i < len + this.position && i < this.valueBuffer.length; ++i) {
            b[i - this.position + off] = this.valueBuffer[i];
        }
        int temp = this.position;
        this.position = i;
        if (this.position == this.valueBuffer.length) {
            this.close();
        }
        return i - temp;
    }

    public synchronized void close() throws IOException {
        this.valueBuffer = null;
    }
}

