/*
 * Decompiled with CFR 0.152.
 */
package cubrid.jdbc.driver;

import cubrid.jdbc.driver.CUBRIDException;
import cubrid.jdbc.driver.CUBRIDJDBCErrorCode;
import cubrid.jdbc.driver.CUBRIDResultSetWithoutQuery;
import cubrid.jdbc.jci.UColumnInfo;
import cubrid.jdbc.jci.UJCIUtil;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CUBRIDResultSetMetaData
implements ResultSetMetaData {
    private String[] col_name;
    private int[] col_type;
    private int[] ele_type;
    private String[] col_type_name;
    private String[] ele_type_name;
    private int[] col_prec;
    private int[] col_disp_size;
    private int[] col_scale;
    private String[] col_table;
    private int[] col_null;
    private String[] col_class_name;
    private boolean[] is_auto_increment_col;

    protected CUBRIDResultSetMetaData(UColumnInfo[] col_info) {
        this.col_name = new String[col_info.length];
        this.col_type = new int[col_info.length];
        this.ele_type = new int[col_info.length];
        this.col_type_name = new String[col_info.length];
        this.ele_type_name = new String[col_info.length];
        this.col_prec = new int[col_info.length];
        this.col_disp_size = new int[col_info.length];
        this.col_scale = new int[col_info.length];
        this.col_table = new String[col_info.length];
        this.col_null = new int[col_info.length];
        this.col_class_name = new String[col_info.length];
        this.is_auto_increment_col = new boolean[col_info.length];
        block52: for (int i = 0; i < col_info.length; ++i) {
            this.col_disp_size[i] = this.getDefaultColumnDisplaySize(col_info[i].getColumnType());
            this.col_name[i] = col_info[i].getColumnName();
            this.col_prec[i] = col_info[i].getColumnPrecision();
            this.col_scale[i] = col_info[i].getColumnScale();
            this.col_table[i] = col_info[i].getClassName();
            this.col_type_name[i] = null;
            this.col_class_name[i] = col_info[i].getFQDN();
            this.col_null[i] = col_info[i].isNullable() ? 1 : 0;
            this.is_auto_increment_col[i] = col_info[i].getIsAutoIncrement() != 0;
            switch (col_info[i].getColumnType()) {
                case 1: {
                    this.col_type_name[i] = "CHAR";
                    this.col_type[i] = 1;
                    this.ele_type[i] = -1;
                    if (this.col_prec[i] <= this.col_disp_size[i]) continue block52;
                    this.col_disp_size[i] = this.col_prec[i];
                    continue block52;
                }
                case 2: {
                    this.col_type_name[i] = "VARCHAR";
                    this.col_type[i] = 12;
                    this.ele_type[i] = -1;
                    if (this.col_prec[i] <= this.col_disp_size[i]) continue block52;
                    this.col_disp_size[i] = this.col_prec[i];
                    continue block52;
                }
                case 25: {
                    this.col_type_name[i] = "ENUM";
                    this.col_type[i] = 12;
                    this.ele_type[i] = -1;
                    if (this.col_prec[i] <= this.col_disp_size[i]) continue block52;
                    this.col_disp_size[i] = this.col_prec[i];
                    continue block52;
                }
                case 5: {
                    if (this.col_prec[i] == 8) {
                        this.col_type_name[i] = "BIT";
                        this.col_type[i] = -7;
                        this.ele_type[i] = -1;
                    } else {
                        this.col_type_name[i] = "BIT";
                        this.col_type[i] = -2;
                        this.ele_type[i] = -1;
                    }
                    if (this.col_prec[i] <= this.col_disp_size[i]) continue block52;
                    this.col_disp_size[i] = this.col_prec[i];
                    continue block52;
                }
                case 6: {
                    this.col_type_name[i] = "BIT VARYING";
                    this.col_type[i] = -3;
                    this.ele_type[i] = -1;
                    if (this.col_prec[i] <= this.col_disp_size[i]) continue block52;
                    this.col_disp_size[i] = this.col_prec[i];
                    continue block52;
                }
                case 9: {
                    if (UJCIUtil.isMysqlMode(this.getClass())) {
                        this.col_disp_size[i] = this.col_prec[i];
                    }
                    this.col_type_name[i] = "SMALLINT";
                    this.col_type[i] = 5;
                    this.ele_type[i] = -1;
                    continue block52;
                }
                case 8: {
                    if (UJCIUtil.isMysqlMode(this.getClass())) {
                        this.col_type_name[i] = "INT";
                        this.col_disp_size[i] = this.col_prec[i];
                    } else {
                        this.col_type_name[i] = "INTEGER";
                    }
                    this.col_type[i] = 4;
                    this.ele_type[i] = -1;
                    continue block52;
                }
                case 21: {
                    this.col_type_name[i] = "BIGINT";
                    this.col_type[i] = -5;
                    this.ele_type[i] = -1;
                    continue block52;
                }
                case 11: {
                    this.col_type_name[i] = "FLOAT";
                    this.col_type[i] = 7;
                    this.ele_type[i] = -1;
                    continue block52;
                }
                case 12: {
                    this.col_type_name[i] = "DOUBLE";
                    this.col_type[i] = 8;
                    this.ele_type[i] = -1;
                    continue block52;
                }
                case 7: {
                    if (UJCIUtil.isMysqlMode(this.getClass())) {
                        this.col_type_name[i] = "DECIMAL";
                        this.col_type[i] = 3;
                        this.col_disp_size[i] = this.col_prec[i] + 1;
                        if (this.col_scale[i] > 0) {
                            int n = i;
                            this.col_disp_size[n] = this.col_disp_size[n] + 1;
                        }
                        this.ele_type[i] = -1;
                        continue block52;
                    }
                    this.col_type_name[i] = "NUMERIC";
                    this.col_type[i] = 2;
                    this.ele_type[i] = -1;
                    continue block52;
                }
                case 10: {
                    this.col_type_name[i] = "MONETARY";
                    this.col_type[i] = 8;
                    this.ele_type[i] = -1;
                    continue block52;
                }
                case 13: {
                    this.col_type_name[i] = "DATE";
                    this.col_type[i] = 91;
                    this.ele_type[i] = -1;
                    continue block52;
                }
                case 14: {
                    this.col_type_name[i] = "TIME";
                    this.col_type[i] = 92;
                    this.ele_type[i] = -1;
                    continue block52;
                }
                case 15: {
                    this.col_type_name[i] = "TIMESTAMP";
                    this.col_type[i] = 93;
                    this.ele_type[i] = -1;
                    continue block52;
                }
                case 22: {
                    this.col_type_name[i] = "DATETIME";
                    this.col_type[i] = 93;
                    this.ele_type[i] = -1;
                    continue block52;
                }
                case 0: {
                    this.col_type_name[i] = "";
                    this.col_type[i] = 1111;
                    this.ele_type[i] = -1;
                    continue block52;
                }
                case 19: {
                    this.col_type_name[i] = "CLASS";
                    this.col_type[i] = 1111;
                    this.ele_type[i] = -1;
                    continue block52;
                }
                case 16: {
                    this.col_type_name[i] = "SET";
                }
                case 17: {
                    if (this.col_type_name[i] == null) {
                        this.col_type_name[i] = "MULTISET";
                    }
                }
                case 18: {
                    if (this.col_type_name[i] == null) {
                        this.col_type_name[i] = "SEQUENCE";
                    }
                    this.col_type[i] = 1111;
                    switch (col_info[i].getCollectionBaseType()) {
                        case 1: {
                            this.ele_type[i] = 1;
                            this.ele_type_name[i] = "CHAR";
                            continue block52;
                        }
                        case 2: {
                            this.ele_type[i] = 12;
                            this.ele_type_name[i] = "VARCHAR";
                            continue block52;
                        }
                        case 25: {
                            this.ele_type[i] = 12;
                            this.ele_type_name[i] = "ENUM";
                            continue block52;
                        }
                        case 5: {
                            if (col_info[i].getColumnPrecision() == 8) {
                                this.ele_type[i] = -7;
                                this.ele_type_name[i] = "BIT";
                                continue block52;
                            }
                            this.ele_type[i] = -2;
                            this.ele_type_name[i] = "BIT";
                            continue block52;
                        }
                        case 6: {
                            this.ele_type[i] = -3;
                            this.ele_type_name[i] = "BIT VARYING";
                            continue block52;
                        }
                        case 9: {
                            this.ele_type[i] = 5;
                            this.ele_type_name[i] = "SMALLINT";
                            continue block52;
                        }
                        case 8: {
                            this.ele_type[i] = 4;
                            this.ele_type_name[i] = "INTEGER";
                            continue block52;
                        }
                        case 21: {
                            this.ele_type[i] = -5;
                            this.ele_type_name[i] = "BIGINT";
                            continue block52;
                        }
                        case 11: {
                            this.ele_type[i] = 7;
                            this.ele_type_name[i] = "FLOAT";
                            continue block52;
                        }
                        case 12: {
                            this.ele_type[i] = 8;
                            this.ele_type_name[i] = "DOUBLE";
                            continue block52;
                        }
                        case 7: {
                            this.ele_type[i] = 2;
                            this.ele_type_name[i] = "NUMERIC";
                            continue block52;
                        }
                        case 10: {
                            this.ele_type[i] = 8;
                            this.ele_type_name[i] = "MONETARY";
                            continue block52;
                        }
                        case 13: {
                            this.ele_type[i] = 91;
                            this.ele_type_name[i] = "DATE";
                            continue block52;
                        }
                        case 14: {
                            this.ele_type[i] = 92;
                            this.ele_type_name[i] = "TIME";
                            continue block52;
                        }
                        case 15: {
                            this.ele_type[i] = 93;
                            this.ele_type_name[i] = "TIMESTAMP";
                            continue block52;
                        }
                        case 22: {
                            this.ele_type[i] = 93;
                            this.ele_type_name[i] = "DATETIME";
                            continue block52;
                        }
                        case 0: {
                            this.ele_type[i] = 0;
                            this.ele_type_name[i] = "";
                            continue block52;
                        }
                        case 19: {
                            this.ele_type[i] = 1111;
                            this.ele_type_name[i] = "CLASS";
                            continue block52;
                        }
                        case 16: {
                            this.ele_type[i] = 1111;
                            this.ele_type_name[i] = "SET";
                            continue block52;
                        }
                        case 17: {
                            this.ele_type[i] = 1111;
                            this.ele_type_name[i] = "MULTISET";
                            continue block52;
                        }
                        case 18: {
                            this.ele_type[i] = 1111;
                            this.ele_type_name[i] = "SEQUENCE";
                            continue block52;
                        }
                        case 3: {
                            this.ele_type[i] = 1;
                            this.ele_type_name[i] = "NCHAR";
                            continue block52;
                        }
                        case 4: {
                            this.ele_type[i] = 12;
                            this.ele_type_name[i] = "NCHAR VARYING";
                            continue block52;
                        }
                    }
                    continue block52;
                }
                case 3: {
                    this.col_type_name[i] = "NCHAR";
                    this.col_type[i] = 1;
                    this.ele_type[i] = -1;
                    if (this.col_prec[i] <= this.col_disp_size[i]) continue block52;
                    this.col_disp_size[i] = this.col_prec[i];
                    continue block52;
                }
                case 4: {
                    this.col_type_name[i] = "NCHAR VARYING";
                    this.col_type[i] = 12;
                    this.ele_type[i] = -1;
                    if (this.col_prec[i] <= this.col_disp_size[i]) continue block52;
                    this.col_disp_size[i] = this.col_prec[i];
                    continue block52;
                }
                case 23: {
                    this.col_type_name[i] = "BLOB";
                    this.col_type[i] = 2004;
                    this.ele_type[i] = -1;
                    continue block52;
                }
                case 24: {
                    this.col_type_name[i] = "CLOB";
                    this.col_type[i] = 2005;
                    this.ele_type[i] = -1;
                    continue block52;
                }
            }
        }
    }

    CUBRIDResultSetMetaData(CUBRIDResultSetWithoutQuery r) {
        this.col_name = r.column_name;
        this.col_type = new int[this.col_name.length];
        this.ele_type = new int[this.col_name.length];
        this.col_type_name = new String[this.col_name.length];
        this.col_prec = new int[this.col_name.length];
        this.col_disp_size = new int[this.col_name.length];
        this.col_scale = new int[this.col_name.length];
        this.col_table = new String[this.col_name.length];
        this.col_null = new int[this.col_name.length];
        this.col_class_name = new String[this.col_name.length];
        this.is_auto_increment_col = new boolean[this.col_name.length];
        for (int i = 0; i < this.col_name.length; ++i) {
            this.col_disp_size[i] = this.getDefaultColumnDisplaySize((byte)r.type[i]);
            if (r.type[i] == 5) {
                this.col_type[i] = -7;
                this.col_type_name[i] = "BIT";
                this.col_prec[i] = 1;
                this.col_class_name[i] = "byte[]";
            }
            if (r.type[i] == 8) {
                this.col_type[i] = 4;
                this.col_type_name[i] = "INTEGER";
                this.col_prec[i] = 10;
                this.col_class_name[i] = "java.lang.Integer";
            }
            if (r.type[i] == 9) {
                this.col_type[i] = 5;
                this.col_type_name[i] = "SMALLINT";
                this.col_prec[i] = 5;
                this.col_class_name[i] = "java.lang.Short";
            }
            if (r.type[i] == 2) {
                this.col_type[i] = 12;
                this.col_type_name[i] = "VARCHAR";
                this.col_prec[i] = r.precision[i];
                if (this.col_prec[i] > this.col_disp_size[i]) {
                    this.col_disp_size[i] = this.col_prec[i];
                }
                this.col_class_name[i] = "java.lang.String";
            }
            if (r.type[i] == 25) {
                this.col_type[i] = 12;
                this.col_type_name[i] = "ENUM";
                this.col_prec[i] = r.precision[i];
                if (this.col_prec[i] > this.col_disp_size[i]) {
                    this.col_disp_size[i] = this.col_prec[i];
                }
                this.col_class_name[i] = "java.lang.String";
            }
            if (r.type[i] == 0) {
                this.col_type[i] = 0;
                this.col_type_name[i] = "";
                this.col_prec[i] = 0;
                this.col_class_name[i] = "";
            }
            this.col_scale[i] = 0;
            this.ele_type[i] = -1;
            this.col_table[i] = "";
            this.col_null[i] = r.nullable[i] ? 1 : 0;
            this.is_auto_increment_col[i] = false;
        }
    }

    private int getDefaultColumnDisplaySize(byte type) {
        int ret_size = -1;
        switch (type) {
            case 1: {
                ret_size = 1;
                break;
            }
            case 2: 
            case 25: {
                ret_size = 1;
                break;
            }
            case 5: {
                ret_size = 1;
                break;
            }
            case 6: {
                ret_size = 1;
                break;
            }
            case 9: {
                ret_size = 6;
                break;
            }
            case 8: {
                ret_size = 11;
                break;
            }
            case 21: {
                ret_size = 20;
                break;
            }
            case 11: {
                ret_size = 13;
                break;
            }
            case 12: {
                ret_size = 23;
                break;
            }
            case 7: {
                ret_size = 40;
                break;
            }
            case 10: {
                ret_size = 23;
                break;
            }
            case 13: {
                ret_size = 10;
                break;
            }
            case 14: {
                ret_size = 8;
                break;
            }
            case 15: {
                ret_size = 19;
                break;
            }
            case 22: {
                ret_size = 19;
                break;
            }
            case 0: {
                ret_size = 4;
                break;
            }
            case 19: {
                ret_size = 256;
                break;
            }
            case 16: 
            case 17: 
            case 18: {
                ret_size = -1;
                break;
            }
            case 3: {
                ret_size = 1;
                break;
            }
            case 4: {
                ret_size = 1;
                break;
            }
        }
        return ret_size;
    }

    @Override
    public int getColumnCount() throws SQLException {
        return this.col_name.length;
    }

    @Override
    public boolean isAutoIncrement(int column) throws SQLException {
        this.checkColumnIndex(column);
        return this.is_auto_increment_col[column - 1];
    }

    @Override
    public boolean isCaseSensitive(int column) throws SQLException {
        this.checkColumnIndex(column);
        return this.col_type[column - 1] == 1 || this.col_type[column - 1] == 12 || this.col_type[column - 1] == -1;
    }

    @Override
    public boolean isSearchable(int column) throws SQLException {
        this.checkColumnIndex(column);
        return true;
    }

    @Override
    public boolean isCurrency(int column) throws SQLException {
        this.checkColumnIndex(column);
        if (UJCIUtil.isMysqlMode(this.getClass())) {
            return false;
        }
        return this.col_type[column - 1] == 8 || this.col_type[column - 1] == 7 || this.col_type[column - 1] == 2;
    }

    @Override
    public int isNullable(int column) throws SQLException {
        this.checkColumnIndex(column);
        return this.col_null[column - 1];
    }

    @Override
    public boolean isSigned(int column) throws SQLException {
        this.checkColumnIndex(column);
        return this.col_type[column - 1] == 5 || this.col_type[column - 1] == 4 || this.col_type[column - 1] == 2 || this.col_type[column - 1] == 3 || this.col_type[column - 1] == 7 || this.col_type[column - 1] == 8;
    }

    @Override
    public int getColumnDisplaySize(int column) throws SQLException {
        this.checkColumnIndex(column);
        return this.col_disp_size[column - 1];
    }

    @Override
    public String getColumnLabel(int column) throws SQLException {
        this.checkColumnIndex(column);
        return this.getColumnName(column);
    }

    @Override
    public String getColumnName(int column) throws SQLException {
        this.checkColumnIndex(column);
        return this.col_name[column - 1];
    }

    @Override
    public String getSchemaName(int column) throws SQLException {
        this.checkColumnIndex(column);
        return "";
    }

    @Override
    public int getPrecision(int column) throws SQLException {
        this.checkColumnIndex(column);
        return this.col_prec[column - 1];
    }

    @Override
    public int getScale(int column) throws SQLException {
        this.checkColumnIndex(column);
        return this.col_scale[column - 1];
    }

    @Override
    public String getTableName(int column) throws SQLException {
        this.checkColumnIndex(column);
        return this.col_table[column - 1];
    }

    @Override
    public String getCatalogName(int column) throws SQLException {
        this.checkColumnIndex(column);
        return "";
    }

    @Override
    public int getColumnType(int column) throws SQLException {
        this.checkColumnIndex(column);
        return this.col_type[column - 1];
    }

    @Override
    public String getColumnTypeName(int column) throws SQLException {
        this.checkColumnIndex(column);
        return this.col_type_name[column - 1];
    }

    @Override
    public boolean isReadOnly(int column) throws SQLException {
        this.checkColumnIndex(column);
        return false;
    }

    @Override
    public boolean isWritable(int column) throws SQLException {
        this.checkColumnIndex(column);
        return true;
    }

    @Override
    public boolean isDefinitelyWritable(int column) throws SQLException {
        this.checkColumnIndex(column);
        return false;
    }

    @Override
    public String getColumnClassName(int column) throws SQLException {
        this.checkColumnIndex(column);
        return this.col_class_name[column - 1];
    }

    public int getElementType(int column) throws SQLException {
        this.checkColumnIndex(column);
        String type = this.getColumnTypeName(column);
        if (!(type.equals("SET") || type.equals("MULTISET") || type.equals("SEQUENCE"))) {
            throw new CUBRIDException(CUBRIDJDBCErrorCode.not_collection);
        }
        return this.ele_type[column - 1];
    }

    public String getElementTypeName(int column) throws SQLException {
        this.checkColumnIndex(column);
        String type = this.getColumnTypeName(column);
        if (!(type.equals("SET") || type.equals("MULTISET") || type.equals("SEQUENCE"))) {
            throw new CUBRIDException(CUBRIDJDBCErrorCode.not_collection);
        }
        return this.ele_type_name[column - 1];
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        throw new UnsupportedOperationException();
    }

    private void checkColumnIndex(int column) throws SQLException {
        if (column < 1 || column > this.col_name.length) {
            throw new CUBRIDException(CUBRIDJDBCErrorCode.invalid_index);
        }
    }
}

