/*
 * Decompiled with CFR 0.152.
 */
package cubrid.jdbc.driver;

import cubrid.jdbc.driver.CUBRIDConnection;
import cubrid.jdbc.driver.CUBRIDDatabaseMetaData;
import cubrid.jdbc.driver.CUBRIDJDBCErrorCode;
import cubrid.jdbc.jci.UConnection;
import cubrid.jdbc.jci.UError;
import cubrid.jdbc.jci.UShardInfo;
import java.sql.SQLException;

public class CUBRIDShardMetaData {
    CUBRIDConnection con;
    UConnection u_con;
    UError error;
    boolean is_closed;
    CUBRIDDatabaseMetaData[] metadata = null;

    protected CUBRIDShardMetaData(CUBRIDConnection c) {
        this.con = c;
        this.u_con = this.con.u_con;
        this.error = null;
        this.is_closed = false;
        this.metadata = null;
    }

    synchronized void close() {
        this.is_closed = true;
        this.con = null;
        this.u_con = null;
        this.error = null;
        this.metadata = null;
    }

    private void checkIsOpen() throws SQLException {
        if (this.is_closed) {
            throw this.con.createCUBRIDException(CUBRIDJDBCErrorCode.dbmetadata_closed, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized CUBRIDDatabaseMetaData getMetaData(int shard_id) throws SQLException {
        UShardInfo shard_info;
        int num_shard;
        this.checkIsOpen();
        if (this.metadata != null) {
            UShardInfo shard_info2 = this.u_con.getShardInfo(shard_id);
            switch (this.error.getErrorCode()) {
                case 0: {
                    break;
                }
                default: {
                    throw this.con.createCUBRIDException(this.error);
                }
            }
            return this.metadata[shard_id];
        }
        UConnection uConnection = this.u_con;
        synchronized (uConnection) {
            num_shard = this.u_con.shardInfo();
            this.error = this.u_con.getRecentError();
            switch (this.error.getErrorCode()) {
                case 0: {
                    break;
                }
                default: {
                    throw this.con.createCUBRIDException(this.error);
                }
            }
        }
        this.metadata = new CUBRIDDatabaseMetaData[num_shard];
        for (int i = 0; i < num_shard; ++i) {
            this.metadata[i] = new CUBRIDDatabaseMetaData(this.con);
            shard_info = this.u_con.getShardInfo(i);
            this.error = this.u_con.getRecentError();
            switch (this.error.getErrorCode()) {
                case 0: {
                    break;
                }
                default: {
                    this.metadata = null;
                    throw this.con.createCUBRIDException(this.error);
                }
            }
            this.metadata[i].setShardId(shard_info.getShardId());
        }
        shard_info = this.u_con.getShardInfo(shard_id);
        switch (this.error.getErrorCode()) {
            case 0: {
                break;
            }
            default: {
                throw this.con.createCUBRIDException(this.error);
            }
        }
        return this.metadata[shard_id];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized int getShardCount() throws SQLException {
        this.checkIsOpen();
        int count = 0;
        UConnection uConnection = this.u_con;
        synchronized (uConnection) {
            count = this.u_con.getShardCount();
            this.error = this.u_con.getRecentError();
        }
        switch (this.error.getErrorCode()) {
            case 0: {
                break;
            }
            default: {
                throw this.con.createCUBRIDException(this.error);
            }
        }
        return count;
    }
}

