/*
 * Decompiled with CFR 0.152.
 */
package cubrid.jdbc.driver;

import cubrid.jdbc.driver.CUBRIDCancelQueryThread;
import cubrid.jdbc.driver.CUBRIDConnection;
import cubrid.jdbc.driver.CUBRIDException;
import cubrid.jdbc.driver.CUBRIDJDBCErrorCode;
import cubrid.jdbc.driver.CUBRIDResultSet;
import cubrid.jdbc.jci.UBatchResult;
import cubrid.jdbc.jci.UConnection;
import cubrid.jdbc.jci.UError;
import cubrid.jdbc.jci.UResCache;
import cubrid.jdbc.jci.UResultInfo;
import cubrid.jdbc.jci.UStatement;
import cubrid.jdbc.jci.UStatementCacheData;
import cubrid.sql.CUBRIDOID;
import java.sql.BatchUpdateException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CUBRIDStatement
implements Statement {
    protected CUBRIDConnection con;
    protected UConnection u_con;
    protected UStatement u_stmt;
    protected UStatement auto_generatedkeys_stmt;
    protected UError error;
    protected boolean completed;
    protected UResultInfo[] result_info;
    protected CUBRIDResultSet current_result_set;
    protected CUBRIDResultSet auto_generatedkeys_result_set;
    protected boolean is_closed;
    protected int update_count;
    protected boolean query_info_flag;
    protected boolean only_query_plan;
    protected int autoGeneratedKeys = 0;
    private int max_field_size;
    private int max_rows;
    int query_timeout;
    private int type;
    private int concurrency;
    private boolean is_scrollable;
    private boolean is_updatable;
    private boolean is_holdable;
    private boolean is_sensitive;
    private int fetch_direction;
    private int fetch_size;
    private ArrayList<String> batchs;
    private int result_index;
    private boolean is_from_current_transaction;
    private int lastShardId;

    protected CUBRIDStatement(CUBRIDConnection c, int t, int concur, int hold) {
        this.con = c;
        this.u_con = this.con.u_con;
        this.u_stmt = null;
        this.is_closed = false;
        this.max_field_size = 0;
        this.max_rows = 0;
        this.update_count = -1;
        this.current_result_set = null;
        this.auto_generatedkeys_result_set = null;
        this.auto_generatedkeys_stmt = null;
        this.query_timeout = 0;
        this.error = null;
        this.type = t;
        this.concurrency = concur;
        this.is_scrollable = t != 1003;
        this.is_updatable = concur == 1008;
        this.is_holdable = false;
        if (hold == 1 && this.u_con.supportHoldableResult()) {
            this.is_holdable = true;
        }
        this.is_sensitive = t == 1005;
        this.fetch_direction = 1000;
        this.fetch_size = 0;
        this.batchs = new ArrayList();
        this.completed = true;
        this.result_info = null;
        this.query_info_flag = false;
        this.only_query_plan = false;
        this.is_from_current_transaction = true;
        this.lastShardId = -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ResultSet executeQuery(String sql) throws SQLException {
        try {
            this.checkIsOpen();
            CUBRIDConnection cUBRIDConnection = this.con;
            synchronized (cUBRIDConnection) {
                CUBRIDStatement cUBRIDStatement = this;
                synchronized (cUBRIDStatement) {
                    long begin = 0L;
                    this.setShardId(-1);
                    this.u_con.setBeginTime();
                    if (this.u_con.getLogSlowQuery()) {
                        begin = System.currentTimeMillis();
                    }
                    this.checkIsOpen();
                    if (!this.completed) {
                        this.complete();
                    }
                    this.prepare(sql);
                    if (!this.u_stmt.getSqlType()) {
                        this.u_stmt.close();
                        this.u_stmt = null;
                        throw this.con.createCUBRIDException(CUBRIDJDBCErrorCode.invalid_query_type_for_executeQuery, null);
                    }
                    this.executeCore(false);
                    this.getMoreResults();
                    this.current_result_set.complete_on_close = true;
                    if (this.u_con.getLogSlowQuery()) {
                        long end = System.currentTimeMillis();
                        this.u_con.logSlowQuery(begin, end, sql, null);
                    }
                    return this.current_result_set;
                }
            }
        }
        catch (NullPointerException e) {
            throw this.con.createCUBRIDException(CUBRIDJDBCErrorCode.statement_closed, e);
        }
    }

    @Override
    public int executeUpdate(String sql) throws SQLException {
        int returnvalue = this.executeUpdate(sql, 2);
        return returnvalue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws SQLException {
        try {
            CUBRIDConnection cUBRIDConnection = this.con;
            synchronized (cUBRIDConnection) {
                CUBRIDStatement cUBRIDStatement = this;
                synchronized (cUBRIDStatement) {
                    this.lastShardId = -1;
                    if (this.is_closed) {
                        return;
                    }
                    this.complete();
                    this.is_closed = true;
                    this.con.removeStatement(this);
                    this.con = null;
                    this.u_con = null;
                    this.error = null;
                }
            }
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    @Override
    public synchronized int getMaxFieldSize() throws SQLException {
        this.checkIsOpen();
        return this.max_field_size;
    }

    @Override
    public synchronized void setMaxFieldSize(int max) throws SQLException {
        this.checkIsOpen();
        if (max < 0) {
            throw new IllegalArgumentException();
        }
        this.max_field_size = max;
    }

    @Override
    public synchronized int getMaxRows() throws SQLException {
        this.checkIsOpen();
        return this.max_rows;
    }

    @Override
    public synchronized void setMaxRows(int max) throws SQLException {
        this.checkIsOpen();
        if (max < 0) {
            throw new IllegalArgumentException();
        }
        this.max_rows = max;
    }

    @Override
    public synchronized void setEscapeProcessing(boolean enable) throws SQLException {
        this.checkIsOpen();
    }

    @Override
    public synchronized int getQueryTimeout() throws SQLException {
        this.checkIsOpen();
        return this.query_timeout;
    }

    @Override
    public synchronized void setQueryTimeout(int seconds) throws SQLException {
        this.checkIsOpen();
        if (seconds < 0 || seconds > 2000000) {
            throw new IllegalArgumentException();
        }
        this.query_timeout = seconds;
    }

    @Override
    public void cancel() throws SQLException {
        try {
            this.checkIsOpen();
            UError err = this.u_stmt.cancel();
            switch (err.getErrorCode()) {
                case 0: {
                    break;
                }
                default: {
                    throw this.con.createCUBRIDException(err);
                }
            }
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    @Override
    public synchronized SQLWarning getWarnings() throws SQLException {
        this.checkIsOpen();
        return null;
    }

    @Override
    public synchronized void clearWarnings() throws SQLException {
        this.checkIsOpen();
    }

    @Override
    public synchronized void setCursorName(String name) throws SQLException {
        this.checkIsOpen();
    }

    @Override
    public boolean execute(String sql) throws SQLException {
        boolean returnvalue = this.execute(sql, 2);
        return returnvalue;
    }

    @Override
    public synchronized ResultSet getResultSet() throws SQLException {
        this.checkIsOpen();
        return this.current_result_set;
    }

    @Override
    public synchronized int getUpdateCount() throws SQLException {
        this.checkIsOpen();
        return this.update_count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean getMoreResults() throws SQLException {
        try {
            this.checkIsOpen();
            CUBRIDConnection cUBRIDConnection = this.con;
            synchronized (cUBRIDConnection) {
                CUBRIDStatement cUBRIDStatement = this;
                synchronized (cUBRIDStatement) {
                    boolean result_type;
                    this.checkIsOpen();
                    if (this.current_result_set != null) {
                        this.current_result_set.close();
                        this.current_result_set = null;
                    }
                    if (this.completed) {
                        this.update_count = -1;
                        return false;
                    }
                    if (this.result_index == this.result_info.length) {
                        if (this.u_stmt.getCommandType() != 126) {
                            this.complete();
                        }
                        this.update_count = -1;
                        return false;
                    }
                    if (this.result_index != 0) {
                        this.u_stmt.nextResult();
                        this.error = this.u_stmt.getRecentError();
                        switch (this.error.getErrorCode()) {
                            case 0: {
                                break;
                            }
                            default: {
                                throw this.con.createCUBRIDException(this.error);
                            }
                        }
                    }
                    if (result_type = this.result_info[this.result_index].isResultSet()) {
                        int rs_type = this.type;
                        int rs_concurrency = this.concurrency;
                        if (this.type == 1005 && !this.u_stmt.isOIDIncluded()) {
                            rs_type = 1004;
                        }
                        if (this.concurrency == 1008 && !this.u_stmt.isOIDIncluded()) {
                            rs_concurrency = 1007;
                        }
                        this.current_result_set = new CUBRIDResultSet(this.con, this, rs_type, rs_concurrency, this.is_holdable);
                        this.update_count = -1;
                    } else {
                        this.update_count = this.result_info[this.result_index].getResultCount();
                    }
                    ++this.result_index;
                    return result_type;
                }
            }
        }
        catch (NullPointerException e) {
            throw this.con.createCUBRIDException(CUBRIDJDBCErrorCode.statement_closed, e);
        }
    }

    @Override
    public synchronized void setFetchDirection(int direction) throws SQLException {
        this.checkIsOpen();
        if (!this.is_scrollable) {
            throw this.con.createCUBRIDException(CUBRIDJDBCErrorCode.non_scrollable_statement, null);
        }
        switch (direction) {
            case 1000: 
            case 1001: 
            case 1002: {
                this.fetch_direction = direction;
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
    }

    @Override
    public synchronized int getFetchDirection() throws SQLException {
        this.checkIsOpen();
        return this.fetch_direction;
    }

    @Override
    public synchronized void setFetchSize(int rows) throws SQLException {
        this.checkIsOpen();
        if (rows <= 0) {
            throw new IllegalArgumentException();
        }
        this.fetch_size = rows;
    }

    @Override
    public synchronized int getFetchSize() throws SQLException {
        this.checkIsOpen();
        return this.fetch_size;
    }

    @Override
    public synchronized int getResultSetConcurrency() throws SQLException {
        this.checkIsOpen();
        return this.concurrency;
    }

    @Override
    public synchronized int getResultSetType() throws SQLException {
        this.checkIsOpen();
        return this.type;
    }

    @Override
    public synchronized void addBatch(String sql) throws SQLException {
        this.checkIsOpen();
        this.batchs.add(sql);
    }

    @Override
    public synchronized void clearBatch() throws SQLException {
        this.checkIsOpen();
        this.batchs.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int[] executeBatch() throws SQLException {
        try {
            this.checkIsOpen();
            CUBRIDConnection cUBRIDConnection = this.con;
            synchronized (cUBRIDConnection) {
                CUBRIDStatement cUBRIDStatement = this;
                synchronized (cUBRIDStatement) {
                    this.setShardId(-1);
                    this.checkIsOpen();
                    if (this.batchs.size() == 0) {
                        return new int[0];
                    }
                    this.u_con.setBeginTime();
                    if (!this.completed) {
                        this.complete();
                    }
                    String[] batch_querys = new String[this.batchs.size()];
                    for (int i = 0; i < this.batchs.size(); ++i) {
                        batch_querys[i] = this.batchs.get(i);
                    }
                    UBatchResult batch_results = this.u_con.batchExecute(batch_querys, this.query_timeout);
                    this.setShardId(this.u_con.getShardId());
                    this.error = this.u_con.getRecentError();
                    this.batchs.clear();
                    switch (this.error.getErrorCode()) {
                        case 0: {
                            break;
                        }
                        default: {
                            throw this.con.createCUBRIDException(this.error);
                        }
                    }
                    this.con.autoCommit();
                    return this.checkBatchResult(batch_results);
                }
            }
        }
        catch (NullPointerException e) {
            throw this.con.createCUBRIDException(CUBRIDJDBCErrorCode.statement_closed, e);
        }
    }

    @Override
    public synchronized Connection getConnection() throws SQLException {
        this.checkIsOpen();
        return this.con;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized boolean execute(String sql, int autoGeneratedKeys) throws SQLException {
        try {
            this.checkIsOpen();
            CUBRIDConnection cUBRIDConnection = this.con;
            synchronized (cUBRIDConnection) {
                CUBRIDStatement cUBRIDStatement = this;
                synchronized (cUBRIDStatement) {
                    long begin = 0L;
                    this.u_con.setBeginTime();
                    if (this.u_con.getLogSlowQuery()) {
                        begin = System.currentTimeMillis();
                    }
                    this.checkIsOpen();
                    if (!this.completed) {
                        this.complete();
                    }
                    this.prepare(sql);
                    this.autoGeneratedKeys = autoGeneratedKeys;
                    if (this.autoGeneratedKeys == 1 && this.u_stmt.getCommandType() == 20) {
                        this.u_stmt.setAutoGeneratedKeys(true);
                    }
                    this.executeCore(true);
                    if (this.autoGeneratedKeys == 1 && this.u_stmt.getCommandType() == 20) {
                        this.MakeAutoGeneratedKeysResultSet();
                    } else {
                        this.resetGeneratedKeysResultSet();
                    }
                    if (this.u_con.getLogSlowQuery()) {
                        long end = System.currentTimeMillis();
                        this.u_con.logSlowQuery(begin, end, sql, null);
                    }
                    return this.getMoreResults();
                }
            }
        }
        catch (NullPointerException e) {
            throw this.con.createCUBRIDException(CUBRIDJDBCErrorCode.statement_closed, e);
        }
    }

    @Override
    public synchronized boolean execute(String sql, int[] columnIndexes) throws SQLException {
        boolean returnvalue = this.execute(sql, 2);
        return returnvalue;
    }

    @Override
    public synchronized boolean execute(String sql, String[] columnNames) throws SQLException {
        boolean returnvalue = this.execute(sql, 2);
        return returnvalue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized int executeUpdate(String sql, int autoGeneratedKeys) throws SQLException {
        try {
            this.checkIsOpen();
            CUBRIDConnection cUBRIDConnection = this.con;
            synchronized (cUBRIDConnection) {
                CUBRIDStatement cUBRIDStatement = this;
                synchronized (cUBRIDStatement) {
                    long begin = 0L;
                    this.setShardId(-1);
                    this.u_con.setBeginTime();
                    if (this.u_con.getLogSlowQuery()) {
                        begin = System.currentTimeMillis();
                    }
                    this.checkIsOpen();
                    if (!this.completed) {
                        this.complete();
                    }
                    this.prepare(sql);
                    if (this.u_stmt.getSqlType()) {
                        this.u_stmt.close();
                        this.u_stmt = null;
                        throw this.con.createCUBRIDException(CUBRIDJDBCErrorCode.invalid_query_type_for_executeUpdate, null);
                    }
                    this.autoGeneratedKeys = autoGeneratedKeys;
                    if (this.autoGeneratedKeys == 1 && this.u_stmt.getCommandType() == 20) {
                        this.u_stmt.setAutoGeneratedKeys(true);
                    }
                    this.executeCore(false);
                    if (autoGeneratedKeys == 1 && this.u_stmt.getCommandType() == 20) {
                        this.MakeAutoGeneratedKeysResultSet();
                    } else {
                        this.resetGeneratedKeysResultSet();
                    }
                    this.getMoreResults();
                    this.complete();
                    if (this.u_con.getLogSlowQuery()) {
                        long end = System.currentTimeMillis();
                        this.u_con.logSlowQuery(begin, end, sql, null);
                    }
                    return this.update_count;
                }
            }
        }
        catch (NullPointerException e) {
            throw this.con.createCUBRIDException(CUBRIDJDBCErrorCode.statement_closed, e);
        }
    }

    @Override
    public synchronized int executeUpdate(String sql, int[] columnIndexes) throws SQLException {
        int returnvalue = this.executeUpdate(sql, 2);
        return returnvalue;
    }

    @Override
    public synchronized int executeUpdate(String sql, String[] columnNames) throws SQLException {
        int returnvalue = this.executeUpdate(sql, 2);
        return returnvalue;
    }

    @Override
    public synchronized ResultSet getGeneratedKeys() throws SQLException {
        this.checkIsOpen();
        if (this.auto_generatedkeys_result_set == null) {
            this.auto_generatedkeys_result_set = new CUBRIDResultSet(null);
        }
        return this.auto_generatedkeys_result_set;
    }

    @Override
    public synchronized boolean getMoreResults(int current) throws SQLException {
        throw new UnsupportedOperationException();
    }

    int getHoldability() {
        if (this.is_holdable) {
            return 1;
        }
        return 2;
    }

    @Override
    public synchronized int getResultSetHoldability() throws SQLException {
        this.checkIsOpen();
        return this.getHoldability();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CUBRIDOID executeInsert(String sql) throws SQLException {
        try {
            CUBRIDConnection cUBRIDConnection = this.con;
            synchronized (cUBRIDConnection) {
                CUBRIDStatement cUBRIDStatement = this;
                synchronized (cUBRIDStatement) {
                    this.setShardId(-1);
                    this.u_con.setBeginTime();
                    this.checkIsOpen();
                    if (!this.completed) {
                        this.complete();
                    }
                    this.prepare(sql);
                    if (this.autoGeneratedKeys == 1 && this.u_stmt.getCommandType() == 20) {
                        this.u_stmt.setAutoGeneratedKeys(true);
                    }
                    CUBRIDOID oid = this.executeInsertCore();
                    this.complete();
                    return oid;
                }
            }
        }
        catch (NullPointerException e) {
            throw this.con.createCUBRIDException(CUBRIDJDBCErrorCode.statement_closed, e);
        }
    }

    public byte getStatementType() {
        if (this.u_stmt != null) {
            return this.u_stmt.getCommandType();
        }
        return 127;
    }

    public String getQueryplan(String sql) throws SQLException {
        this.checkIsOpen();
        int error_code = 0;
        if (sql == null) {
            return "";
        }
        String plan = this.u_con.getQueryplanOnly(sql);
        this.error = this.u_con.getRecentError();
        error_code = this.error.getErrorCode();
        this.con.autoRollback();
        if (error_code != 0) {
            throw this.con.createCUBRIDException(this.error);
        }
        if (plan == null) {
            return "";
        }
        return plan;
    }

    public String getQueryplan() throws SQLException {
        this.checkIsOpen();
        int error_code = 0;
        if (this.u_stmt == null) {
            return "";
        }
        String plan = this.u_stmt.getQueryplan();
        this.error = this.u_stmt.getRecentError();
        error_code = this.error.getErrorCode();
        this.con.autoRollback();
        if (error_code != 0) {
            throw this.con.createCUBRIDException(this.error);
        }
        if (plan == null) {
            return "";
        }
        return plan;
    }

    public void setQueryInfo(boolean value) {
        this.query_info_flag = value;
    }

    @Deprecated
    public void setOnlyQueryPlan(boolean value) {
        this.only_query_plan = value;
    }

    @Override
    public boolean isClosed() throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isPoolable() throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setPoolable(boolean poolable) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        throw new UnsupportedOperationException();
    }

    protected CUBRIDOID executeInsertCore() throws SQLException {
        CUBRIDCancelQueryThread t = null;
        this.completed = false;
        this.setCurrentTransaction(true);
        this.setShardId(-1);
        if (this.query_timeout > 0) {
            t = new CUBRIDCancelQueryThread(this, this.query_timeout);
            t.start();
        }
        CUBRIDOID oid = this.u_stmt.executeInsert(false);
        this.setShardId(this.u_con.getShardId());
        if (this.query_timeout > 0) {
            t.queryended();
        }
        this.error = this.u_stmt.getRecentError();
        switch (this.error.getErrorCode()) {
            case 0: {
                break;
            }
            case -21022: {
                this.con.autoRollback();
                throw this.con.createCUBRIDException(CUBRIDJDBCErrorCode.invalid_query_type_for_executeInsert, null);
            }
            default: {
                UError cpErr = new UError(this.error);
                this.con.autoRollback();
                throw this.con.createCUBRIDException(cpErr);
            }
        }
        return oid;
    }

    protected int[] checkBatchResult(UBatchResult batch_results) throws SQLException {
        int[] result = batch_results.getResult();
        if (!batch_results.getErrorFlag()) {
            return result;
        }
        int num_result = batch_results.getResultNumber();
        String[] ErrorMsg = batch_results.getErrorMessage();
        int[] errCode = batch_results.getErrorCode();
        BatchUpdateException bex = null;
        for (int i = 0; i < num_result; ++i) {
            if (result[i] >= 0) continue;
            if (bex == null) {
                bex = new BatchUpdateException(ErrorMsg[i], null, errCode[i], result);
                continue;
            }
            bex.setNextException(new SQLException(ErrorMsg[i], null, errCode[i]));
        }
        throw bex;
    }

    protected void executeCore(boolean all) throws SQLException {
        this.completed = false;
        this.setCurrentTransaction(true);
        if (this.u_stmt.is_result_cacheable()) {
            this.jdbc_cache_make(all);
        } else {
            this.executeCoreInternal(all, null);
        }
        this.result_info = this.u_stmt.getResultInfo();
        this.result_index = 0;
        if (this.con.getAutoCommit() && (this.result_info.length > 1 || this.u_stmt.getCommandType() == 126)) {
            this.u_con.turnOnAutoCommitBySelf();
        }
    }

    protected void executeCoreInternal(boolean all, UStatementCacheData cache_data) throws SQLException {
        CUBRIDCancelQueryThread t = null;
        boolean is_holdable = false;
        boolean isQueryCancelThreadStarted = false;
        this.setShardId(-1);
        if (!(this.query_timeout <= 0 || this.u_con.isConnectedToCubrid() && this.u_con.protoVersionIsAbove(1))) {
            t = new CUBRIDCancelQueryThread(this, this.query_timeout);
            t.start();
            isQueryCancelThreadStarted = true;
        }
        if (this.getResultSetHoldability() == 1) {
            is_holdable = true;
        }
        this.u_stmt.execute(false, this.max_rows, this.max_field_size, all, this.is_sensitive, this.is_scrollable, this.query_info_flag, this.only_query_plan, is_holdable, cache_data, this.query_timeout);
        this.setShardId(this.u_con.getShardId());
        if (isQueryCancelThreadStarted) {
            t.queryended();
        }
        this.error = this.u_stmt.getRecentError();
        this.checkExecuteError();
    }

    protected void jdbc_cache_make(boolean all) throws SQLException {
        UStatementCacheData cache_data = null;
        UResCache res_cache = this.u_stmt.getResCache();
        cache_data = res_cache.getCacheData();
        this.executeCoreInternal(all, cache_data);
        res_cache.saveCacheData(cache_data);
    }

    void complete() throws SQLException {
        if (this.completed) {
            return;
        }
        this.completed = true;
        if (this.current_result_set != null) {
            this.current_result_set.close();
            this.current_result_set = null;
        }
        if (this.u_stmt != null) {
            this.u_stmt.close();
            if (!this.u_stmt.isReturnable()) {
                this.u_stmt = null;
            }
        }
        this.result_info = null;
        if (this.autoGeneratedKeys == 1) {
            this.con.setAutoGeneratedKeys(true);
        } else {
            this.con.setAutoGeneratedKeys(false);
        }
        this.con.autoCommit();
    }

    synchronized void resetGeneratedKeysResultSet() {
        try {
            if (this.auto_generatedkeys_result_set != null) {
                this.auto_generatedkeys_result_set.close();
                this.auto_generatedkeys_result_set = null;
            }
            if (this.auto_generatedkeys_stmt != null) {
                this.auto_generatedkeys_stmt.close(false);
                this.auto_generatedkeys_stmt = null;
            }
        }
        catch (Exception exception) {
        }
        finally {
            this.auto_generatedkeys_result_set = null;
            this.auto_generatedkeys_stmt = null;
        }
    }

    synchronized boolean MakeAutoGeneratedKeysResultSet() throws SQLException {
        this.checkIsOpen();
        if (this.auto_generatedkeys_result_set != null) {
            this.auto_generatedkeys_result_set.close();
            this.auto_generatedkeys_result_set = null;
        }
        this.auto_generatedkeys_stmt = new UStatement(this.u_stmt);
        if (!this.auto_generatedkeys_stmt.getGeneratedKeys()) {
            return false;
        }
        this.error = this.auto_generatedkeys_stmt.getRecentError();
        switch (this.error.getErrorCode()) {
            case 0: {
                break;
            }
            default: {
                throw this.con.createCUBRIDException(this.error);
            }
        }
        this.auto_generatedkeys_result_set = new CUBRIDResultSet(this.auto_generatedkeys_stmt);
        return true;
    }

    private void checkIsOpen() throws SQLException {
        if (this.is_closed) {
            if (this.con != null) {
                throw this.con.createCUBRIDException(CUBRIDJDBCErrorCode.statement_closed, null);
            }
            throw new CUBRIDException(CUBRIDJDBCErrorCode.statement_closed, null);
        }
    }

    private void prepare(String sql) throws SQLException {
        byte prepareFlag = 0;
        if (this.is_updatable || this.is_sensitive) {
            prepareFlag = (byte)(prepareFlag | 2);
        }
        if (this.query_info_flag || this.only_query_plan) {
            prepareFlag = (byte)(prepareFlag | 4);
        }
        if (this.is_holdable) {
            prepareFlag = (byte)(prepareFlag | 8);
        }
        this.u_stmt = this.con.prepare(sql, prepareFlag);
    }

    private void checkExecuteError() throws SQLException {
        switch (this.error.getErrorCode()) {
            case 0: {
                break;
            }
            default: {
                UError cpErr = new UError(this.error);
                this.con.autoRollback();
                throw this.con.createCUBRIDException(cpErr);
            }
        }
    }

    @Override
    public void closeOnCompletion() throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isCloseOnCompletion() throws SQLException {
        throw new UnsupportedOperationException();
    }

    public void setCurrentTransaction(boolean is_from_current_transaction) {
        this.is_from_current_transaction = is_from_current_transaction;
    }

    public boolean isFromCurrentTransaction() {
        return this.is_from_current_transaction;
    }

    public int getShardId() {
        return this.lastShardId;
    }

    protected void setShardId(int shardId) {
        this.lastShardId = shardId;
    }
}

