/*
 * Decompiled with CFR 0.152.
 */
package cubrid.jdbc.driver;

import cubrid.jdbc.driver.CUBRIDConnectionWrapperXA;
import cubrid.jdbc.driver.CUBRIDException;
import cubrid.jdbc.driver.CUBRIDJDBCErrorCode;
import cubrid.jdbc.driver.CUBRIDPooledConnection;
import cubrid.jdbc.driver.CUBRIDXADataSource;
import cubrid.jdbc.driver.CUBRIDXAResource;
import cubrid.jdbc.jci.UConnection;
import cubrid.jdbc.jci.UJCIManager;
import java.sql.Connection;
import java.sql.SQLException;
import javax.sql.XAConnection;
import javax.transaction.xa.XAResource;

public class CUBRIDXAConnection
extends CUBRIDPooledConnection
implements XAConnection {
    private String serverName;
    private int portNumber;
    private String databaseName;
    private String username;
    private String passwd;
    private CUBRIDXAResource xares;
    private boolean xa_started;
    private String xacon_key;

    protected CUBRIDXAConnection(CUBRIDXADataSource xads, String serverName, int portNumber, String databaseName, String username, String passwd) throws SQLException {
        this.serverName = serverName;
        this.portNumber = portNumber;
        this.databaseName = databaseName;
        this.username = username;
        this.passwd = passwd;
        this.u_con = this.createUConnection();
        this.xares = null;
        this.xa_started = false;
        this.xacon_key = xads.getDataSourceID(username);
    }

    public synchronized XAResource getXAResource() throws SQLException {
        if (this.isClosed) {
            throw new CUBRIDException(CUBRIDJDBCErrorCode.xa_connection_closed);
        }
        if (this.xares == null) {
            this.xares = new CUBRIDXAResource(this, this.xacon_key);
        }
        return this.xares;
    }

    public synchronized Connection getConnection() throws SQLException {
        if (this.isClosed) {
            throw new CUBRIDException(CUBRIDJDBCErrorCode.xa_connection_closed);
        }
        if (this.cubConnection != null) {
            this.cubConnection.closeConnection();
        }
        if (this.u_con == null) {
            this.u_con = this.createUConnection();
        }
        this.cubConnection = new CUBRIDConnectionWrapperXA(this.u_con, null, null, this, this.xa_started);
        return this.cubConnection;
    }

    synchronized void notifyConnectionClosed() {
        super.notifyConnectionClosed();
        if (this.xa_started) {
            this.u_con = null;
        }
    }

    synchronized UConnection xa_end_tran(UConnection u) {
        if (this.u_con == null) {
            this.u_con = u;
            return null;
        }
        return u;
    }

    synchronized UConnection xa_start(int flag, UConnection u) {
        if (this.xa_started) {
            return null;
        }
        this.xa_started = true;
        if (flag == 0x200000 || flag == 0x8000000) {
            if (this.u_con != null) {
                this.u_con.close();
            }
            this.u_con = u;
        }
        if (this.cubConnection != null) {
            if (flag == 0) {
                try {
                    this.cubConnection.rollback();
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
            }
            ((CUBRIDConnectionWrapperXA)this.cubConnection).xa_start(this.u_con);
        }
        return this.u_con;
    }

    synchronized boolean xa_end() {
        if (!this.xa_started) {
            return true;
        }
        try {
            if (this.u_con != null) {
                this.u_con = this.createUConnection();
            }
        }
        catch (SQLException e) {
            return false;
        }
        if (this.cubConnection != null) {
            ((CUBRIDConnectionWrapperXA)this.cubConnection).xa_end(this.u_con);
        }
        this.xa_started = false;
        return true;
    }

    UConnection createUConnection() throws SQLException {
        return UJCIManager.connect(this.serverName, this.portNumber, this.databaseName, this.username, this.passwd, "xa");
    }
}

