/*
 * Decompiled with CFR 0.152.
 */
package cubrid.jdbc.jci;

import cubrid.jdbc.driver.CUBRIDDriver;
import cubrid.jdbc.jci.UConnection;
import cubrid.jdbc.jci.UJciException;
import cubrid.jdbc.jci.UTimedDataInputStream;
import cubrid.jdbc.net.BrokerHandler;
import java.io.DataOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.net.Socket;

public class BrokerHealthCheck
extends Thread {
    private static final String HEALTH_CHECK_DUMMY_DB = "___health_check_dummy_db___";
    private static final int BROKER_HEALTH_CHECK_TIMEOUT = 5000;
    private static final int CAS_INFO_SIZE = 4;
    public static final int MONITORING_INTERVAL = 60000;

    public void run() {
        while (true) {
            long elapseTime;
            long startTime = System.currentTimeMillis();
            if (CUBRIDDriver.unreachableHosts == null) {
                return;
            }
            if (CUBRIDDriver.unreachableHosts.size() > 0) {
                for (String host : CUBRIDDriver.unreachableHosts) {
                    String ip = host.split(":")[0];
                    int port = Integer.parseInt(host.split(":")[1]);
                    try {
                        this.checkBrokerAlive(ip, port, 5000);
                        CUBRIDDriver.unreachableHosts.remove(host);
                    }
                    catch (UJciException uJciException) {
                    }
                    catch (IOException iOException) {}
                }
            }
            if ((elapseTime = System.currentTimeMillis() - startTime) >= 60000L) continue;
            try {
                Thread.sleep(60000L - elapseTime);
            }
            catch (InterruptedException interruptedException) {
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkBrokerAlive(String ip, int port, int timeout) throws IOException, UJciException {
        Socket toBroker = null;
        String dummyUrl = "jdbc:cubrid:" + ip + ":" + port + ":" + HEALTH_CHECK_DUMMY_DB + "::********:";
        UTimedDataInputStream is = null;
        FilterOutputStream os = null;
        long startTime = System.currentTimeMillis();
        try {
            toBroker = BrokerHandler.connectBroker(ip, port, timeout);
            if (timeout > 0 && (timeout = (int)((long)timeout - (System.currentTimeMillis() - startTime))) <= 0) {
                throw new UJciException(-21024);
            }
            is = new UTimedDataInputStream(toBroker.getInputStream(), ip, port, timeout);
            os = new DataOutputStream(toBroker.getOutputStream());
            byte[] serverInfo = UConnection.createDBInfo(HEALTH_CHECK_DUMMY_DB, "", "", dummyUrl);
            os.write(serverInfo);
            ((DataOutputStream)os).flush();
            int dataLength = is.readInt();
            byte[] casInfo = new byte[4];
            is.readFully(casInfo);
            if (dataLength < 0) {
                throw new UJciException(-21019);
            }
        }
        finally {
            if (is != null) {
                is.close();
            }
            if (os != null) {
                os.close();
            }
            if (toBroker != null) {
                toBroker.close();
            }
        }
    }
}

