/*
 * Decompiled with CFR 0.152.
 */
package cubrid.jdbc.jci;

import cubrid.jdbc.driver.CUBRIDBlob;
import cubrid.jdbc.driver.CUBRIDClob;
import cubrid.jdbc.driver.CUBRIDConnection;
import cubrid.jdbc.driver.CUBRIDXid;
import cubrid.jdbc.jci.UConnection;
import cubrid.jdbc.jci.UJCIManager;
import cubrid.jdbc.jci.UJCIUtil;
import cubrid.jdbc.jci.UJciException;
import cubrid.jdbc.jci.UTimedDataInputStream;
import cubrid.sql.CUBRIDOID;
import cubrid.sql.CUBRIDTimestamp;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.sql.Date;
import java.sql.Time;
import java.util.Calendar;

class UInputBuffer {
    private UTimedDataInputStream input;
    private int position;
    private int capacity;
    private byte[] casinfo;
    private byte[] buffer;
    private int resCode;
    private static final int CAS_INFO_SIZE = 4;
    private UConnection uconn;

    UInputBuffer(UTimedDataInputStream relatedI, UConnection con) throws IOException, UJciException {
        this.input = relatedI;
        this.position = 0;
        this.uconn = con;
        int readLen = 0;
        byte[] headerData = new byte[8];
        for (int totalReadLen = 0; totalReadLen < 8; totalReadLen += readLen) {
            readLen = this.input.read(headerData, totalReadLen, 8 - totalReadLen);
            if (readLen != -1) continue;
            throw this.uconn.createJciException(-21019);
        }
        this.capacity = UJCIUtil.bytes2int(headerData, 0);
        this.casinfo = new byte[4];
        System.arraycopy(headerData, 4, this.casinfo, 0, 4);
        con.setCASInfo(this.casinfo);
        if (this.capacity <= 0) {
            this.resCode = 0;
            this.capacity = 0;
            return;
        }
        this.buffer = new byte[this.capacity];
        this.readData();
        this.resCode = this.readInt();
        if (this.resCode < 0) {
            String msg;
            int eCode = this.readInt();
            if (con.isRenewedSessionId()) {
                byte[] newSessionId = new byte[20];
                msg = this.readString(this.remainedCapacity() - newSessionId.length, UJCIManager.sysCharsetName);
                this.readBytes(newSessionId);
                con.setNewSessionId(newSessionId);
            } else {
                msg = this.readString(this.remainedCapacity(), UJCIManager.sysCharsetName);
            }
            eCode = this.convertErrorByVersion(this.resCode, eCode);
            throw this.uconn.createJciException(-21002, this.resCode, eCode, msg);
        }
    }

    int convertErrorByVersion(int indicator, int error) {
        if (!(this.uconn.protoVersionIsSame(2) || this.uconn.brokerInfoRenewedErrorCode() || indicator != -1 && error != -10018)) {
            return error - 9000;
        }
        return error;
    }

    byte[] getCasInfo() {
        return this.casinfo;
    }

    int getResCode() {
        return this.resCode;
    }

    byte readByte() throws UJciException {
        if (this.position >= this.capacity) {
            throw this.uconn.createJciException(-21019);
        }
        return this.buffer[this.position++];
    }

    void readBytes(byte[] value, int offset, int len) throws UJciException {
        if (value == null) {
            return;
        }
        if (this.position + len > this.capacity) {
            throw this.uconn.createJciException(-21019);
        }
        System.arraycopy(this.buffer, this.position, value, offset, len);
        this.position += len;
    }

    void readBytes(byte[] value) throws UJciException {
        this.readBytes(value, 0, value.length);
    }

    byte[] readBytes(int size) throws UJciException {
        byte[] value = new byte[size];
        this.readBytes(value, 0, size);
        return value;
    }

    double readDouble() throws UJciException {
        return Double.longBitsToDouble(this.readLong());
    }

    float readFloat() throws UJciException {
        return Float.intBitsToFloat(this.readInt());
    }

    int readInt() throws UJciException {
        if (this.position + 4 > this.capacity) {
            throw this.uconn.createJciException(-21019);
        }
        int data = UJCIUtil.bytes2int(this.buffer, this.position);
        this.position += 4;
        return data;
    }

    long readLong() throws UJciException {
        long data = 0L;
        if (this.position + 8 > this.capacity) {
            throw this.uconn.createJciException(-21019);
        }
        for (int i = 0; i < 8; ++i) {
            data <<= 8;
            data |= (long)(this.buffer[this.position++] & 0xFF);
        }
        return data;
    }

    short readShort() throws UJciException {
        if (this.position + 2 > this.capacity) {
            throw this.uconn.createJciException(-21019);
        }
        short data = UJCIUtil.bytes2short(this.buffer, this.position);
        this.position += 2;
        return data;
    }

    String readString(int size, String charsetName) throws UJciException {
        String stringData;
        if (size <= 0) {
            return null;
        }
        if (this.position + size > this.capacity) {
            throw this.uconn.createJciException(-21019);
        }
        try {
            stringData = new String(this.buffer, this.position, size - 1, charsetName);
        }
        catch (UnsupportedEncodingException e) {
            stringData = new String(this.buffer, this.position, size - 1);
        }
        this.position += size;
        return stringData;
    }

    Date readDate() throws UJciException {
        short year = this.readShort();
        short month = this.readShort();
        short day = this.readShort();
        if (year == 0 && month == 0 && day == 0) {
            if (this.uconn.getZeroDateTimeBehavior().equals("exception")) {
                throw new UJciException(-21027);
            }
            if (this.uconn.getZeroDateTimeBehavior().equals("convertToNull")) {
                return null;
            }
        }
        Calendar cal = Calendar.getInstance();
        if (year == 0 && month == 0 && day == 0) {
            cal.set(0, 0, 1, 0, 0, 0);
        } else {
            cal.set(year, month - 1, day, 0, 0, 0);
        }
        cal.set(14, 0);
        return new Date(cal.getTimeInMillis());
    }

    Time readTime() throws UJciException {
        short hour = this.readShort();
        short minute = this.readShort();
        short second = this.readShort();
        Calendar cal = Calendar.getInstance();
        cal.set(1970, 0, 1, hour, minute, second);
        cal.set(14, 0);
        return new Time(cal.getTimeInMillis());
    }

    CUBRIDTimestamp readTimestamp() throws UJciException {
        short year = this.readShort();
        short month = this.readShort();
        short day = this.readShort();
        short hour = this.readShort();
        short minute = this.readShort();
        short second = this.readShort();
        if (year == 0 && month == 0 && day == 0) {
            if (this.uconn.getZeroDateTimeBehavior().equals("exception")) {
                throw new UJciException(-21027);
            }
            if (this.uconn.getZeroDateTimeBehavior().equals("convertToNull")) {
                return null;
            }
        }
        Calendar cal = Calendar.getInstance();
        if (year == 0 && month == 0 && day == 0) {
            cal.setTimeInMillis(0L);
        } else {
            cal.set(year, month - 1, day, hour, minute, second);
        }
        cal.set(14, 0);
        return new CUBRIDTimestamp(cal.getTimeInMillis(), false);
    }

    CUBRIDTimestamp readDatetime() throws UJciException {
        short year = this.readShort();
        short month = this.readShort();
        short day = this.readShort();
        short hour = this.readShort();
        short minute = this.readShort();
        short second = this.readShort();
        short millisecond = this.readShort();
        if (year == 0 && month == 0 && day == 0) {
            if (this.uconn.getZeroDateTimeBehavior().equals("exception")) {
                throw new UJciException(-21027);
            }
            if (this.uconn.getZeroDateTimeBehavior().equals("convertToNull")) {
                return null;
            }
        }
        Calendar cal = Calendar.getInstance();
        if (year == 0 && month == 0 && day == 0) {
            cal.set(0, 0, 1, 0, 0, 0);
        } else {
            cal.set(year, month - 1, day, hour, minute, second);
        }
        cal.set(14, millisecond);
        return new CUBRIDTimestamp(cal.getTimeInMillis(), true);
    }

    CUBRIDOID readOID(CUBRIDConnection con) throws UJciException {
        byte[] oid = this.readBytes(8);
        for (int i = 0; i < oid.length; ++i) {
            if (oid[i] == 0) continue;
            return new CUBRIDOID(con, oid);
        }
        return null;
    }

    CUBRIDBlob readBlob(int packedLobHandleSize, CUBRIDConnection conn) throws UJciException {
        try {
            byte[] packedLobHandle = this.readBytes(packedLobHandleSize);
            return new CUBRIDBlob(conn, packedLobHandle);
        }
        catch (Exception e) {
            throw this.uconn.createJciException(-21023);
        }
    }

    CUBRIDClob readClob(int packedLobHandleSize, CUBRIDConnection conn) throws UJciException {
        try {
            byte[] packedLobHandle = this.readBytes(packedLobHandleSize);
            return new CUBRIDClob(conn, packedLobHandle, conn.getUConnection().getCharset());
        }
        catch (Exception e) {
            throw this.uconn.createJciException(-21023);
        }
    }

    int remainedCapacity() {
        return this.capacity - this.position;
    }

    CUBRIDXid readXid() throws UJciException {
        this.readInt();
        int formatId = this.readInt();
        int gid_size = this.readInt();
        int bid_size = this.readInt();
        byte[] gid = this.readBytes(gid_size);
        byte[] bid = this.readBytes(bid_size);
        return new CUBRIDXid(formatId, gid, bid);
    }

    private void readData() throws IOException {
        int tempRead = 0;
        for (int realRead = 0; realRead < this.capacity; realRead += tempRead) {
            tempRead = this.input.read(this.buffer, realRead, this.capacity - realRead);
            if (tempRead >= 0) continue;
            this.capacity = realRead;
            break;
        }
    }
}

