/*
 * Decompiled with CFR 0.152.
 */
package cubrid.jdbc.jci;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class UJCIUtil {
    private static boolean bServerSide;
    private static boolean bConsoleDebug;
    private static boolean bMMDB;
    private static boolean bSendAppInfo;
    private static boolean bJDBC4;
    private static Boolean bMysqlMode;
    private static Boolean bOracleMode;

    public static int bytes2int(byte[] b, int startIndex) {
        int data = 0;
        int endIndex = startIndex + 4;
        for (int i = startIndex; i < endIndex; ++i) {
            data <<= 8;
            data |= b[i] & 0xFF;
        }
        return data;
    }

    public static short bytes2short(byte[] b, int startIndex) {
        short data = 0;
        int endIndex = startIndex + 2;
        for (int i = startIndex; i < endIndex; ++i) {
            data = (short)(data << 8);
            data = (short)(data | b[i] & 0xFF);
        }
        return data;
    }

    public static void copy_bytes(byte[] dest, int dIndex, int cpSize, String src) {
        if (src == null) {
            return;
        }
        byte[] b = src.getBytes();
        cpSize = cpSize > b.length ? b.length : cpSize;
        System.arraycopy(b, 0, dest, dIndex, cpSize);
    }

    public static void copy_byte(byte[] dest, int dIndex, byte src) {
        if (dest.length < dIndex) {
            return;
        }
        dest[dIndex] = src;
    }

    public static boolean isMysqlMode(Class<?> c) {
        if (bMysqlMode == null) {
            String[] split = c.getName().split("\\.");
            bMysqlMode = split.length > 2 && split[2].equals("mysql") ? new Boolean(true) : new Boolean(false);
        }
        return bMysqlMode;
    }

    public static boolean isOracleMode(Class<?> c) {
        if (bOracleMode == null) {
            String[] split = c.getName().split("\\.");
            bOracleMode = split.length > 2 && split[2].equals("oracle") ? new Boolean(true) : new Boolean(false);
        }
        return bOracleMode;
    }

    public static boolean isServerSide() {
        return bServerSide;
    }

    public static boolean isConsoleDebug() {
        return bConsoleDebug;
    }

    public static boolean isMMDB() {
        return bMMDB;
    }

    public static boolean isSendAppInfo() {
        return bSendAppInfo;
    }

    public static boolean isJDBC4() {
        return bJDBC4;
    }

    public static Object invoke(String cls_name, String method, Class<?>[] param_cls, Object cls, Object[] params) {
        try {
            Class<?> c = Class.forName(cls_name);
            Method m = c.getMethod(method, param_cls);
            return m.invoke(cls, params);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static Constructor<?> getConstructor(String cls_name, Class<?>[] param_cls) {
        try {
            Class<?> c = Class.forName(cls_name);
            return c.getConstructor(param_cls);
        }
        catch (Exception e) {
            return null;
        }
    }

    static {
        bMysqlMode = null;
        bOracleMode = null;
        String value = System.getProperty("ConsoleDebug");
        bConsoleDebug = value != null && value.equals("true");
        value = System.getProperty("MMDB");
        bMMDB = value != null && value.equals("true");
        value = System.getProperty("SendAppInfo");
        bSendAppInfo = value != null && value.equals("true");
        try {
            Class.forName("com.cubrid.jsp.Server");
            bServerSide = true;
        }
        catch (Throwable t) {
            bServerSide = false;
        }
        try {
            Class.forName("java.sql.NClob");
            bJDBC4 = true;
        }
        catch (Throwable t) {
            bJDBC4 = false;
        }
    }
}

