/*
 * Decompiled with CFR 0.152.
 */
package cubrid.jdbc.log;

import cubrid.jdbc.log.Log;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Hashtable;

public class BasicLogger
implements Log {
    private static final int FATAL = 0;
    private static final int ERROR = 1;
    private static final int WARN = 2;
    private static final int INFO = 3;
    private static final int DEBUG = 4;
    private static final int TRACE = 5;
    private static final int ALL = 6;
    private int logLevel;
    private static Hashtable<String, PrintWriter> writerTable = new Hashtable();
    PrintWriter writer;
    private SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");

    public BasicLogger(String fileName) {
        this.initialize(fileName, 6);
    }

    public BasicLogger(String fileName, int level) {
        this.initialize(fileName, level);
    }

    private void initialize(String fileName, int level) {
        this.logLevel = level;
        try {
            File f = new File(fileName);
            String canonicalPath = f.getCanonicalPath();
            this.writer = writerTable.get(canonicalPath);
            if (this.writer == null) {
                this.writer = new PrintWriter(canonicalPath);
                writerTable.put(canonicalPath, this.writer);
            }
        }
        catch (IOException e) {
            System.err.println("WARNING - Could not create a file for logging.\n The standard error will be using to log.");
            e.printStackTrace();
            this.writer = writerTable.get("stderr");
        }
    }

    public void logDebug(String msg) {
        this.logDebug(msg, null);
    }

    public void logDebug(String msg, Throwable thrown) {
        this.logInternal(4, msg, thrown);
    }

    public void logError(String msg) {
        this.logError(msg, null);
    }

    public void logError(String msg, Throwable thrown) {
        this.logInternal(1, msg, thrown);
    }

    public void logFatal(String msg) {
        this.logFatal(msg, null);
    }

    public void logFatal(String msg, Throwable thrown) {
        this.logInternal(0, msg, thrown);
    }

    public void logInfo(String msg) {
        this.logInfo(msg, null);
    }

    public void logInfo(String msg, Throwable thrown) {
        this.logInternal(3, msg, thrown);
    }

    public void logTrace(String msg) {
        this.logTrace(msg);
    }

    public void logTrace(String msg, Throwable thrown) {
        this.logInternal(5, msg, thrown);
    }

    public void logWarn(String msg) {
        this.logWarn(msg);
    }

    public void logWarn(String msg, Throwable thrown) {
        this.logInternal(2, msg, thrown);
    }

    private synchronized void logInternal(int level, String msg, Throwable thrown) {
        if (this.logLevel < level) {
            return;
        }
        StringBuffer b = new StringBuffer();
        b.append(this.dateFormat.format(new Date())).append('|');
        switch (level) {
            case 0: {
                b.append("FATAL");
                break;
            }
            case 1: {
                b.append("ERROR");
                break;
            }
            case 2: {
                b.append("WARN");
                break;
            }
            case 3: {
                b.append("INFO");
                break;
            }
            case 4: {
                b.append("DEBUG");
                break;
            }
            case 5: {
                b.append("TRACE");
            }
        }
        b.append('|').append(msg);
        this.writer.println(b.toString());
        if (thrown != null) {
            thrown.printStackTrace(this.writer);
        }
        this.writer.flush();
    }

    static {
        writerTable.put("stderr", new PrintWriter(System.err));
    }
}

