/*
 * Decompiled with CFR 0.152.
 */
package cubrid.jdbc.util;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;

public class ByteArrayBuffer {
    private static final int UnitSize = 102400;
    private ArrayList<byte[]> byteArrayList;
    private byte[] baseByteArray;
    private byte[] buffer;
    private int pos;
    private int dataSize;
    private byte[] writeBuffer = new byte[8];

    public ByteArrayBuffer() {
        this.baseByteArray = new byte[102400];
        this.reset();
    }

    public void writeByte(byte v) {
        this.write(v);
    }

    public final void writeShort(int v) throws IOException {
        this.write(v >>> 8 & 0xFF);
        this.write(v >>> 0 & 0xFF);
    }

    public final void writeInt(int v) {
        this.write(v >>> 24 & 0xFF);
        this.write(v >>> 16 & 0xFF);
        this.write(v >>> 8 & 0xFF);
        this.write(v >>> 0 & 0xFF);
    }

    public final void writeLong(long v) {
        this.writeBuffer[0] = (byte)(v >>> 56);
        this.writeBuffer[1] = (byte)(v >>> 48);
        this.writeBuffer[2] = (byte)(v >>> 40);
        this.writeBuffer[3] = (byte)(v >>> 32);
        this.writeBuffer[4] = (byte)(v >>> 24);
        this.writeBuffer[5] = (byte)(v >>> 16);
        this.writeBuffer[6] = (byte)(v >>> 8);
        this.writeBuffer[7] = (byte)(v >>> 0);
        this.write(this.writeBuffer, 0, 8);
    }

    public final void writeFloat(float v) throws IOException {
        this.writeInt(Float.floatToIntBits(v));
    }

    public final void writeDouble(double v) throws IOException {
        this.writeLong(Double.doubleToLongBits(v));
    }

    public final void write(byte[] b, int off, int len) {
        if (b == null) {
            throw new NullPointerException();
        }
        if (off < 0 || off > b.length || len < 0 || off + len > b.length || off + len < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (len == 0) {
            return;
        }
        for (int i = 0; i < len; ++i) {
            this.write(b[off + i]);
        }
    }

    private void write(int b) {
        if (this.pos == 102400) {
            this.byteArrayList.add(this.buffer);
            this.buffer = new byte[102400];
            this.pos = 0;
        }
        this.buffer[this.pos] = (byte)b;
        ++this.pos;
        ++this.dataSize;
    }

    public void merge(int size, ByteArrayBuffer buf) {
        this.writeInt(size);
        byte[] dest = new byte[this.pos];
        System.arraycopy(this.buffer, 0, dest, 0, this.pos);
        this.byteArrayList.add(dest);
        for (byte[] b : buf.byteArrayList) {
            this.byteArrayList.add(b);
        }
        dest = new byte[buf.pos];
        System.arraycopy(buf.buffer, 0, dest, 0, buf.pos);
        this.byteArrayList.add(dest);
        this.buffer = new byte[102400];
        this.pos = 0;
        this.dataSize += size;
    }

    private void writeHeader(byte[] info) {
        byte[] header = null;
        header = this.byteArrayList.size() == 0 ? this.buffer : this.byteArrayList.get(0);
        header[0] = (byte)(this.dataSize >>> 24 & 0xFF);
        header[1] = (byte)(this.dataSize >>> 16 & 0xFF);
        header[2] = (byte)(this.dataSize >>> 8 & 0xFF);
        header[3] = (byte)(this.dataSize >>> 0 & 0xFF);
        header[4] = info[0];
        header[5] = info[1];
        header[6] = info[2];
        header[7] = info[3];
    }

    public void writeToStream(byte[] info, OutputStream o) throws IOException {
        DataOutputStream os = new DataOutputStream(o);
        this.writeHeader(info);
        for (byte[] b : this.byteArrayList) {
            if (b == null) continue;
            os.write(b);
        }
        os.write(this.buffer, 0, this.pos);
        os.flush();
    }

    public void reset() {
        this.byteArrayList = new ArrayList();
        this.buffer = this.baseByteArray;
        this.pos = 8;
        this.dataSize = 0;
    }
}

