/*
 * Decompiled with CFR 0.152.
 */
package com.github.jinahya.jsonrpc.bind.v2.jackson;

import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.NullNode;
import com.fasterxml.jackson.databind.node.NumericNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.TextNode;
import com.fasterxml.jackson.databind.node.ValueNode;
import com.fasterxml.jackson.databind.type.CollectionType;
import com.github.jinahya.jsonrpc.bind.v2.jackson.JacksonRequest;
import java.io.IOException;
import java.util.List;
import javax.validation.constraints.AssertTrue;

public class JacksonServerRequest<IdType extends ValueNode>
extends JacksonRequest<JsonNode, IdType> {
    static boolean isEitherTextNumberOrNull(ValueNode valueNode) {
        if (valueNode == null) {
            throw new NullPointerException("valueNode is null");
        }
        return valueNode instanceof TextNode || valueNode instanceof NumericNode || valueNode instanceof NullNode;
    }

    @AssertTrue(message="a non-null params must be either ArrayNode, ObjectNode, or NullNode")
    private @AssertTrue(message="a non-null params must be either ArrayNode, ObjectNode, or NullNode") boolean isParamsEitherArrayObjectOrNull() {
        JsonNode params = (JsonNode)this.getParams();
        return params == null || params instanceof ArrayNode || params instanceof ObjectNode || params instanceof NullNode;
    }

    @AssertTrue(message="a non-null id must be either TextNode, NumericNode, or NullNode")
    private @AssertTrue(message="a non-null id must be either TextNode, NumericNode, or NullNode") boolean isIdEitherTextNumberOrNull() {
        ValueNode id = (ValueNode)this.getId();
        return id == null || JacksonServerRequest.isEitherTextNumberOrNull(id);
    }

    public <T> T getParamsAsNamed(ObjectMapper objectMapper, Class<? extends T> paramsClass) throws IOException {
        JsonNode params = (JsonNode)this.getParams();
        if (params == null) {
            throw new IllegalStateException("params is currently null");
        }
        if (params instanceof NullNode) {
            return null;
        }
        if (!(params instanceof ObjectNode)) {
            throw new IllegalStateException("params(" + params + ") is not an instance of " + ObjectNode.class);
        }
        String valueString = objectMapper.writeValueAsString((Object)params);
        return (T)objectMapper.readValue(valueString, paramsClass);
    }

    public <T> List<T> getParamsAsPositioned(ObjectMapper objectMapper, Class<?> elementClass) throws IOException {
        JsonNode params = (JsonNode)this.getParams();
        if (params == null) {
            throw new IllegalStateException("params is currently null");
        }
        if (params instanceof NullNode) {
            return null;
        }
        if (!(params instanceof ArrayNode)) {
            throw new IllegalStateException("params(" + params + ") is not an instance of " + ArrayNode.class);
        }
        String valueString = objectMapper.writeValueAsString((Object)params);
        CollectionType collectionType = objectMapper.getTypeFactory().constructCollectionType(List.class, elementClass);
        return (List)objectMapper.readValue(valueString, (JavaType)collectionType);
    }

    @Deprecated
    public Object getParams(ObjectMapper objectMapper, Class<?> namedObjectClass, Class<?> positionedElementClass) throws IOException {
        JsonNode params = (JsonNode)this.getParams();
        if (params == null) {
            throw new IllegalStateException("params property is currently null");
        }
        if (params instanceof NullNode) {
            return null;
        }
        if (params instanceof ObjectNode) {
            return this.getParamsAsNamed(objectMapper, namedObjectClass);
        }
        if (params instanceof ArrayNode) {
            return this.getParamsAsPositioned(objectMapper, positionedElementClass);
        }
        throw new IllegalStateException("unknown param type: " + params);
    }

    public static class Unknown
    extends JacksonServerRequest<ValueNode> {
    }
}

