/*
 * Decompiled with CFR 0.152.
 */
package com.github.jinahya.jsonrpc.bind.v2;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.github.jinahya.jsonrpc.bind.v2.JsonrpcObject;
import javax.json.bind.annotation.JsonbTransient;
import javax.validation.Valid;
import javax.validation.constraints.AssertFalse;
import javax.validation.constraints.NotEmpty;

public class RequestObject<T>
extends JsonrpcObject {
    @NotEmpty
    private String method;
    @Valid
    private T params;

    @Override
    public String toString() {
        return super.toString() + "{method=" + this.method + ",params=" + this.params + "}";
    }

    @JsonIgnore
    @JsonbTransient
    @AssertFalse
    private boolean isMethodNameReservedForRpcInternal() {
        return this.method != null && this.method.startsWith("rpc.");
    }

    @JsonIgnore
    @JsonbTransient
    public boolean isNotification() {
        return this.getId() == null;
    }

    public String getMethod() {
        return this.method;
    }

    public void setMethod(String method) {
        this.method = method;
    }

    public T getParams() {
        return this.params;
    }

    public void setParams(T params) {
        this.params = params;
    }
}

