/*
 * Decompiled with CFR 0.152.
 */
package com.github.jinahya.jsonrpc.bind.v2;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.github.jinahya.jsonrpc.bind.v2.JsonrpcObject;
import javax.json.bind.annotation.JsonbTransient;
import javax.validation.Valid;
import javax.validation.constraints.AssertTrue;
import javax.validation.constraints.NotNull;

public class ResponseObject<T, U extends ErrorObject<?>>
extends JsonrpcObject {
    @Valid
    private T result;
    @Valid
    private U error;

    @Override
    public String toString() {
        return super.toString() + "{result=" + this.result + ",error=" + this.error + "}";
    }

    @JsonIgnore
    @JsonbTransient
    @AssertTrue(message="result and error should be set exclusively")
    private @AssertTrue(message="result and error should be set exclusively") boolean isResultAndErrorExclusive() {
        return this.getResult() != null ^ this.getError() != null;
    }

    public T getResult() {
        return this.result;
    }

    public void setResult(T result) {
        this.result = result;
    }

    public U getError() {
        return this.error;
    }

    public void setError(U error) {
        this.error = error;
    }

    public static class ErrorObject<T> {
        public static final long MIN_RESERVED_CODE_FOR_PREDEFINED_ERRORS = -32768L;
        public static final long MAX_RESERVED_CODE_FOR_PREDEFINED_ERRORS = -32000L;
        public static final long CODE_PARSE_ERROR = -32700L;
        public static final long CODE_INVALID_REQUEST = -32600L;
        public static final long CODE_METHOD_NOT_FOUND = -32601L;
        public static final long CODE_INVALID_PARAMS = -32602L;
        public static final long CODE_INTERNAL_ERROR = -32603L;
        public static final long MIN_RESERVED_CODE_FOR_IMPLEMENTATION_DEFINED_SERVER_ERRORS = -32099L;
        public static final long MAX_RESERVED_CODE_FOR_IMPLEMENTATION_DEFINED_SERVER_ERRORS = -32000L;
        private long code;
        @NotNull
        private String message;
        private T data;

        public String toString() {
            return super.toString() + "{code=" + this.code + ",message=" + this.message + ",data=" + this.data + "}";
        }

        public long getCode() {
            return this.code;
        }

        public void setCode(long code) {
            this.code = code;
        }

        @JsonIgnore
        @JsonbTransient
        public boolean isCodeReservedForPredefinedErrors() {
            return this.code >= -32768L && this.code <= -32000L;
        }

        @JsonIgnore
        @JsonbTransient
        public boolean isCodeReservedForImplementationDefinedServerErrors() {
            return this.code >= -32099L && this.code <= -32000L;
        }

        public String getMessage() {
            return this.message;
        }

        public void setMessage(String message) {
            this.message = message;
        }

        public T getData() {
            return this.data;
        }

        public void setData(T data) {
            this.data = data;
        }
    }
}

