/*
 * Decompiled with CFR 0.152.
 */
package com.github.jinahya.jsonrpc.bind.v2;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.github.jinahya.jsonrpc.bind.v2.JsonrpcObject;
import javax.json.bind.annotation.JsonbTransient;
import javax.validation.Valid;
import javax.validation.constraints.AssertTrue;
import javax.validation.constraints.NotNull;

public class ResponseObject<IdType, ResultType, ErrorType extends ErrorObject<?>>
extends JsonrpcObject<IdType> {
    public static final String PROPERTY_NAME_RESULT = "result";
    public static final String PROPERTY_NAME_ERROR = "error";
    @Valid
    private ResultType result;
    @Valid
    private ErrorType error;

    @Override
    public String toString() {
        return super.toString() + "{result=" + this.result + ",error=" + this.error + "}";
    }

    @JsonIgnore
    @JsonbTransient
    @AssertTrue(message="either the result or the error should be set exclusively")
    private @AssertTrue(message="either the result or the error should be set exclusively") boolean isResultAndErrorExclusive() {
        return this.getResult() != null ^ this.getError() != null;
    }

    public ResultType getResult() {
        return this.result;
    }

    public void setResult(ResultType result) {
        this.result = result;
    }

    public void setResultExclusively(ResultType result) {
        this.setResult(result);
        if (this.getResult() != null) {
            this.setError(null);
        }
    }

    public ErrorType getError() {
        return this.error;
    }

    public void setError(ErrorType error) {
        this.error = error;
    }

    public void setErrorExclusively(ErrorType error) {
        this.setError(error);
        if (this.getError() != null) {
            this.setResult(null);
        }
    }

    public static class ErrorObject<DataType> {
        public static final String PROPERTY_NAME_CODE = "code";
        public static final String PROPERTY_NAME_MESSAGE = "message";
        public static final String PROPERTY_NAME_DATA = "data";
        public static final long MIN_CODE_FOR_PREDEFINED_ERRORS = -32768L;
        public static final long MAX_CODE_FOR_PREDEFINED_ERRORS = -32000L;
        public static final long CODE_PARSE_ERROR = -32700L;
        public static final long CODE_INVALID_REQUEST = -32600L;
        public static final long CODE_METHOD_NOT_FOUND = -32601L;
        public static final long CODE_INVALID_PARAMS = -32602L;
        public static final long CODE_INTERNAL_ERROR = -32603L;
        public static final long MIN_CODE_FOR_IMPLEMENTATION_DEFINED_SERVER_ERRORS = -32099L;
        public static final long MAX_CODE_FOR_IMPLEMENTATION_DEFINED_SERVER_ERRORS = -32000L;
        private long code;
        @NotNull
        private String message;
        private DataType data;

        public String toString() {
            return super.toString() + "{code=" + this.code + ",message=" + this.message + ",data=" + this.data + "}";
        }

        public long getCode() {
            return this.code;
        }

        public void setCode(long code) {
            this.code = code;
        }

        public String getMessage() {
            return this.message;
        }

        public void setMessage(String message) {
            this.message = message;
        }

        public DataType getData() {
            return this.data;
        }

        public void setData(DataType data) {
            this.data = data;
        }

        public static class UnknownData
        extends ErrorObject<Object> {
        }
    }
}

