package com.github.jinahya.jsonrpc.bind;

/*-
 * #%L
 * jsonrpc-bind
 * %%
 * Copyright (C) 2019 - 2020 Jinahya, Inc.
 * %%
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * #L%
 */

/**
 * An exception for JSON-RPC binding.
 *
 * @author Jin Kwon &lt;onacit_at_gmail.com&gt;
 */
public class JsonrpcBindException extends RuntimeException {

    /**
     * Creates a new instance with specified message.
     *
     * @param message the message.
     */
    public JsonrpcBindException(final String message) {
        super(message);
    }

    /**
     * Creates a new instance with specified message and cause.
     *
     * @param message the message.
     * @param cause   the cause.
     */
    public JsonrpcBindException(final String message, final Throwable cause) {
        super(message, cause);
    }

    /**
     * Creates a new instance with specified cause.
     *
     * @param cause the cause.
     */
    public JsonrpcBindException(final Throwable cause) {
        super(cause);
    }
}
