/*
 * Decompiled with CFR 0.152.
 */
package com.github.jinahya.jsonrpc.bind.v2;

import com.github.jinahya.jsonrpc.bind.v2.JsonrpcObject;
import jakarta.validation.constraints.AssertTrue;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Pattern;
import java.beans.Transient;
import java.math.BigInteger;
import java.util.Optional;

public interface JsonrpcMessage
extends JsonrpcObject {
    @Pattern(regexp="2\\.0")
    @NotNull
    public @Pattern(regexp="2\\.0") @NotNull String getJsonrpc();

    public void setJsonrpc(String var1);

    @Transient
    public boolean hasId();

    @Transient
    @AssertTrue
    public boolean isIdContextuallyValid();

    @Transient
    public String getIdAsString();

    public void setIdAsString(String var1);

    @Transient
    public BigInteger getIdAsNumber();

    public void setIdAsNumber(BigInteger var1);

    @Transient
    default public Long getIdAsLong() {
        return Optional.ofNullable(this.getIdAsNumber()).map(BigInteger::longValueExact).orElse(null);
    }

    default public void setIdAsLong(Long id) {
        this.setIdAsNumber(Optional.ofNullable(id).map(BigInteger::valueOf).orElse(null));
    }

    @Transient
    default public Integer getIdAsInteger() {
        return Optional.ofNullable(this.getIdAsLong()).map(StrictMath::toIntExact).orElse(null);
    }

    default public void setIdAsInteger(Integer id) {
        this.setIdAsLong(Optional.ofNullable(id).map(Integer::longValue).orElse(null));
    }
}

