/*
 * Decompiled with CFR 0.152.
 */
package com.github.jinahya.jsonrpc.bind.v2;

import com.github.jinahya.jsonrpc.bind.JsonrpcBindException;
import com.github.jinahya.jsonrpc.bind.v2.JsonrpcMessage;
import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.Objects;

public interface JsonrpcMessageService<T extends JsonrpcMessage> {
    public T fromJson(Object var1);

    default public T fromJsonString(String string) {
        Objects.requireNonNull(string, "string is null");
        try (StringReader source = new StringReader(string);){
            T t = this.fromJson(source);
            return t;
        }
    }

    public void toJson(T var1, Object var2);

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    default public String toJsonString(T message) {
        Objects.requireNonNull(message, "message is null");
        try (StringWriter target = new StringWriter();){
            this.toJson(message, target);
            String string = target.toString();
            return string;
        }
        catch (IOException ioe) {
            throw new JsonrpcBindException(ioe);
        }
    }
}

