/*
 * Decompiled with CFR 0.152.
 */
package com.github.jinahya.jsonrpc.bind.v2;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Field;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.WeakHashMap;
import java.util.function.BooleanSupplier;
import java.util.function.Predicate;
import java.util.function.Supplier;

final class JsonrpcObjectHelper {
    static final Supplier<?> SUPPLYING_NULL = () -> null;
    static final BooleanSupplier SUPPLYING_TRUE = () -> Boolean.TRUE;
    static final BooleanSupplier SUPPLYING_FALSE = () -> Boolean.FALSE;
    static final Supplier<Boolean> SUPPLYING_TRUE_ = SUPPLYING_TRUE::getAsBoolean;
    static final Supplier<Boolean> SUPPLYING_FALSE_ = SUPPLYING_FALSE::getAsBoolean;
    private static final Predicate<?> EVALUATING_TRUE = t -> true;
    private static final Predicate<?> EVALUATING_FALSE = t -> false;
    private static final Map<Class<?>, Map<String, Field>> FIELDS = Collections.synchronizedMap(new WeakHashMap());
    private static final Map<Class<?>, Map<String, MethodHandle>> GETTERS = Collections.synchronizedMap(new WeakHashMap());
    private static final Map<Class<?>, Map<String, MethodHandle>> SETTERS = Collections.synchronizedMap(new WeakHashMap());

    static <T> Supplier<T> supplyingNull() {
        return SUPPLYING_NULL;
    }

    static <T> Predicate<T> evaluatingTrue() {
        return EVALUATING_TRUE;
    }

    static <T> Predicate<T> evaluatingFalse() {
        return EVALUATING_FALSE;
    }

    private static Field find(Class<?> clazz, String name) throws NoSuchFieldException {
        assert (clazz != null);
        assert (name != null);
        for (Field field : clazz.getDeclaredFields()) {
            if (!field.getName().equals(name)) continue;
            return field;
        }
        Class<?> superclass = clazz.getSuperclass();
        if (superclass == null) {
            throw new NoSuchFieldException("no field named as " + name);
        }
        return JsonrpcObjectHelper.find(superclass, name);
    }

    private static Field field(Class<?> clazz, String name) {
        assert (clazz != null);
        assert (name != null);
        return FIELDS.computeIfAbsent(clazz, c -> Collections.synchronizedMap(new HashMap())).computeIfAbsent(name, n -> {
            try {
                Field field = JsonrpcObjectHelper.find(clazz, n);
                if (!field.isAccessible()) {
                    field.setAccessible(true);
                }
                return field;
            }
            catch (NoSuchFieldException nsfe) {
                throw new RuntimeException(nsfe);
            }
        });
    }

    private static MethodHandle getter(Class<?> clazz, String name) {
        assert (clazz != null);
        assert (name != null);
        return GETTERS.computeIfAbsent(clazz, c -> Collections.synchronizedMap(new HashMap())).computeIfAbsent(name, n -> {
            try {
                return MethodHandles.lookup().unreflectGetter(JsonrpcObjectHelper.field(clazz, n));
            }
            catch (IllegalAccessException iae) {
                throw new RuntimeException(iae);
            }
        });
    }

    private static MethodHandle setter(Class<?> clazz, String name) {
        assert (clazz != null);
        assert (name != null);
        return SETTERS.computeIfAbsent(clazz, c -> Collections.synchronizedMap(new HashMap())).computeIfAbsent(name, n -> {
            try {
                return MethodHandles.lookup().unreflectSetter(JsonrpcObjectHelper.field(clazz, n));
            }
            catch (IllegalAccessException iae) {
                throw new RuntimeException(iae);
            }
        });
    }

    static Object get(Class<?> clazz, String name, Object object) {
        Objects.requireNonNull(clazz, "clazz is null");
        Objects.requireNonNull(name, "name is null");
        Objects.requireNonNull(object, "object is null");
        try {
            return JsonrpcObjectHelper.getter(clazz, name).invoke(object);
        }
        catch (Throwable t) {
            throw new RuntimeException(t);
        }
    }

    static void set(Class<?> clazz, String name, Object object, Object value) {
        Objects.requireNonNull(clazz, "clazz is null");
        Objects.requireNonNull(name, "name is null");
        Objects.requireNonNull(object, "object is null");
        try {
            JsonrpcObjectHelper.setter(clazz, name).invoke(object, value);
        }
        catch (Throwable t) {
            throw new RuntimeException(t);
        }
    }

    private JsonrpcObjectHelper() {
        throw new AssertionError((Object)"instantiation is not allowed");
    }
}

