/*
 * Decompiled with CFR 0.152.
 */
package com.github.jinahya.jsonrpc.bind.v2;

import com.github.jinahya.jsonrpc.bind.v2.JsonrpcMessage;
import com.github.jinahya.jsonrpc.bind.v2.JsonrpcRequestMessageService;
import jakarta.validation.constraints.AssertFalse;
import jakarta.validation.constraints.AssertTrue;
import jakarta.validation.constraints.NotBlank;
import java.beans.Transient;
import java.util.List;
import java.util.Objects;
import java.util.ServiceLoader;

public interface JsonrpcRequestMessage
extends JsonrpcMessage {
    public static JsonrpcRequestMessage newInstance() {
        return ServiceLoader.load(JsonrpcRequestMessage.class).iterator().next();
    }

    public static JsonrpcRequestMessage fromJson(Object source) {
        Objects.requireNonNull(source, "source is null");
        return (JsonrpcRequestMessage)ServiceLoader.load(JsonrpcRequestMessageService.class).iterator().next().fromJson(source);
    }

    default public void toJson(Object target) {
        Objects.requireNonNull(target, "target is null");
        ServiceLoader.load(JsonrpcRequestMessageService.class).iterator().next().toJson(this, target);
    }

    default public String toJson() {
        return ServiceLoader.load(JsonrpcRequestMessageService.class).iterator().next().toJsonString(this);
    }

    @Transient
    default public boolean isNotification() {
        return !this.hasId();
    }

    @NotBlank
    public String getMethod();

    public void setMethod(String var1);

    @Transient
    @AssertFalse
    default public boolean isMethodReservedForRpcInternal() {
        String method = this.getMethod();
        return method == null || method.startsWith("rpc.");
    }

    @Transient
    public boolean hasParams();

    @Transient
    @AssertTrue
    public boolean isParamsContextuallyValid();

    public <T> List<T> getParamsAsArray(Class<T> var1);

    public void setParamsAsArray(List<?> var1);

    public <T> T getParamsAsObject(Class<T> var1);

    public void setParamsAsObject(Object var1);
}

