/*
 * Decompiled with CFR 0.152.
 */
package com.github.jinahya.jsonrpc.bind.v2;

import com.github.jinahya.jsonrpc.bind.v2.JsonrpcMessage;
import com.github.jinahya.jsonrpc.bind.v2.JsonrpcResponseMessageError;
import com.github.jinahya.jsonrpc.bind.v2.JsonrpcResponseMessageService;
import jakarta.validation.constraints.AssertTrue;
import java.beans.Transient;
import java.util.List;
import java.util.Objects;
import java.util.ServiceLoader;

public interface JsonrpcResponseMessage
extends JsonrpcMessage {
    public static JsonrpcResponseMessage newInstance() {
        return ServiceLoader.load(JsonrpcResponseMessage.class).iterator().next();
    }

    public static JsonrpcResponseMessage fromJson(Object source) {
        Objects.requireNonNull(source, "source is null");
        return (JsonrpcResponseMessage)ServiceLoader.load(JsonrpcResponseMessageService.class).iterator().next().fromJson(source);
    }

    default public void toJson(Object target) {
        Objects.requireNonNull(target, "target is null");
        ServiceLoader.load(JsonrpcResponseMessageService.class).iterator().next().toJson(this, target);
    }

    default public String toJson() {
        return ServiceLoader.load(JsonrpcResponseMessageService.class).iterator().next().toJsonString(this);
    }

    @Transient
    @AssertTrue
    default public boolean isResultAndErrorExclusive() {
        return this.hasResult() ^ this.hasError();
    }

    @Transient
    public boolean hasResult();

    @Transient
    @AssertTrue
    default public boolean isResultContextuallyValid() {
        return true;
    }

    @Transient
    public <T> List<T> getResultAsArray(Class<T> var1);

    public void setResultAsArray(List<?> var1);

    @Transient
    public <T> T getResultAsObject(Class<T> var1);

    public void setResultAsObject(Object var1);

    @Transient
    public boolean hasError();

    @Transient
    @AssertTrue
    default public boolean isErrorContextuallyValid() {
        return true;
    }

    @Transient
    public JsonrpcResponseMessageError getErrorAs();

    public void setErrorAs(JsonrpcResponseMessageError var1);
}

