/*
 * Decompiled with CFR 0.152.
 */
package com.microfocus.plugins.attribution.datamodel.utils;

import org.apache.maven.plugin.logging.SystemStreamLog;

public class ServiceLog
extends SystemStreamLog {
    private LogLevel currentLogLevel = LogLevel.INFO;

    public void setLogLevel(LogLevel logLevel) {
        this.currentLogLevel = logLevel;
    }

    public LogLevel getLogLevel() {
        return this.currentLogLevel;
    }

    public boolean isDebugEnabled() {
        return this.currentLogLevel.equalsOrIsMoreRestrictiveThan(LogLevel.DEBUG);
    }

    public boolean isInfoEnabled() {
        return this.currentLogLevel.equalsOrIsMoreRestrictiveThan(LogLevel.INFO);
    }

    public boolean isWarnEnabled() {
        return this.currentLogLevel.equalsOrIsMoreRestrictiveThan(LogLevel.WARN);
    }

    public boolean isErrorEnabled() {
        return this.currentLogLevel.equalsOrIsMoreRestrictiveThan(LogLevel.ERROR);
    }

    public void debug(CharSequence content) {
        if (this.isDebugEnabled()) {
            super.debug(content);
        }
    }

    public void debug(CharSequence content, Throwable error) {
        if (this.isDebugEnabled()) {
            super.debug(content, error);
        }
    }

    public void debug(Throwable error) {
        if (this.isDebugEnabled()) {
            super.debug(error);
        }
    }

    public void info(CharSequence content) {
        if (this.isInfoEnabled()) {
            super.info(content);
        }
    }

    public void info(CharSequence content, Throwable error) {
        if (this.isInfoEnabled()) {
            super.info(content, error);
        }
    }

    public void info(Throwable error) {
        if (this.isInfoEnabled()) {
            super.info(error);
        }
    }

    public void warn(CharSequence content) {
        if (this.isWarnEnabled()) {
            super.warn(content);
        }
    }

    public void warn(CharSequence content, Throwable error) {
        if (this.isWarnEnabled()) {
            super.warn(content, error);
        }
    }

    public void warn(Throwable error) {
        if (this.isWarnEnabled()) {
            super.warn(error);
        }
    }

    public void error(CharSequence content) {
        if (this.isErrorEnabled()) {
            super.error(content);
        }
    }

    public void error(CharSequence content, Throwable error) {
        if (this.isErrorEnabled()) {
            super.error(content, error);
        }
    }

    public void error(Throwable error) {
        if (this.isErrorEnabled()) {
            super.error(error);
        }
    }

    public static enum LogLevel {
        NONE(0),
        DEBUG(1),
        INFO(2),
        WARN(3),
        ERROR(4);

        private int rank;

        private LogLevel(int rank) {
            this.rank = rank;
        }

        public boolean equalsOrIsMoreRestrictiveThan(LogLevel logLevel) {
            return this.rank >= logLevel.rank;
        }
    }
}

