/*
 * Decompiled with CFR 0.152.
 */
package com.microfocus.plugins.attribution.mojos;

import com.microfocus.plugins.attribution.datamodel.beans.DependencyOverride;
import com.microfocus.plugins.attribution.datamodel.beans.ProjectDependency;
import com.microfocus.plugins.attribution.datamodel.services.DependenciesService;
import com.microfocus.plugins.attribution.datamodel.services.ReportsService;
import java.io.File;
import java.util.List;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.apache.maven.settings.Settings;

@Mojo(name="generate-attribution-file", requiresProject=true, requiresDependencyResolution=ResolutionScope.TEST)
public class AttributionMojo
extends AbstractMojo {
    @Parameter(defaultValue="${project}", readonly=true, required=true)
    protected MavenProject project;
    @Parameter(defaultValue="${settings}", readonly=true, required=true)
    protected Settings settings;
    @Parameter(readonly=true)
    protected ArtifactRepository localRepository;
    @Parameter(readonly=true)
    protected DependencyOverride[] dependencyOverrides;
    @Parameter(defaultValue="${project.build.directory}/attribution.xml", readonly=true, required=true)
    protected File outputFile;
    @Parameter(readonly=true, required=false)
    protected boolean forceRegeneration;
    @Component
    DependenciesService dependenciesService;
    @Component
    ReportsService reportsService;

    public void execute() throws MojoExecutionException, MojoFailureException {
        File pomFile = this.project.getFile();
        if (pomFile.exists()) {
            boolean outputFileOutOfDate;
            boolean bl = outputFileOutOfDate = pomFile.lastModified() > this.outputFile.lastModified();
            if (outputFileOutOfDate || this.forceRegeneration) {
                this.getLog().info((CharSequence)"Building project dependencies list...");
                List<ProjectDependency> projectDependencies = this.dependenciesService.getProjectDependencies(this.project, this.settings, this.localRepository, this.dependencyOverrides);
                this.getLog().info((CharSequence)("Writing output file: " + this.outputFile.getAbsolutePath()));
                this.reportsService.createAttributionXmlFile(projectDependencies, this.outputFile);
            } else {
                this.getLog().info((CharSequence)("Maven project file hasn't changed.  Output file does not need to be regenerated: " + this.outputFile.getAbsolutePath()));
            }
        } else {
            this.getLog().info((CharSequence)"A maven project file is required.");
        }
    }
}

