/*
 * Decompiled with CFR 0.152.
 */
package com.github.jknack.handlebars;

import com.github.jknack.handlebars.Handlebars;
import com.github.jknack.handlebars.Helper;
import com.github.jknack.handlebars.Options;
import com.github.jknack.handlebars.internal.Locales;
import humanize.Humanize;
import java.io.IOException;
import java.util.Date;
import java.util.Locale;
import java.util.Objects;

public enum HumanizeHelper implements Helper<Object>
{
    binaryPrefix{

        public Object apply(Object value, Options options) throws IOException {
            return Humanize.binaryPrefix((Number)((Number)value), (Locale)1.resolveLocale(options));
        }
    }
    ,
    camelize{

        public Object apply(Object value, Options options) throws IOException {
            Boolean capFirst = (Boolean)options.hash("capFirst", (Object)true);
            return Humanize.camelize((String)((String)value), (boolean)capFirst);
        }
    }
    ,
    capitalize{

        public Object apply(Object value, Options options) throws IOException {
            return Humanize.capitalize((String)((String)value));
        }
    }
    ,
    decamelize{

        public Object apply(Object value, Options options) throws IOException {
            String replacement = (String)options.hash("replacement", (Object)" ");
            return Humanize.decamelize((String)((String)value), (String)replacement);
        }
    }
    ,
    formatCurrency{

        public Object apply(Object value, Options options) throws IOException {
            return Humanize.formatCurrency((Number)((Number)value), (Locale)5.resolveLocale(options));
        }
    }
    ,
    formatPercent{

        public Object apply(Object value, Options options) throws IOException {
            return Humanize.formatPercent((Number)((Number)value), (Locale)6.resolveLocale(options));
        }
    }
    ,
    metricPrefix{

        public Object apply(Object value, Options options) throws IOException {
            return Humanize.metricPrefix((Number)((Number)value), (Locale)7.resolveLocale(options));
        }
    }
    ,
    naturalDay{

        public Object apply(Object value, Options options) throws IOException {
            return Humanize.naturalDay((Date)((Date)value));
        }
    }
    ,
    naturalTime{

        public Object apply(Object value, Options options) throws IOException {
            return Humanize.naturalTime((Date)((Date)value), (Locale)9.resolveLocale(options));
        }
    }
    ,
    ordinal{

        public Object apply(Object value, Options options) throws IOException {
            return Humanize.ordinal((Number)((Number)value), (Locale)10.resolveLocale(options));
        }
    }
    ,
    pluralize{

        public Object apply(Object value, Options options) throws IOException {
            return Humanize.pluralizeFormat((String)((String)value), (Locale)11.resolveLocale(options)).render(options.params);
        }
    }
    ,
    slugify{

        public Object apply(Object value, Options options) throws IOException {
            return Humanize.slugify((String)((String)value));
        }
    }
    ,
    spellNumber{

        public Object apply(Object value, Options options) throws IOException {
            return Humanize.spellBigNumber((Number)((Number)value), (Locale)13.resolveLocale(options));
        }
    }
    ,
    spellDigit{

        public Object apply(Object value, Options options) throws IOException {
            return Humanize.spellDigit((Number)((Number)value), (Locale)14.resolveLocale(options));
        }
    }
    ,
    titleize{

        public Object apply(Object value, Options options) throws IOException {
            return Humanize.titleize((String)((String)value));
        }
    }
    ,
    transliterate{

        public Object apply(Object value, Options options) throws IOException {
            return Humanize.transliterate((String)((String)value));
        }
    }
    ,
    underscore{

        public Object apply(Object value, Options options) throws IOException {
            return Humanize.underscore((String)((String)value));
        }
    }
    ,
    wordWrap{

        public Object apply(Object value, Options options) throws IOException {
            Number length = (Number)options.param(0, null);
            Objects.requireNonNull(length, "found 'null', expected 'word wrap length'");
            return Humanize.wordWrap((String)((String)value), (int)length.intValue());
        }
    };


    protected static Locale resolveLocale(Options options) {
        String locale = (String)options.hash("locale", (Object)Locale.getDefault().toString());
        return Locales.fromString((String)locale);
    }

    public static void register(Handlebars handlebars) {
        for (HumanizeHelper helper : HumanizeHelper.values()) {
            handlebars.registerHelper(helper.name(), (Helper)helper);
        }
    }
}

