/*
 * Decompiled with CFR 0.152.
 */
package com.github.jknack.handlebars;

import com.github.jknack.handlebars.Context;
import com.github.jknack.handlebars.Handlebars;
import com.github.jknack.handlebars.Template;
import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.Validate;

public class Options {
    public final Handlebars handlebars;
    public final Context context;
    public final Template fn;
    public final Template inverse;
    public final Object[] params;
    public final Map<String, Object> hash;

    public Options(Handlebars handlebars, Context context, Template fn, Template inverse, Object[] params, Map<String, Object> hash) {
        this.handlebars = (Handlebars)Validate.notNull((Object)handlebars, (String)"The handlebars is required.", (Object[])new Object[0]);
        this.context = (Context)Validate.notNull((Object)context, (String)"The context is required", (Object[])new Object[0]);
        this.fn = (Template)Validate.notNull((Object)fn, (String)"The template is required.", (Object[])new Object[0]);
        this.inverse = (Template)Validate.notNull((Object)inverse, (String)"The inverse template is required.", (Object[])new Object[0]);
        this.params = (Object[])Validate.notNull((Object)params, (String)"The parameters are required.", (Object[])new Object[0]);
        this.hash = (Map)Validate.notNull(hash, (String)"The hash are required.", (Object[])new Object[0]);
    }

    public CharSequence fn() throws IOException {
        return this.fn(this.context);
    }

    public CharSequence fn(Object context) throws IOException {
        return this.apply(this.fn, context);
    }

    public CharSequence inverse() throws IOException {
        return this.inverse(this.context);
    }

    public CharSequence inverse(Object context) throws IOException {
        return this.apply(this.inverse, context);
    }

    public CharSequence apply(Template template, Object context) throws IOException {
        return template.apply(this.wrap(context));
    }

    public CharSequence apply(Template template) throws IOException {
        return this.apply(template, this.context);
    }

    public <T> T param(int index) {
        return (T)this.params[index];
    }

    public <T> T param(int index, T defaultValue) {
        Object value = null;
        if (index >= 0 && index < this.params.length) {
            value = this.params[index];
        }
        return (T)(value == null ? defaultValue : value);
    }

    public <T> T get(String name, T defaultValue) {
        Object value = this.context.get(name);
        return (T)(value == null ? defaultValue : value);
    }

    public <T> T get(String name) {
        return this.get(name, null);
    }

    public Template partial(String path) {
        return this.partials().get(path);
    }

    public void partial(String path, Template partial) {
        this.partials().put(path, partial);
    }

    public <T> T hash(String name) {
        return this.hash(name, null);
    }

    public <T> T hash(String name, Object defaultValue) {
        Object value = this.hash.get(name);
        return (T)(value == null ? defaultValue : value);
    }

    public boolean isFalsy(Object value) {
        return Handlebars.Utils.isEmpty(value);
    }

    public Context wrap(Object model) {
        if (model == this.context) {
            return this.context;
        }
        if (model == this.context.model()) {
            return this.context;
        }
        if (model instanceof Context) {
            return (Context)model;
        }
        return Context.newContext(this.context, model);
    }

    public <T> T data(String name) {
        return this.context.data(name);
    }

    public void data(String name, Object value) {
        this.context.data(name, value);
    }

    public Set<Map.Entry<String, Object>> propertySet(Object context) {
        return this.context.propertySet(context instanceof Context ? ((Context)context).model() : context);
    }

    private Map<String, Template> partials() {
        return (Map)this.data(Context.PARTIALS);
    }

    public static class Builder {
        private Handlebars handlebars;
        private Context context;
        private Template fn;
        private Template inverse = Template.EMPTY;
        private Object[] params = new Object[0];
        private Map<String, Object> hash = Collections.emptyMap();

        public Builder(Handlebars handlebars, Context context, Template fn) {
            this.handlebars = (Handlebars)Validate.notNull((Object)handlebars, (String)"The handlebars is required.", (Object[])new Object[0]);
            this.context = (Context)Validate.notNull((Object)context, (String)"The context is required.", (Object[])new Object[0]);
            this.fn = (Template)Validate.notNull((Object)fn, (String)"The fn template is required.", (Object[])new Object[0]);
        }

        public Options build() {
            Options options = new Options(this.handlebars, this.context, this.fn, this.inverse, this.params, this.hash);
            this.handlebars = null;
            this.context = null;
            this.fn = null;
            this.inverse = null;
            this.params = null;
            this.hash = null;
            return options;
        }

        public Builder setHash(Map<String, Object> hash) {
            this.hash = (Map)Validate.notNull(hash, (String)"The hash is required.", (Object[])new Object[0]);
            return this;
        }

        public Builder setInverse(Template inverse) {
            this.inverse = (Template)Validate.notNull((Object)inverse, (String)"The inverse is required.", (Object[])new Object[0]);
            return this;
        }

        public Builder setParams(Object[] params) {
            this.params = (Object[])Validate.notNull((Object)params, (String)"The params is required.", (Object[])new Object[0]);
            return this;
        }
    }
}

