/*
 * Decompiled with CFR 0.152.
 */
package com.github.jknack.handlebars.helper;

import com.github.jknack.handlebars.Handlebars;
import com.github.jknack.handlebars.Helper;
import com.github.jknack.handlebars.Options;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.Enumeration;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.LocaleUtils;
import org.apache.commons.lang3.StringEscapeUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;

public enum I18nHelper implements Helper<String>
{
    i18n{

        @Override
        public CharSequence apply(String key, Options options) throws IOException {
            Validate.notEmpty((CharSequence)key, (String)"found: '%s', expected 'bundle's key'", (Object[])new Object[]{key});
            Locale locale = LocaleUtils.toLocale((String)((String)options.hash("locale", this.defaultLocale.toString())));
            String baseName = (String)options.hash("bundle", this.defaultBundle);
            ResourceBundle bundle = ResourceBundle.getBundle(baseName, locale);
            Validate.isTrue((boolean)bundle.containsKey(key), (String)"no message found: '%s' for locale '%s' using '%s'.", (Object[])new Object[]{key, locale, baseName});
            String message = bundle.getString(key);
            if (options.params.length == 0) {
                return message;
            }
            MessageFormat format = new MessageFormat(message, locale);
            return format.format(options.params);
        }
    }
    ,
    i18nJs{
        private final Pattern pattern = Pattern.compile("\\{(\\d+.*)\\}");

        @Override
        public CharSequence apply(String localeName, Options options) throws IOException {
            Locale locale = LocaleUtils.toLocale((String)StringUtils.defaultString((String)localeName, (String)this.defaultLocale.toString()));
            String baseName = (String)options.hash("bundle", this.defaultBundle);
            ResourceBundle bundle = ResourceBundle.getBundle(baseName, locale);
            StringBuilder buffer = new StringBuilder();
            buffer.append("<script type='text/javascript'>\n");
            buffer.append("  I18n.defaultLocale = '").append(this.defaultLocale).append("';\n");
            buffer.append("  I18n.locale = '").append(this.defaultLocale).append("';\n");
            buffer.append("  I18n.translations = I18n.translations || {};\n");
            buffer.append("  // ").append(locale.getDisplayName()).append("\n");
            buffer.append("  I18n.translations['").append(locale.toString()).append("'] = {\n");
            StringBuilder body = new StringBuilder();
            String separator = ",\n";
            Enumeration<String> keys = bundle.getKeys();
            while (keys.hasMoreElements()) {
                String key = keys.nextElement();
                String message = this.message(bundle.getString(key));
                body.append("    \"").append(key).append("\": ");
                body.append("\"").append(message).append("\"").append(separator);
            }
            if (body.length() > 0) {
                body.setLength(body.length() - separator.length());
                buffer.append((CharSequence)body);
            }
            return new Handlebars.SafeString(buffer.append("\n  };\n").append("</script>\n"));
        }

        private String message(String message) {
            Matcher matcher = this.pattern.matcher(message);
            StringBuffer result = new StringBuffer();
            while (matcher.find()) {
                matcher.appendReplacement(result, "{{arg" + matcher.group(1) + "}}");
            }
            matcher.appendTail(result);
            return StringEscapeUtils.escapeEcmaScript((String)result.toString());
        }
    };

    protected Locale defaultLocale = Locale.getDefault();
    protected String defaultBundle = "messages";

    public void registerHelper(Handlebars handlebars) {
        Validate.notNull((Object)handlebars, (String)"The handlebars is required.", (Object[])new Object[0]);
        handlebars.registerHelper(this.name(), this);
    }

    public static void registerHelpers(Handlebars handlebars) {
        for (I18nHelper helper : I18nHelper.values()) {
            helper.registerHelper(handlebars);
        }
    }
}

