/*
 * Decompiled with CFR 0.152.
 */
package com.github.jknack.handlebars.helper;

import com.github.jknack.handlebars.Handlebars;
import com.github.jknack.handlebars.Helper;
import com.github.jknack.handlebars.Options;
import com.github.jknack.handlebars.Template;
import com.github.jknack.handlebars.io.TemplateLoader;
import java.io.IOException;
import java.net.URI;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;

public final class PrecompileHelper
implements Helper<String> {
    public static final String NAME = "precompile";
    public static final Helper<String> INSTANCE = new PrecompileHelper();

    private PrecompileHelper() {
    }

    @Override
    public CharSequence apply(String path, Options options) throws IOException {
        Validate.notEmpty((CharSequence)path, (String)"found: '%s', expected 'template path'", (Object[])new Object[]{path});
        String wrapperName = (String)options.hash("wrapper", "anonymous");
        JsWrapper wrapper = JsWrapper.wrapper(wrapperName);
        Validate.notNull((Object)((Object)wrapper), (String)"found '%s', expected: '%s'", (Object[])new Object[]{wrapperName, StringUtils.join((Object[])JsWrapper.values(), (String)", ").toLowerCase()});
        Handlebars handlebars = options.handlebars;
        TemplateLoader loader = handlebars.getLoader();
        String name = path + loader.getSuffix();
        Template template = handlebars.compile(URI.create(path));
        String precompiled = template.toJavaScript();
        return new Handlebars.SafeString(wrapper.wrap(name, precompiled));
    }

    private static enum JsWrapper {
        ANONYMOUS{

            @Override
            public void header(String name, StringBuilder buffer) {
                buffer.append("(function() {");
            }

            @Override
            public void tail(StringBuilder buffer) {
                buffer.append("})();");
            }
        }
        ,
        AMD{

            @Override
            public void header(String name, StringBuilder buffer) {
                buffer.append("define('").append(name).append("', ['handlebars'], function(Handlebars) {");
            }

            @Override
            public void tail(StringBuilder buffer) {
                buffer.append("});");
            }
        }
        ,
        NONE{

            @Override
            public void header(String name, StringBuilder buffer) {
            }

            @Override
            public void tail(StringBuilder buffer) {
            }

            @Override
            public void registerTemplate(StringBuilder buffer, String name, String function) {
                buffer.append(function);
            }
        };


        public abstract void header(String var1, StringBuilder var2);

        public abstract void tail(StringBuilder var1);

        public void registerTemplate(StringBuilder buffer, String name, String function) {
            buffer.append("\n  var template = Handlebars.template, ").append("templates = Handlebars.templates = Handlebars.templates ").append("|| {};\n");
            buffer.append("templates['").append(name).append("'] = template(").append(function).append(");\n");
        }

        public CharSequence wrap(String name, String function) {
            StringBuilder buffer = new StringBuilder();
            this.header(name, buffer);
            this.registerTemplate(buffer, name, function);
            this.tail(buffer);
            return buffer;
        }

        public static JsWrapper wrapper(String name) {
            for (JsWrapper wrapper : JsWrapper.values()) {
                if (!name.equalsIgnoreCase(wrapper.name())) continue;
                return wrapper;
            }
            return null;
        }
    }
}

