/*
 * Decompiled with CFR 0.152.
 */
package com.github.jknack.handlebars.io;

import com.github.jknack.handlebars.io.TemplateLoader;
import com.github.jknack.handlebars.io.TemplateSource;
import com.github.jknack.handlebars.io.URLTemplateSource;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URI;
import java.net.URL;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;

public abstract class URLTemplateLoader
implements TemplateLoader {
    private String prefix = "/";
    private String suffix = ".hbs";

    @Override
    public TemplateSource sourceAt(URI uri) throws IOException {
        Validate.notNull((Object)uri, (String)"The uri is required.", (Object[])new Object[0]);
        Validate.notEmpty((CharSequence)uri.toString(), (String)"The uri is required.", (Object[])new Object[0]);
        String location = this.resolve(this.normalize(uri));
        URL resource = this.getResource(location);
        if (resource == null) {
            throw new FileNotFoundException(location);
        }
        return new URLTemplateSource(location, resource);
    }

    protected abstract URL getResource(String var1) throws IOException;

    @Override
    public String resolve(URI uri) {
        return this.prefix + this.normalize(uri) + this.suffix;
    }

    protected URI normalize(URI uri) {
        if (uri.toString().startsWith("/")) {
            return URI.create(uri.toString().substring(1));
        }
        return uri;
    }

    public void setPrefix(String prefix) {
        this.prefix = (String)Validate.notNull((Object)prefix, (String)"A view prefix is required.", (Object[])new Object[0]);
        if (!this.prefix.endsWith("/")) {
            this.prefix = this.prefix + "/";
        }
    }

    public void setSuffix(String suffix) {
        this.suffix = StringUtils.defaultString((String)suffix, (String)"");
    }

    @Override
    public String getPrefix() {
        return this.prefix;
    }

    @Override
    public String getSuffix() {
        return this.suffix;
    }
}

