/*
 * Decompiled with CFR 0.152.
 */
package com.github.jknack.handlebars.internal;

import com.github.jknack.handlebars.Handlebars;
import com.github.jknack.handlebars.HandlebarsException;
import com.github.jknack.handlebars.Template;
import com.github.jknack.handlebars.TemplateLoader;
import com.github.jknack.handlebars.internal.BaseTemplate;
import com.github.jknack.handlebars.internal.Blank;
import com.github.jknack.handlebars.internal.Block;
import com.github.jknack.handlebars.internal.ErrorFormatter;
import com.github.jknack.handlebars.internal.Partial;
import com.github.jknack.handlebars.internal.Stacktrace;
import com.github.jknack.handlebars.internal.TemplateList;
import com.github.jknack.handlebars.internal.Text;
import com.github.jknack.handlebars.internal.Variable;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.parboiled.Action;
import org.parboiled.BaseParser;
import org.parboiled.Context;
import org.parboiled.MatchHandler;
import org.parboiled.MatcherContext;
import org.parboiled.Parboiled;
import org.parboiled.Rule;
import org.parboiled.annotations.DontLabel;
import org.parboiled.annotations.Label;
import org.parboiled.annotations.MemoMismatches;
import org.parboiled.buffers.InputBuffer;
import org.parboiled.common.Preconditions;
import org.parboiled.errors.ActionException;
import org.parboiled.errors.InvalidInputError;
import org.parboiled.errors.ParseError;
import org.parboiled.errors.ParserRuntimeException;
import org.parboiled.matchers.Matcher;
import org.parboiled.matchervisitors.IsSingleCharMatcherVisitor;
import org.parboiled.matchervisitors.MatcherVisitor;
import org.parboiled.parserunners.AbstractParseRunner;
import org.parboiled.parserunners.ParseRunner;
import org.parboiled.parserunners.ReportingParseRunner;
import org.parboiled.support.MatcherPath;
import org.parboiled.support.ParsingResult;
import org.parboiled.support.Position;
import org.parboiled.support.StringVar;
import org.parboiled.support.ValueStack;
import org.parboiled.support.Var;

public class Parser
extends BaseParser<BaseTemplate> {
    protected String startDelimiter;
    protected String endDelimiter;
    protected final List<BaseTemplate> line = new LinkedList<BaseTemplate>();
    protected final List<BaseTemplate> ignored = new LinkedList<BaseTemplate>();
    protected boolean onlyWhites = true;
    protected final Handlebars handlebars;
    protected final Map<String, Partial> partials;
    protected final String filename;
    protected final LinkedList<Stacktrace> stacktraceList;
    protected int noffset = 0;

    Parser(Handlebars handlebars, String filename, Map<String, Partial> partials, String startDelimiter, String endDelimiter, LinkedList<Stacktrace> stacktrace) {
        this.handlebars = handlebars;
        this.filename = handlebars == null ? null : handlebars.getTemplateLoader().resolve(filename);
        this.partials = partials == null ? new HashMap() : partials;
        this.startDelimiter = startDelimiter;
        this.endDelimiter = endDelimiter;
        this.stacktraceList = stacktrace;
    }

    private static Parser create(Handlebars handlebars, String filename, Map<String, Partial> partials, String startDelimiter, String endDelimiter, LinkedList<Stacktrace> stacktrace) {
        return (Parser)Parboiled.createParser(Parser.class, (Object[])new Object[]{handlebars, filename, partials, startDelimiter, endDelimiter, stacktrace});
    }

    public static Parser create(Handlebars handlebars, String filename, String startDelimiter, String endDelimiter) {
        return Parser.create(handlebars, filename, null, startDelimiter, endDelimiter, new LinkedList<Stacktrace>());
    }

    public static void initialize() {
        Parser.create(null, null, null, null);
    }

    public Template parse(String input) throws IOException {
        try {
            SafeReportingParseRunner runner = new SafeReportingParseRunner(this.template());
            ParsingResult result = runner.run(input);
            if (result.hasErrors()) {
                ParseError error = (ParseError)result.parseErrors.get(0);
                String msg = ErrorFormatter.printParseError(this.filename, error, this.noffset, this.stacktraceList);
                throw new HandlebarsException(msg);
            }
            TemplateList sequence = (TemplateList)result.resultValue;
            this.removeBlanks(sequence);
            if (sequence.size() == 1) {
                return sequence.iterator().next();
            }
            return sequence;
        }
        catch (ParserRuntimeException ex) {
            Throwable cause;
            Throwable throwable = cause = ex.getCause() == null ? ex : ex.getCause();
            if (cause instanceof HandlebarsException) {
                throw (HandlebarsException)cause;
            }
            HandlebarsException hex = new HandlebarsException(cause.getMessage(), cause);
            hex.setStackTrace(ex.getStackTrace());
            throw hex;
        }
    }

    Rule template() throws IOException {
        return this.Sequence(this.body(), this.sync(), new Object[]{EOI});
    }

    Rule body() throws IOException {
        return this.Sequence(this.push(new TemplateList()), this.ZeroOrMore(this.FirstOf(this.space(), this.nl(), new Object[]{this.text(), this.Sequence(this.startDelimiter(), this.FirstOf(this.Sequence(Character.valueOf('#'), this.spacing(), new Object[]{this.block(false)}), this.Sequence(Character.valueOf('^'), this.spacing(), new Object[]{this.block(true)}), new Object[]{this.Sequence(Character.valueOf('>'), this.spacing(), new Object[]{this.partial()}), this.Sequence(Character.valueOf('&'), this.spacing(), new Object[]{this.ampersandVar()}), this.Sequence(Character.valueOf('{'), this.spacing(), new Object[]{this.tripleVar()}), this.Sequence(Character.valueOf('='), this.spacing(), new Object[]{this.delimiters()}), this.comment(), this.Sequence(this.spacing(), this.var(), new Object[0])}), new Object[0])})), new Object[0]);
    }

    Rule delimiters() {
        final StringVar newstartDelimiter = new StringVar();
        final StringVar newendDelimiter = new StringVar();
        return this.Sequence(this.newDelimiter(), newstartDelimiter.set((Object)this.match()), new Object[]{this.OneOrMore(this.spaceNoAction()), this.newDelimiter(), newendDelimiter.set((Object)this.match()), new Action<BaseTemplate>(){

            public boolean run(Context<BaseTemplate> context) {
                String start = (String)newstartDelimiter.get();
                String end = (String)newendDelimiter.get();
                if (start.length() != end.length()) {
                    Parser.this.noffset = end.length();
                    throw new ActionException("unbalanced delimiters: '" + start + "'.length != '" + end + "'.length");
                }
                return true;
            }
        }, this.spacing(), Character.valueOf('='), this.endDelimiter(), new Action<BaseTemplate>(){

            public boolean run(Context<BaseTemplate> context) {
                Parser.this.endDelimiter = (String)newendDelimiter.get();
                Parser.this.startDelimiter = (String)newstartDelimiter.get();
                Parser.this.onlyWhites = false;
                return true;
            }
        }});
    }

    @Label(value="delimiter")
    Rule newDelimiter() {
        return this.Sequence(this.delim(), this.Optional(this.delim()), new Object[0]);
    }

    @Label(value="delimiter")
    Rule delim() {
        return this.Sequence(this.TestNot(this.AnyOf(" \t\r\n=")), ANY, new Object[0]);
    }

    @Label(value="text")
    Rule text() {
        return this.Sequence(this.OneOrMore(this.TestNot(this.startDelimiter()), this.TestNot(this.spaceNoAction()), new Object[]{this.TestNot(this.nlNoAction()), ANY}), this.add(new Text(this.match())), new Object[0]);
    }

    @Label(value="variable")
    Rule ampersandVar() {
        return this.Sequence(this.varName(Variable.Type.AMPERSAND_VAR), this.spacing(), new Object[]{this.endDelimiter()});
    }

    @Label(value="variable")
    Rule tripleVar() {
        return this.Sequence(this.varName(Variable.Type.TRIPLE_VAR), this.spacing(), new Object[]{Character.valueOf('}'), this.endDelimiter()});
    }

    @Label(value="variable")
    Rule var() {
        return this.Sequence(this.varName(Variable.Type.VAR), this.spacing(), new Object[]{this.endDelimiter()});
    }

    @Label(value="variable")
    Rule varName(Variable.Type type) {
        ArrayList<Object> params = new ArrayList<Object>();
        LinkedHashMap<String, Object> hash = new LinkedHashMap<String, Object>();
        Var var = new Var();
        return this.Sequence(var.set((Object)new Token()), ((Token)var.get()).position(this.position()), new Object[]{this.qualifiedId(), ((Token)var.get()).text(this.match()), this.spacing(), this.reset(params), this.reset(hash), this.paramOrHash(params, hash), this.add(new Variable(this.handlebars, ((Token)var.get()).text, type, params, hash).filename(this.filename).position(((Token)var.get()).position.line, ((Token)var.get()).position.column))});
    }

    boolean reset(List<Object> list) {
        list.clear();
        return true;
    }

    boolean reset(Map<String, Object> map) {
        map.clear();
        return true;
    }

    boolean add(BaseTemplate template) {
        TemplateList sequence = (TemplateList)this.peek();
        sequence.add(template);
        this.addToline(template);
        return true;
    }

    boolean addToline(BaseTemplate template) {
        this.line.add(template);
        this.onlyWhites = this.onlyWhites && template instanceof Blank;
        return true;
    }

    Action<BaseTemplate> startDelimiter() {
        return new Action<BaseTemplate>(){

            public boolean run(Context<BaseTemplate> context) {
                Matcher matcher = (Matcher)Parser.this.String(Parser.this.startDelimiter);
                return matcher.match((MatcherContext)context);
            }
        };
    }

    Action<BaseTemplate> endDelimiter() {
        return new Action<BaseTemplate>(){

            public boolean run(Context<BaseTemplate> context) {
                Matcher matcher = (Matcher)Parser.this.String(Parser.this.endDelimiter);
                return matcher.match((MatcherContext)context);
            }
        };
    }

    Rule partial() throws IOException {
        final StringVar uriVar = new StringVar();
        return this.Sequence(this.path(), uriVar.set((Object)this.match()), new Object[]{new Action<BaseTemplate>(){

            public boolean run(Context<BaseTemplate> context) {
                String uri = (String)uriVar.get();
                TemplateLoader loader = Parser.this.handlebars.getTemplateLoader();
                if (uri.startsWith("/")) {
                    Parser.this.noffset = uri.length();
                    throw new ActionException("found: '" + loader.resolve(uri) + "', partial shouldn't start with '/'");
                }
                Partial partial = Parser.this.partials.get(uri);
                if (partial == null) {
                    try {
                        Position pos = context.getPosition();
                        Stacktrace stacktrace = new Stacktrace(pos.line, pos.column, Parser.this.filename);
                        Parser.this.stacktraceList.addFirst(stacktrace);
                        String input = loader.loadAsString(URI.create(uri));
                        Parser parser = Parser.create(Parser.this.handlebars, uri, Parser.this.partials, Parser.this.startDelimiter, Parser.this.endDelimiter, Parser.this.stacktraceList);
                        partial = new Partial();
                        Parser.this.partials.put(uri, partial);
                        Template template = parser.parse(input);
                        partial.template(uri, template);
                        Parser.this.stacktraceList.removeLast();
                    }
                    catch (IOException ex) {
                        Parser.this.noffset = uri.length();
                        throw new ActionException("The partial '" + loader.resolve(uri) + "' could not be found", (Throwable)ex);
                    }
                }
                return Parser.this.add(partial);
            }
        }, this.spacing(), this.endDelimiter()});
    }

    @Label(value="start-block")
    Rule block(boolean inverted) throws IOException {
        Var name = new Var();
        final Var section = new Var();
        ArrayList<Object> params = new ArrayList<Object>();
        LinkedHashMap<String, Object> hash = new LinkedHashMap<String, Object>();
        return this.Sequence(this.reset(params), this.reset(hash), new Object[]{name.set((Object)new Token()), this.blockStart((Var<Token>)name, params, hash), section.set((Object)new Block(this.handlebars, ((Token)name.get()).text, inverted, params, hash).startDelimiter(this.startDelimiter).endDelimiter(this.endDelimiter).position(((Token)name.get()).position.line, ((Token)name.get()).position.column).filename(this.filename)), this.add((BaseTemplate)section.get()), this.body(), this.Optional(this.Sequence(this.startDelimiter(), this.spacing(), new Object[]{this.elseKey(), this.spacing(), this.endDelimiter()}), this.body(), new Object[]{new Action<BaseTemplate>(){

            public boolean run(Context<BaseTemplate> context) {
                ValueStack stack = context.getValueStack();
                if (stack.size() > 1) {
                    BaseTemplate body = (BaseTemplate)Parser.this.pop();
                    ((Block)section.get()).inverse(body);
                }
                return Parser.this.addToline((BaseTemplate)section.get());
            }
        }}), this.blockEnd((Var<Token>)name), new Action<BaseTemplate>(){

            public boolean run(Context<BaseTemplate> context) {
                ValueStack stack = context.getValueStack();
                if (stack.size() > 1) {
                    BaseTemplate body = (BaseTemplate)Parser.this.pop();
                    ((Block)section.get()).body(body);
                }
                return Parser.this.addToline((BaseTemplate)section.get());
            }
        }}).label("block");
    }

    @Label(value="else")
    Rule elseKey() {
        return this.FirstOf("else", "^", new Object[0]);
    }

    @Label(value="start-block")
    Rule blockStart(Var<Token> name, List<Object> params, Map<String, Object> hash) {
        return this.Sequence(((Token)name.get()).position(this.position()), this.qualifiedId(), new Object[]{((Token)name.get()).text(this.match()), this.spacing(), this.reset(params), this.reset(hash), this.paramOrHash(params, hash), this.endDelimiter()});
    }

    @Label(value="end-block")
    Rule blockEnd(final Var<Token> name) {
        return this.Sequence(this.startDelimiter(), Character.valueOf('/'), new Object[]{this.spacing(), this.qualifiedId(), new Action<BaseTemplate>(){

            public boolean run(Context<BaseTemplate> context) {
                String endName = context.getMatch();
                boolean match = ((Token)name.get()).text.equals(endName);
                if (!match) {
                    Parser.this.noffset = endName.length();
                    throw new ActionException(String.format("found: '%s', expected: '%s'", endName, ((Token)name.get()).text));
                }
                return match;
            }
        }, this.spacing(), this.endDelimiter()});
    }

    @Label(value="parameter::hash")
    Rule paramOrHash(List<Object> params, final Map<String, Object> hash) {
        final Var var = new Var();
        return this.ZeroOrMore(this.FirstOf(this.Sequence(this.hash(hash), this.spacing(), new Object[0]), this.Sequence(this.param((Var<Object>)var), this.spacing(), new Object[]{new Action<BaseTemplate>(){

            public boolean run(Context<BaseTemplate> context) {
                if (!hash.isEmpty()) {
                    Parser.this.noffset = var.get().toString().length();
                    throw new ActionException("'" + var.get() + "' is out of order, a 'hash' was found previously");
                }
                return true;
            }
        }, this.add(params, var.get())}), new Object[0]));
    }

    boolean add(List<Object> list, Object value) {
        list.add(value);
        return true;
    }

    @Label(value="string")
    Rule string(Var<Object> value) {
        return this.Sequence(this.stringLiteral(), value.set((Object)this.match().replace("\\\"", "\"")), new Object[0]);
    }

    @Label(value="string")
    Rule stringLiteral() {
        return this.Sequence(Character.valueOf('\"'), this.ZeroOrMore(this.FirstOf(this.String("\\\""), this.Sequence(this.TestNot(this.AnyOf("\"\r\n")), ANY, new Object[0]), new Object[0])), new Object[]{Character.valueOf('\"')});
    }

    @Label(value="parameter::hash")
    Rule hash(Map<String, Object> hash) {
        StringVar name = new StringVar();
        Var value = new Var();
        return this.Sequence(this.qualifiedId(), name.set((Object)this.match()), new Object[]{this.spacing(), Character.valueOf('='), this.spacing(), this.Sequence(this.param((Var<Object>)value), this.add(hash, (String)name.get(), value.get()), new Object[0])});
    }

    boolean add(Map<String, Object> hash, String name, Object value) {
        hash.put(name, value);
        return true;
    }

    @Label(value="parameter::hash")
    @MemoMismatches
    Rule param(Var<Object> value) {
        return this.FirstOf(this.string(value), this.integer(value), new Object[]{this.bool(value), this.Sequence(this.qualifiedId(), value.set((Object)this.match()), new Object[0])});
    }

    @MemoMismatches
    @Label(value="id")
    Rule qualifiedId() {
        return this.FirstOf(this.Sequence(this.dot(), this.dot(), new Object[]{Character.valueOf('/'), this.qualifiedId()}), this.dot(), new Object[]{this.Sequence(this.id(), this.ZeroOrMore(this.dot(), this.id(), new Object[0]), new Object[0])});
    }

    @MemoMismatches
    @Label(value="id")
    Rule id() {
        return this.Sequence(this.TestNot(this.startDelimiter()), this.TestNot(this.elseKey()), new Object[]{this.nameStart(), this.ZeroOrMore(this.idSuffix())});
    }

    @MemoMismatches
    @Label(value="id")
    Rule idSuffix() {
        return this.FirstOf(this.propertyAccess(), this.nameEnd(), new Object[0]);
    }

    @MemoMismatches
    Rule propertyAccess() {
        return this.Sequence(this.dot(), "[", new Object[]{this.spacing(), this.idx(), this.spacing(), "]"});
    }

    @MemoMismatches
    Rule idx() {
        return this.OneOrMore(this.TestNot("]"), ANY, new Object[0]);
    }

    @MemoMismatches
    @Label(value="id")
    Rule nameStart() {
        return this.Sequence(this.TestNot(this.dot()), this.FirstOf(this.CharRange('a', 'z'), this.CharRange('A', 'Z'), new Object[]{Character.valueOf('_'), Character.valueOf('$'), Character.valueOf('@')}), new Object[0]);
    }

    @MemoMismatches
    @Label(value="id")
    Rule nameEnd() {
        return this.Sequence(this.TestNot(this.dot()), this.FirstOf(this.CharRange('a', 'z'), this.CharRange('A', 'Z'), new Object[]{this.digit(), Character.valueOf('_'), Character.valueOf('$'), Character.valueOf('-'), Character.valueOf('@')}), new Object[0]);
    }

    @MemoMismatches
    @Label(value=".")
    Rule dot() {
        return this.Ch('.');
    }

    @MemoMismatches
    Rule integer(Var<Object> var) {
        return this.Sequence(this.OneOrMore(this.digit()), var.set((Object)Integer.parseInt(this.match())), new Object[0]);
    }

    @MemoMismatches
    @Label(value="boolean")
    Rule bool(Var<Object> var) {
        return this.Sequence(this.FirstOf(this.String("true"), this.String("false"), new Object[0]), var.set((Object)Boolean.valueOf(this.match())), new Object[0]);
    }

    @MemoMismatches
    Rule path() {
        return this.Sequence(this.TestNot(this.startDelimiter(), this.endDelimiter(), new Object[0]), this.OneOrMore(this.pathSegment()), new Object[0]);
    }

    @Label(value="ignore")
    Rule spacing() {
        return this.ZeroOrMore(this.spaces());
    }

    @Label(value="ignore")
    Rule spaces() {
        return this.FirstOf(this.spaceNoAction(), this.nlNoAction(), new Object[]{this.comment()});
    }

    @Label(value="ignore")
    Rule spaceNoAction() {
        return this.AnyOf(" \t\f");
    }

    @Label(value="ignore")
    Rule space() {
        return this.Sequence(this.spaceNoAction(), new Action<BaseTemplate>(){

            public boolean run(Context<BaseTemplate> context) {
                return Parser.this.add(new Blank(context.getMatch()));
            }
        }, new Object[0]);
    }

    @Label(value="ignore")
    Rule nlNoAction() {
        return this.Sequence(this.Optional(Character.valueOf('\r')), Character.valueOf('\n'), new Object[0]);
    }

    @Label(value="ignore")
    Rule nl() {
        return this.Sequence(this.nlNoAction(), new Action<BaseTemplate>(){

            public boolean run(Context<BaseTemplate> context) {
                return Parser.this.add(new Blank(context.getMatch()));
            }
        }, new Object[]{this.sync()});
    }

    boolean sync() {
        List<BaseTemplate> currentLine = this.line;
        if (!this.onlyWhites) {
            boolean ignore = true;
            for (BaseTemplate template : currentLine) {
                Class<?> type = template.getClass();
                if (type != Text.class && type != Variable.class && type != Partial.class) continue;
                ignore = false;
                break;
            }
            if (ignore) {
                for (BaseTemplate child : currentLine) {
                    if (!(child instanceof Blank)) continue;
                    this.ignored.add(child);
                }
            }
        }
        this.onlyWhites = true;
        currentLine.clear();
        return true;
    }

    void removeBlanks(BaseTemplate head) {
        for (BaseTemplate blank : this.ignored) {
            head.remove(blank);
        }
        this.line.clear();
        this.ignored.clear();
    }

    @DontLabel
    Rule comment() {
        return this.Sequence(Character.valueOf('!'), this.ZeroOrMore(this.TestNot(this.endDelimiter()), ANY, new Object[0]), new Object[]{this.endDelimiter(), new Action<BaseTemplate>(){

            public boolean run(Context<BaseTemplate> context) {
                Parser.this.onlyWhites = false;
                return true;
            }
        }});
    }

    @MemoMismatches
    @Label(value="digit")
    Rule digit() {
        return this.CharRange('0', '9');
    }

    @MemoMismatches
    @Label(value="path")
    Rule pathSegment() {
        return this.FirstOf(this.CharRange('0', '9'), this.CharRange('a', 'z'), new Object[]{this.CharRange('A', 'Z'), Character.valueOf('_'), Character.valueOf('$'), Character.valueOf('/'), Character.valueOf('.'), Character.valueOf('-')});
    }

    private static class SafeErrorReportingParseRunner
    extends AbstractParseRunner<BaseTemplate>
    implements MatchHandler {
        private final IsSingleCharMatcherVisitor isSingleCharMatcherVisitor = new IsSingleCharMatcherVisitor();
        private final int errorIndex;
        private final MatchHandler inner;
        private final List<MatcherPath> failedMatchers = new ArrayList<MatcherPath>();
        private boolean seeking;

        public SafeErrorReportingParseRunner(Rule rule, int errorIndex) {
            this(rule, errorIndex, null);
        }

        public SafeErrorReportingParseRunner(Rule rule, int errorIndex, MatchHandler inner) {
            super(rule);
            this.errorIndex = errorIndex;
            this.inner = inner;
        }

        public ParsingResult<BaseTemplate> run(InputBuffer inputBuffer) {
            Preconditions.checkArgNotNull((Object)inputBuffer, (String)"inputBuffer");
            this.resetValueStack();
            this.failedMatchers.clear();
            this.seeking = this.errorIndex > 0;
            MatcherContext rootContext = this.createRootContext(inputBuffer, this, false);
            boolean matched = this.match(rootContext);
            if (!matched) {
                this.getParseErrors().add(new InvalidInputError(inputBuffer, this.errorIndex, this.failedMatchers, null));
            }
            return this.createParsingResult(matched, rootContext);
        }

        public boolean match(MatcherContext<?> context) {
            boolean matched;
            boolean bl = matched = this.inner == null && context.getMatcher().match(context) || this.inner != null && this.inner.match(context);
            if (context.getCurrentIndex() == this.errorIndex) {
                if (matched && this.seeking) {
                    this.seeking = false;
                }
                Matcher matcher = context.getMatcher();
                if (!matched && !this.seeking && matcher != null && ((Boolean)matcher.accept((MatcherVisitor)this.isSingleCharMatcherVisitor)).booleanValue()) {
                    this.failedMatchers.add(context.getPath());
                }
            }
            return matched;
        }
    }

    private static class SafeReportingParseRunner
    extends ReportingParseRunner<BaseTemplate> {
        public SafeReportingParseRunner(Rule rule) {
            super(rule);
        }

        protected ParsingResult<BaseTemplate> runReportingMatch(InputBuffer inputBuffer, int errorIndex) {
            ParseRunner reportingRunner = new SafeErrorReportingParseRunner((Rule)this.getRootMatcher(), errorIndex).withParseErrors(this.getParseErrors()).withValueStack(this.getValueStack());
            return reportingRunner.run(inputBuffer);
        }
    }

    static class Token {
        public String text;
        public Position position;

        Token() {
        }

        public boolean text(String text) {
            this.text = text;
            return true;
        }

        public boolean position(Position position) {
            this.position = position;
            return true;
        }
    }
}

