/*
 * Decompiled with CFR 0.152.
 */
package com.github.jknack.handlebars.internal;

import com.github.jknack.handlebars.Template;
import com.github.jknack.handlebars.internal.Files;
import java.io.IOException;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.ErrorReporter;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.mozilla.javascript.tools.ToolErrorReporter;

enum JSEngine {
    RHINO{

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public String toJavaScript(Template template) {
            Context ctx = null;
            try {
                ctx = this.newContext();
                Scriptable scope = this.newScope(ctx);
                scope.put("template", scope, (Object)template.text());
                String js = "Handlebars.precompile(template);";
                Object precompiled = ctx.evaluateString(scope, js, template.toString(), 1, null);
                String string = (String)precompiled;
                return string;
            }
            finally {
                if (ctx != null) {
                    Context.exit();
                }
            }
        }

        private Scriptable newScope(Context ctx) {
            Scriptable sharedScope = this.sharedScope(ctx);
            Scriptable scope = ctx.newObject(sharedScope);
            scope.setParentScope(null);
            scope.setPrototype(sharedScope);
            return scope;
        }

        private Context newContext() {
            Context ctx = Context.enter();
            ctx.setOptimizationLevel(-1);
            ctx.setErrorReporter((ErrorReporter)new ToolErrorReporter(false));
            ctx.setLanguageVersion(180);
            return ctx;
        }

        private Scriptable sharedScope(Context ctx) {
            ScriptableObject sharedScope = ctx.initStandardObjects();
            ctx.evaluateString((Scriptable)sharedScope, this.handlebarsScript(JSEngine.HBS_FILE), JSEngine.HBS_FILE, 1, null);
            return sharedScope;
        }

        private String handlebarsScript(String location) {
            try {
                return Files.read(location);
            }
            catch (IOException ex) {
                throw new IllegalArgumentException("Unable to read file: " + location, ex);
            }
        }
    };

    private static final String HBS_FILE = "/handlebars-v1.3.0.js";

    public abstract String toJavaScript(Template var1);
}

